/*
 * Decompiled with CFR 0.152.
 */
package android.os.flagging;

import android.compat.annotation.UnsupportedAppUsage;
import android.internal.aconfig.storage.AconfigStorageException;
import android.internal.aconfig.storage.FlagTable;
import android.internal.aconfig.storage.FlagValueList;
import android.internal.aconfig.storage.PackageTable;
import android.internal.aconfig.storage.TableUtils;
import android.os.flagging.AconfigStorageReadException;
import android.util.Log;
import java.io.Closeable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PlatformAconfigPackage {
    private static final String TAG = "PlatformAconfigPackage";
    private static final String MAP_PATH = "/metadata/aconfig/maps/";
    private static final String BOOT_PATH = "/metadata/aconfig/boot/";
    private FlagTable mFlagTable;
    private FlagValueList mFlagValueList;
    private int mPackageBooleanStartOffset = -1;
    private int mPackageId = -1;
    static final Map<String, TableUtils.StorageFilesBundle> sStorageFilesCache = new HashMap<String, TableUtils.StorageFilesBundle>();
    @UnsupportedAppUsage
    public static final Set<String> PLATFORM_PACKAGE_MAP_FILES = Set.of("system.package.map", "system_ext.package.map", "vendor.package.map", "product.package.map");

    private PlatformAconfigPackage() {
    }

    @UnsupportedAppUsage
    public static PlatformAconfigPackage load(String packageName) {
        try {
            PlatformAconfigPackage aconfigPackage = new PlatformAconfigPackage();
            TableUtils.StorageFilesBundle files = sStorageFilesCache.get(packageName);
            if (files == null) {
                return null;
            }
            PackageTable.Node pNode = files.packageTable.get(packageName);
            aconfigPackage.mFlagTable = files.flagTable;
            aconfigPackage.mFlagValueList = files.flagValueList;
            aconfigPackage.mPackageBooleanStartOffset = pNode.getBooleanStartIndex();
            aconfigPackage.mPackageId = pNode.getPackageId();
            return aconfigPackage;
        }
        catch (AconfigStorageException e) {
            throw new AconfigStorageReadException(e.getErrorCode(), "Fail to create PlatformAconfigPackage: " + packageName, e);
        }
        catch (Exception e) {
            throw new AconfigStorageReadException(0, "Fail to create PlatformAconfigPackage: " + packageName, e);
        }
    }

    @UnsupportedAppUsage
    public boolean getBooleanFlagValue(String flagName, boolean defaultValue) {
        FlagTable.Node fNode = this.mFlagTable.get(this.mPackageId, flagName);
        if (fNode == null) {
            return defaultValue;
        }
        return this.mFlagValueList.getBoolean(fNode.getFlagIndex() + this.mPackageBooleanStartOffset);
    }

    private static MappedByteBuffer mapStorageFile(String file) {
        MappedByteBuffer mappedByteBuffer;
        FileChannel channel = null;
        try {
            channel = FileChannel.open(Paths.get(file, new String[0]), StandardOpenOption.READ);
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (Exception e) {
            try {
                throw new AconfigStorageReadException(4, "Fail to mmap storage", e);
            }
            catch (Throwable throwable) {
                PlatformAconfigPackage.quietlyDispose(channel);
                throw throwable;
            }
        }
        PlatformAconfigPackage.quietlyDispose(channel);
        return mappedByteBuffer;
    }

    private static void quietlyDispose(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        for (String pf : PLATFORM_PACKAGE_MAP_FILES) {
            try {
                PackageTable pTable = PackageTable.fromBytes(PlatformAconfigPackage.mapStorageFile(MAP_PATH + pf));
                String container = pTable.getHeader().getContainer();
                FlagTable fTable = FlagTable.fromBytes(PlatformAconfigPackage.mapStorageFile(MAP_PATH + container + ".flag.map"));
                FlagValueList fValueList = FlagValueList.fromBytes(PlatformAconfigPackage.mapStorageFile(BOOT_PATH + container + ".val"));
                TableUtils.StorageFilesBundle files = new TableUtils.StorageFilesBundle(pTable, fTable, fValueList);
                for (String packageName : pTable.getPackageList()) {
                    sStorageFilesCache.put(packageName, files);
                }
            }
            catch (Exception e) {
                Log.w(TAG, ((Object)e).toString());
            }
        }
    }
}

