/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import java.util.Objects;

@FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
public class WorkDuration {
    long mActualTotalDurationNanos = 0L;
    long mWorkPeriodStartTimestampNanos = 0L;
    long mActualCpuDurationNanos = 0L;
    long mActualGpuDurationNanos = 0L;

    public WorkDuration() {
    }

    public WorkDuration(long workPeriodStartTimestampNanos, long actualTotalDurationNanos, long actualCpuDurationNanos, long actualGpuDurationNanos) {
        this.mActualTotalDurationNanos = actualTotalDurationNanos;
        this.mWorkPeriodStartTimestampNanos = workPeriodStartTimestampNanos;
        this.mActualCpuDurationNanos = actualCpuDurationNanos;
        this.mActualGpuDurationNanos = actualGpuDurationNanos;
    }

    public void setActualTotalDurationNanos(long actualTotalDurationNanos) {
        if (actualTotalDurationNanos <= 0L) {
            throw new IllegalArgumentException("the actual total duration should be greater than zero.");
        }
        this.mActualTotalDurationNanos = actualTotalDurationNanos;
    }

    public void setWorkPeriodStartTimestampNanos(long workPeriodStartTimestampNanos) {
        if (workPeriodStartTimestampNanos <= 0L) {
            throw new IllegalArgumentException("the work period start timestamp should be greater than zero.");
        }
        this.mWorkPeriodStartTimestampNanos = workPeriodStartTimestampNanos;
    }

    public void setActualCpuDurationNanos(long actualCpuDurationNanos) {
        if (actualCpuDurationNanos < 0L) {
            throw new IllegalArgumentException("the actual CPU duration should be greater than or equal to zero.");
        }
        this.mActualCpuDurationNanos = actualCpuDurationNanos;
    }

    public void setActualGpuDurationNanos(long actualGpuDurationNanos) {
        if (actualGpuDurationNanos < 0L) {
            throw new IllegalArgumentException("the actual GPU duration should be greater than or equal to zero.");
        }
        this.mActualGpuDurationNanos = actualGpuDurationNanos;
    }

    public long getActualTotalDurationNanos() {
        return this.mActualTotalDurationNanos;
    }

    public long getWorkPeriodStartTimestampNanos() {
        return this.mWorkPeriodStartTimestampNanos;
    }

    public long getActualCpuDurationNanos() {
        return this.mActualCpuDurationNanos;
    }

    public long getActualGpuDurationNanos() {
        return this.mActualGpuDurationNanos;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkDuration)) {
            return false;
        }
        WorkDuration workDuration = (WorkDuration)obj;
        return workDuration.mActualTotalDurationNanos == this.mActualTotalDurationNanos && workDuration.mWorkPeriodStartTimestampNanos == this.mWorkPeriodStartTimestampNanos && workDuration.mActualCpuDurationNanos == this.mActualCpuDurationNanos && workDuration.mActualGpuDurationNanos == this.mActualGpuDurationNanos;
    }

    public int hashCode() {
        return Objects.hash(this.mWorkPeriodStartTimestampNanos, this.mActualTotalDurationNanos, this.mActualCpuDurationNanos, this.mActualGpuDurationNanos);
    }
}

