/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.VibratorInfo;
import android.os.vibrator.BasicPwleSegment;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.PwleSegment;
import android.os.vibrator.RampSegment;
import android.os.vibrator.StepSegment;
import android.os.vibrator.VibrationEffectSegment;
import android.util.MathUtils;
import com.android.internal.hidden_from_bootclasspath.android.os.vibrator.Flags;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public abstract class VibrationEffect
implements Parcelable {
    private static final int PARCEL_TOKEN_COMPOSED = 1;
    private static final int PARCEL_TOKEN_VENDOR_EFFECT = 2;
    private static final float SCALE_GAMMA = 0.65f;
    private static final long MAX_HAPTIC_FEEDBACK_DURATION = 1000L;
    private static final long MAX_HAPTIC_FEEDBACK_COMPOSITION_SIZE = 3L;
    public static final int DEFAULT_AMPLITUDE = -1;
    public static final int MAX_AMPLITUDE = 255;
    public static final int EFFECT_CLICK = 0;
    public static final int EFFECT_DOUBLE_CLICK = 1;
    public static final int EFFECT_TICK = 2;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int EFFECT_THUD = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int EFFECT_POP = 4;
    public static final int EFFECT_HEAVY_CLICK = 5;
    public static final int EFFECT_TEXTURE_TICK = 21;
    public static final int EFFECT_STRENGTH_LIGHT = 0;
    public static final int EFFECT_STRENGTH_MEDIUM = 1;
    public static final int EFFECT_STRENGTH_STRONG = 2;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int[] RINGTONES = IntStream.rangeClosed(6, 20).toArray();
    @NonNull
    public static final Parcelable.Creator<VibrationEffect> CREATOR = new Parcelable.Creator<VibrationEffect>(){

        @Override
        public VibrationEffect createFromParcel(Parcel in) {
            switch (in.readInt()) {
                case 1: {
                    return new Composed(in);
                }
                case 2: {
                    if (!Flags.vendorVibrationEffects()) break;
                    return new VendorEffect(in);
                }
            }
            throw new IllegalStateException("Unexpected vibration effect type token in parcel.");
        }

        public VibrationEffect[] newArray(int size) {
            return new VibrationEffect[size];
        }
    };

    public static VibrationEffect createOneShot(long milliseconds, int amplitude) {
        if (amplitude == 0) {
            throw new IllegalArgumentException("amplitude must either be DEFAULT_AMPLITUDE, or between 1 and 255 inclusive (amplitude=" + amplitude + ")");
        }
        return VibrationEffect.createWaveform(new long[]{milliseconds}, new int[]{amplitude}, -1);
    }

    public static VibrationEffect createWaveform(long[] timings, int repeat) {
        int[] amplitudes = new int[timings.length];
        for (int i = 0; i < timings.length / 2; ++i) {
            amplitudes[i * 2 + 1] = -1;
        }
        return VibrationEffect.createWaveform(timings, amplitudes, repeat);
    }

    @Nullable
    public abstract long[] computeCreateWaveformOffOnTimingsOrNull();

    public static VibrationEffect createWaveform(long[] timings, int[] amplitudes, int repeat) {
        if (timings.length != amplitudes.length) {
            throw new IllegalArgumentException("timing and amplitude arrays must be of equal length (timings.length=" + timings.length + ", amplitudes.length=" + amplitudes.length + ")");
        }
        ArrayList<StepSegment> segments = new ArrayList<StepSegment>();
        for (int i = 0; i < timings.length; ++i) {
            float parsedAmplitude = amplitudes[i] == -1 ? -1.0f : (float)amplitudes[i] / 255.0f;
            segments.add(new StepSegment(parsedAmplitude, 0.0f, (int)timings[i]));
        }
        Composed effect = new Composed(segments, repeat);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    @NonNull
    public static VibrationEffect createPredefined(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    @SystemApi
    @NonNull
    @FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
    @RequiresPermission(value="android.permission.VIBRATE_VENDOR_EFFECTS")
    public static VibrationEffect createVendorEffect(@NonNull PersistableBundle effect) {
        VendorEffect vendorEffect = new VendorEffect(effect, 1, 1.0f, 1.0f);
        ((VibrationEffect)vendorEffect).validate();
        return vendorEffect;
    }

    public static VibrationEffect get(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId, boolean fallback) {
        Composed effect = new Composed(new PrebakedSegment(effectId, fallback, 1));
        ((VibrationEffect)effect).validate();
        return effect;
    }

    @Nullable
    public static VibrationEffect get(Uri uri, Context context) {
        String[] uris = context.getResources().getStringArray(17236153);
        if (uris.length == 0) {
            return null;
        }
        ContentResolver cr = context.getContentResolver();
        Uri uncanonicalUri = cr.uncanonicalize(uri);
        if (uncanonicalUri == null) {
            uncanonicalUri = uri;
        }
        for (int i = 0; i < uris.length && i < RINGTONES.length; ++i) {
            Uri mappedUri;
            if (uris[i] == null || (mappedUri = cr.uncanonicalize(Uri.parse(uris[i]))) == null || !mappedUri.equals(uncanonicalUri)) continue;
            return VibrationEffect.get(RINGTONES[i]);
        }
        return null;
    }

    @NonNull
    public static Composition startComposition() {
        return new Composition();
    }

    @NonNull
    public static WaveformBuilder startWaveform() {
        return new WaveformBuilder();
    }

    @NonNull
    public static WaveformBuilder startWaveform(@NonNull VibrationParameter initialParameter) {
        WaveformBuilder builder = VibrationEffect.startWaveform();
        builder.addTransition(Duration.ZERO, initialParameter);
        return builder;
    }

    @NonNull
    public static WaveformBuilder startWaveform(@NonNull VibrationParameter initialParameter1, @NonNull VibrationParameter initialParameter2) {
        WaveformBuilder builder = VibrationEffect.startWaveform();
        builder.addTransition(Duration.ZERO, initialParameter1, initialParameter2);
        return builder;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract void validate();

    @Nullable
    public abstract VibrationEffect cropToLengthOrNull(int var1);

    public abstract long getDuration();

    public long getDuration(@Nullable VibratorInfo vibratorInfo) {
        return this.getDuration();
    }

    public abstract boolean areVibrationFeaturesSupported(@NonNull VibratorInfo var1);

    public boolean isHapticFeedbackCandidate() {
        return false;
    }

    @NonNull
    public abstract VibrationEffect resolve(int var1);

    @NonNull
    public abstract VibrationEffect applyEffectStrength(int var1);

    @NonNull
    public abstract VibrationEffect scale(float var1);

    @NonNull
    public abstract VibrationEffect applyAdaptiveScale(float var1);

    @NonNull
    public abstract VibrationEffect applyRepeatingIndefinitely(boolean var1, int var2);

    public static float scale(float intensity, float scaleFactor) {
        if (Flags.hapticsScaleV2Enabled()) {
            if (Float.compare(scaleFactor, 1.0f) <= 0 || Float.compare(intensity, 0.0f) == 0) {
                return scaleFactor * intensity;
            }
            return scaleFactor * intensity / (1.0f + (scaleFactor - 1.0f) * intensity * intensity);
        }
        float scale = MathUtils.pow(scaleFactor, 1.5384616f);
        if (scaleFactor <= 1.0f) {
            return intensity * scale;
        }
        float extraScale = MathUtils.pow(scaleFactor, 4.0f - scaleFactor);
        float x = intensity * scale * extraScale;
        float maxX = scale * extraScale;
        float expX = MathUtils.exp(x);
        float expMaxX = MathUtils.exp(maxX);
        float a = (expMaxX + 1.0f) / (expMaxX - 1.0f);
        float fx = (expX - 1.0f) / (expX + 1.0f);
        return MathUtils.constrain(a * fx, 0.0f, 1.0f);
    }

    public static float scaleLinearly(float intensity, float scaleFactor) {
        return MathUtils.constrain(intensity * scaleFactor, 0.0f, 1.0f);
    }

    public abstract String toDebugString();

    public static String effectIdToString(int effectId) {
        String string2;
        switch (effectId) {
            case 0: {
                string2 = "CLICK";
                break;
            }
            case 2: {
                string2 = "TICK";
                break;
            }
            case 5: {
                string2 = "HEAVY_CLICK";
                break;
            }
            case 1: {
                string2 = "DOUBLE_CLICK";
                break;
            }
            case 4: {
                string2 = "POP";
                break;
            }
            case 3: {
                string2 = "THUD";
                break;
            }
            case 21: {
                string2 = "TEXTURE_TICK";
                break;
            }
            default: {
                string2 = Integer.toString(effectId);
            }
        }
        return string2;
    }

    public static String effectStrengthToString(int effectStrength) {
        String string2;
        switch (effectStrength) {
            case 0: {
                string2 = "LIGHT";
                break;
            }
            case 1: {
                string2 = "MEDIUM";
                break;
            }
            case 2: {
                string2 = "STRONG";
                break;
            }
            default: {
                string2 = Integer.toString(effectStrength);
            }
        }
        return string2;
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @NonNull
    public static VibrationEffect createRepeatingEffect(@NonNull VibrationEffect effect) {
        return VibrationEffect.startComposition().repeatEffectIndefinitely(effect).compose();
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @NonNull
    public static VibrationEffect createRepeatingEffect(@NonNull VibrationEffect preamble, @NonNull VibrationEffect repeatingEffect) {
        Preconditions.checkArgument(preamble.getDuration() < Long.MAX_VALUE, "Can't repeat an indefinitely repeating effect.");
        return VibrationEffect.startComposition().addEffect(preamble).repeatEffectIndefinitely(repeatingEffect).compose();
    }

    public static class Composed
    extends VibrationEffect {
        private final ArrayList<VibrationEffectSegment> mSegments;
        private final int mRepeatIndex;
        @NonNull
        public static final Parcelable.Creator<Composed> CREATOR = new Parcelable.Creator<Composed>(){

            @Override
            public Composed createFromParcel(Parcel in) {
                in.readInt();
                return new Composed(in);
            }

            public Composed[] newArray(int size) {
                return new Composed[size];
            }
        };

        Composed(@NonNull Parcel in) {
            this((List<? extends VibrationEffectSegment>)Objects.requireNonNull(in.readArrayList(VibrationEffectSegment.class.getClassLoader(), VibrationEffectSegment.class)), in.readInt());
        }

        Composed(@NonNull VibrationEffectSegment segment) {
            this(Arrays.asList(segment), -1);
        }

        public Composed(@NonNull List<? extends VibrationEffectSegment> segments, int repeatIndex) {
            this.mSegments = new ArrayList<VibrationEffectSegment>(segments);
            this.mRepeatIndex = repeatIndex;
        }

        @NonNull
        public List<VibrationEffectSegment> getSegments() {
            return this.mSegments;
        }

        public int getRepeatIndex() {
            return this.mRepeatIndex;
        }

        @Override
        @Nullable
        public long[] computeCreateWaveformOffOnTimingsOrNull() {
            if (this.getRepeatIndex() >= 0) {
                return null;
            }
            List<VibrationEffectSegment> segments = this.getSegments();
            long[] patternBuffer = new long[segments.size() + 1];
            int patternIndex = 0;
            for (int i = 0; i < segments.size(); ++i) {
                boolean isCurrentPatternIndexOff;
                StepSegment stepSegment = Composed.castToValidStepSegmentForOffOnTimingsOrNull(segments.get(i));
                if (stepSegment == null) {
                    return null;
                }
                boolean isSegmentOff = stepSegment.getAmplitude() == 0.0f;
                boolean bl = isCurrentPatternIndexOff = patternIndex % 2 == 0;
                if (isSegmentOff != isCurrentPatternIndexOff) {
                    // empty if block
                }
                int n = ++patternIndex;
                patternBuffer[n] = patternBuffer[n] + stepSegment.getDuration();
            }
            return Arrays.copyOf(patternBuffer, patternIndex + 1);
        }

        @Override
        public void validate() {
            int segmentCount = this.mSegments.size();
            boolean hasNonZeroDuration = false;
            for (int i = 0; i < segmentCount; ++i) {
                VibrationEffectSegment segment = this.mSegments.get(i);
                segment.validate();
                hasNonZeroDuration |= segment.getDuration() != 0L;
            }
            if (!hasNonZeroDuration) {
                throw new IllegalArgumentException("at least one timing must be non-zero (segments=" + this.mSegments + ")");
            }
            if (this.mRepeatIndex != -1) {
                Preconditions.checkArgumentInRange(this.mRepeatIndex, 0, segmentCount - 1, "repeat index must be within the bounds of the segments (segments.length=" + segmentCount + ", index=" + this.mRepeatIndex + ")");
            }
        }

        @Override
        @Nullable
        public VibrationEffect cropToLengthOrNull(int length) {
            if (this.mRepeatIndex >= 0) {
                return null;
            }
            int segmentCount = this.mSegments.size();
            if (segmentCount <= length) {
                return this;
            }
            ArrayList<VibrationEffectSegment> truncated = new ArrayList<VibrationEffectSegment>(this.mSegments.subList(0, length));
            Composed updated = new Composed(truncated, this.mRepeatIndex);
            try {
                updated.validate();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return updated;
        }

        @Override
        public long getDuration() {
            return this.getDuration(VibrationEffectSegment::getDuration);
        }

        @Override
        public long getDuration(@Nullable VibratorInfo vibratorInfo) {
            return this.getDuration((VibrationEffectSegment segment) -> segment.getDuration(vibratorInfo));
        }

        private long getDuration(Function<VibrationEffectSegment, Long> durationFn) {
            if (this.mRepeatIndex >= 0) {
                return Long.MAX_VALUE;
            }
            int segmentCount = this.mSegments.size();
            long totalDuration = 0L;
            for (int i = 0; i < segmentCount; ++i) {
                long segmentDuration = durationFn.apply(this.mSegments.get(i));
                if (segmentDuration < 0L) {
                    return segmentDuration;
                }
                totalDuration += segmentDuration;
            }
            return totalDuration;
        }

        @Override
        public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
            for (VibrationEffectSegment segment : this.mSegments) {
                if (segment.areVibrationFeaturesSupported(vibratorInfo)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            long totalDuration = this.getDuration();
            if (totalDuration > 1000L) {
                return false;
            }
            int segmentCount = this.mSegments.size();
            if ((long)segmentCount > 3L) {
                return false;
            }
            totalDuration = 0L;
            for (int i = 0; i < segmentCount; ++i) {
                if (!this.mSegments.get(i).isHapticFeedbackCandidate()) {
                    return false;
                }
                long segmentDuration = this.mSegments.get(i).getDuration();
                if (segmentDuration <= 0L) continue;
                totalDuration += segmentDuration;
            }
            return totalDuration <= 1000L;
        }

        @Override
        @NonNull
        public Composed resolve(int defaultAmplitude) {
            return this.applyToSegments(VibrationEffectSegment::resolve, defaultAmplitude);
        }

        @Override
        @NonNull
        public VibrationEffect applyEffectStrength(int effectStrength) {
            return this.applyToSegments(VibrationEffectSegment::applyEffectStrength, effectStrength);
        }

        @Override
        @NonNull
        public Composed scale(float scaleFactor) {
            return this.applyToSegments(VibrationEffectSegment::scale, Float.valueOf(scaleFactor));
        }

        @Override
        @NonNull
        public Composed applyAdaptiveScale(float scaleFactor) {
            return this.applyToSegments(VibrationEffectSegment::scaleLinearly, Float.valueOf(scaleFactor));
        }

        @Override
        @NonNull
        public Composed applyRepeatingIndefinitely(boolean wantRepeating, int loopDelayMs) {
            boolean isRepeating;
            boolean bl = isRepeating = this.mRepeatIndex >= 0;
            if (isRepeating == wantRepeating) {
                return this;
            }
            if (!wantRepeating) {
                return new Composed(this.mSegments, -1);
            }
            if (loopDelayMs <= 0) {
                return new Composed(this.mSegments, 0);
            }
            ArrayList<VibrationEffectSegment> loopingSegments = new ArrayList<VibrationEffectSegment>(this.mSegments.size() + 1);
            loopingSegments.addAll(this.mSegments);
            loopingSegments.add(new StepSegment(0.0f, 0.0f, loopDelayMs));
            return new Composed(loopingSegments, 0);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Composed)) {
                return false;
            }
            Composed other = (Composed)o;
            return this.mSegments.equals(other.mSegments) && this.mRepeatIndex == other.mRepeatIndex;
        }

        public int hashCode() {
            return Objects.hash(this.mSegments, this.mRepeatIndex);
        }

        public String toString() {
            return "Composed{segments=" + this.mSegments + ", repeat=" + this.mRepeatIndex + "}";
        }

        @Override
        public String toDebugString() {
            if (this.mSegments.size() == 1 && this.mRepeatIndex < 0) {
                return this.mSegments.get(0).toDebugString();
            }
            StringJoiner sj = new StringJoiner(",", "[", "]");
            for (int i = 0; i < this.mSegments.size(); ++i) {
                sj.add(this.mSegments.get(i).toDebugString());
            }
            if (this.mRepeatIndex >= 0) {
                return String.format(Locale.ROOT, "%s, repeat=%d", sj, this.mRepeatIndex);
            }
            return ((Object)sj).toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(1);
            out.writeList(this.mSegments);
            out.writeInt(this.mRepeatIndex);
        }

        @Nullable
        private static StepSegment castToValidStepSegmentForOffOnTimingsOrNull(VibrationEffectSegment segment) {
            if (!(segment instanceof StepSegment)) {
                return null;
            }
            StepSegment stepSegment = (StepSegment)segment;
            if (stepSegment.getFrequencyHz() != 0.0f) {
                return null;
            }
            float amplitude = stepSegment.getAmplitude();
            if (amplitude != 0.0f && amplitude != -1.0f) {
                return null;
            }
            return stepSegment;
        }

        private <T> Composed applyToSegments(BiFunction<VibrationEffectSegment, T, VibrationEffectSegment> function, T param) {
            int segmentCount = this.mSegments.size();
            ArrayList<VibrationEffectSegment> updatedSegments = new ArrayList<VibrationEffectSegment>(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                updatedSegments.add(function.apply(this.mSegments.get(i), (VibrationEffectSegment)param));
            }
            if (this.mSegments.equals(updatedSegments)) {
                return this;
            }
            Composed updated = new Composed(updatedSegments, this.mRepeatIndex);
            updated.validate();
            return updated;
        }
    }

    @FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
    public static class VendorEffect
    extends VibrationEffect {
        public static final int DEFAULT_STRENGTH = 1;
        public static final float DEFAULT_SCALE = 1.0f;
        private final PersistableBundle mVendorData;
        private final int mEffectStrength;
        private final float mScale;
        private final float mAdaptiveScale;
        @NonNull
        public static final Parcelable.Creator<VendorEffect> CREATOR = new Parcelable.Creator<VendorEffect>(){

            @Override
            public VendorEffect createFromParcel(Parcel in) {
                in.readInt();
                return new VendorEffect(in);
            }

            public VendorEffect[] newArray(int size) {
                return new VendorEffect[size];
            }
        };

        VendorEffect(@NonNull Parcel in) {
            this(Objects.requireNonNull(in.readPersistableBundle(VibrationEffect.class.getClassLoader())), in.readInt(), in.readFloat(), in.readFloat());
        }

        public VendorEffect(@NonNull PersistableBundle vendorData, int effectStrength, float scale, float adaptiveScale) {
            this.mVendorData = vendorData;
            this.mEffectStrength = effectStrength;
            this.mScale = scale;
            this.mAdaptiveScale = adaptiveScale;
        }

        @NonNull
        public PersistableBundle getVendorData() {
            return this.mVendorData;
        }

        public int getEffectStrength() {
            return this.mEffectStrength;
        }

        public float getScale() {
            return this.mScale;
        }

        public float getAdaptiveScale() {
            return this.mAdaptiveScale;
        }

        @Override
        @Nullable
        public long[] computeCreateWaveformOffOnTimingsOrNull() {
            return null;
        }

        @Override
        public void validate() {
            Preconditions.checkArgument(!this.mVendorData.isEmpty(), "Vendor effect bundle must be non-empty");
        }

        @Override
        @Nullable
        public VibrationEffect cropToLengthOrNull(int length) {
            return null;
        }

        @Override
        public long getDuration() {
            return -1L;
        }

        @Override
        public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
            return vibratorInfo.hasCapability(2048L);
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            return false;
        }

        @Override
        @NonNull
        public VendorEffect resolve(int defaultAmplitude) {
            return this;
        }

        @Override
        @NonNull
        public VibrationEffect applyEffectStrength(int effectStrength) {
            if (this.mEffectStrength == effectStrength) {
                return this;
            }
            VendorEffect updated = new VendorEffect(this.mVendorData, effectStrength, this.mScale, this.mAdaptiveScale);
            updated.validate();
            return updated;
        }

        @Override
        @NonNull
        public VendorEffect scale(float scaleFactor) {
            if (Float.compare(this.mScale, scaleFactor) == 0) {
                return this;
            }
            VendorEffect updated = new VendorEffect(this.mVendorData, this.mEffectStrength, scaleFactor, this.mAdaptiveScale);
            updated.validate();
            return updated;
        }

        @Override
        @NonNull
        public VibrationEffect applyAdaptiveScale(float scaleFactor) {
            if (Float.compare(this.mAdaptiveScale, scaleFactor) == 0) {
                return this;
            }
            VendorEffect updated = new VendorEffect(this.mVendorData, this.mEffectStrength, this.mScale, scaleFactor);
            updated.validate();
            return updated;
        }

        @Override
        @NonNull
        public VendorEffect applyRepeatingIndefinitely(boolean wantRepeating, int loopDelayMs) {
            return this;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VendorEffect)) {
                return false;
            }
            VendorEffect other = (VendorEffect)o;
            return this.mEffectStrength == other.mEffectStrength && Float.compare(this.mScale, other.mScale) == 0 && Float.compare(this.mAdaptiveScale, other.mAdaptiveScale) == 0 && VendorEffect.isPersistableBundleEquals(this.mVendorData, other.mVendorData);
        }

        public int hashCode() {
            return Objects.hash(this.mVendorData.size(), this.mEffectStrength, Float.valueOf(this.mScale), Float.valueOf(this.mAdaptiveScale));
        }

        public String toString() {
            return String.format(Locale.ROOT, "VendorEffect{vendorData=%s, strength=%s, scale=%.2f, adaptiveScale=%.2f}", this.mVendorData, VendorEffect.effectStrengthToString(this.mEffectStrength), Float.valueOf(this.mScale), Float.valueOf(this.mAdaptiveScale));
        }

        @Override
        public String toDebugString() {
            return String.format(Locale.ROOT, "vendorEffect=%s, strength=%s, scale=%.2f, adaptiveScale=%.2f", this.mVendorData.toShortString(), VendorEffect.effectStrengthToString(this.mEffectStrength), Float.valueOf(this.mScale), Float.valueOf(this.mAdaptiveScale));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(2);
            out.writePersistableBundle(this.mVendorData);
            out.writeInt(this.mEffectStrength);
            out.writeFloat(this.mScale);
            out.writeFloat(this.mAdaptiveScale);
        }

        private static boolean isPersistableBundleEquals(PersistableBundle first, PersistableBundle second) {
            if (first == second) {
                return true;
            }
            if (first == null || second == null || first.size() != second.size()) {
                return false;
            }
            for (String key : first.keySet()) {
                if (VendorEffect.isPersistableBundleSupportedValueEquals(first.get(key), second.get(key))) continue;
                return false;
            }
            return true;
        }

        private static boolean isPersistableBundleSupportedValueEquals(Object first, Object second) {
            if (first == second) {
                return true;
            }
            if (first == null || second == null || !first.getClass().equals(second.getClass())) {
                return false;
            }
            if (first instanceof PersistableBundle) {
                return VendorEffect.isPersistableBundleEquals((PersistableBundle)first, (PersistableBundle)second);
            }
            if (first instanceof int[]) {
                return Arrays.equals((int[])first, (int[])second);
            }
            if (first instanceof long[]) {
                return Arrays.equals((long[])first, (long[])second);
            }
            if (first instanceof double[]) {
                return Arrays.equals((double[])first, (double[])second);
            }
            if (first instanceof boolean[]) {
                return Arrays.equals((boolean[])first, (boolean[])second);
            }
            if (first instanceof String[]) {
                return Arrays.equals((String[])first, (String[])second);
            }
            return Objects.equals(first, second);
        }
    }

    public static class Composition {
        public static final int PRIMITIVE_NOOP = 0;
        public static final int PRIMITIVE_CLICK = 1;
        public static final int PRIMITIVE_THUD = 2;
        public static final int PRIMITIVE_SPIN = 3;
        public static final int PRIMITIVE_QUICK_RISE = 4;
        public static final int PRIMITIVE_SLOW_RISE = 5;
        public static final int PRIMITIVE_QUICK_FALL = 6;
        public static final int PRIMITIVE_TICK = 7;
        public static final int PRIMITIVE_LOW_TICK = 8;
        @FlaggedApi(value="android.os.vibrator.primitive_composition_absolute_delay")
        public static final int DELAY_TYPE_PAUSE = 0;
        @FlaggedApi(value="android.os.vibrator.primitive_composition_absolute_delay")
        public static final int DELAY_TYPE_RELATIVE_START_OFFSET = 1;
        private final ArrayList<VibrationEffectSegment> mSegments = new ArrayList();
        private int mRepeatIndex = -1;

        Composition() {
        }

        @NonNull
        public Composition addOffDuration(@NonNull Duration duration) {
            int durationMs = (int)duration.toMillis();
            Preconditions.checkArgumentNonnegative(durationMs, "Off period must be non-negative");
            if (durationMs > 0) {
                this.addSegment(new StepSegment(0.0f, 0.0f, (int)duration.toMillis()));
            }
            return this;
        }

        @NonNull
        public Composition addEffect(@NonNull VibrationEffect effect) {
            return this.addSegments(effect);
        }

        @NonNull
        public Composition repeatEffectIndefinitely(@NonNull VibrationEffect effect) {
            Preconditions.checkArgument(effect.getDuration() < Long.MAX_VALUE, "Can't repeat an indefinitely repeating effect. Consider addEffect instead.");
            int previousSegmentCount = this.mSegments.size();
            this.addSegments(effect);
            this.mRepeatIndex = previousSegmentCount;
            return this;
        }

        @NonNull
        public Composition addPrimitive(int primitiveId) {
            return this.addPrimitive(primitiveId, 1.0f);
        }

        @NonNull
        public Composition addPrimitive(int primitiveId, float scale) {
            return this.addPrimitive(primitiveId, scale, 0);
        }

        @NonNull
        public Composition addPrimitive(int primitiveId, float scale, int delay) {
            return this.addPrimitive(primitiveId, scale, delay, 0);
        }

        @FlaggedApi(value="android.os.vibrator.primitive_composition_absolute_delay")
        @NonNull
        public Composition addPrimitive(int primitiveId, float scale, int delay, int delayType) {
            PrimitiveSegment primitive = new PrimitiveSegment(primitiveId, scale, delay, delayType);
            primitive.validate();
            return this.addSegment(primitive);
        }

        private Composition addSegment(VibrationEffectSegment segment) {
            if (this.mRepeatIndex >= 0) {
                throw new UnreachableAfterRepeatingIndefinitelyException();
            }
            this.mSegments.add(segment);
            return this;
        }

        private Composition addSegments(VibrationEffect effect) {
            if (this.mRepeatIndex >= 0) {
                throw new UnreachableAfterRepeatingIndefinitelyException();
            }
            if (!(effect instanceof Composed)) {
                throw new IllegalArgumentException("Can't add vendor effects to composition.");
            }
            Composed composed = (Composed)effect;
            if (composed.getRepeatIndex() >= 0) {
                this.mRepeatIndex = this.mSegments.size() + composed.getRepeatIndex();
            }
            this.mSegments.addAll(composed.getSegments());
            return this;
        }

        @NonNull
        public VibrationEffect compose() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("Composition must have at least one element to compose.");
            }
            Composed effect = new Composed(this.mSegments, this.mRepeatIndex);
            ((VibrationEffect)effect).validate();
            return effect;
        }

        public static String primitiveToString(int id2) {
            String string2;
            switch (id2) {
                case 0: {
                    string2 = "NOOP";
                    break;
                }
                case 1: {
                    string2 = "CLICK";
                    break;
                }
                case 2: {
                    string2 = "THUD";
                    break;
                }
                case 3: {
                    string2 = "SPIN";
                    break;
                }
                case 4: {
                    string2 = "QUICK_RISE";
                    break;
                }
                case 5: {
                    string2 = "SLOW_RISE";
                    break;
                }
                case 6: {
                    string2 = "QUICK_FALL";
                    break;
                }
                case 7: {
                    string2 = "TICK";
                    break;
                }
                case 8: {
                    string2 = "LOW_TICK";
                    break;
                }
                default: {
                    string2 = Integer.toString(id2);
                }
            }
            return string2;
        }

        public static String delayTypeToString(int type) {
            String string2;
            switch (type) {
                case 0: {
                    string2 = "PAUSE";
                    break;
                }
                case 1: {
                    string2 = "START_OFFSET";
                    break;
                }
                default: {
                    string2 = Integer.toString(type);
                }
            }
            return string2;
        }

        public static class UnreachableAfterRepeatingIndefinitelyException
        extends IllegalStateException {
            UnreachableAfterRepeatingIndefinitelyException() {
                super("Compositions ending in an indefinitely repeating effect can't be extended");
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DelayType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PrimitiveType {
        }
    }

    public static class WaveformBuilder {
        private static final float EPSILON = 1.0E-5f;
        private ArrayList<VibrationEffectSegment> mSegments = new ArrayList();
        private float mLastAmplitude = 0.0f;
        private float mLastFrequencyHz = 0.0f;

        WaveformBuilder() {
        }

        @NonNull
        public WaveformBuilder addTransition(@NonNull Duration duration, @NonNull VibrationParameter targetParameter) {
            Preconditions.checkNotNull(duration, "Duration is null");
            this.checkVibrationParameter(targetParameter, "targetParameter");
            float amplitude = this.extractTargetAmplitude(targetParameter, null);
            float frequencyHz = this.extractTargetFrequency(targetParameter, null);
            this.addTransitionSegment(duration, amplitude, frequencyHz);
            return this;
        }

        @NonNull
        public WaveformBuilder addTransition(@NonNull Duration duration, @NonNull VibrationParameter targetParameter1, @NonNull VibrationParameter targetParameter2) {
            Preconditions.checkNotNull(duration, "Duration is null");
            this.checkVibrationParameter(targetParameter1, "targetParameter1");
            this.checkVibrationParameter(targetParameter2, "targetParameter2");
            Preconditions.checkArgument(!Objects.equals(targetParameter1.getClass(), targetParameter2.getClass()), "Parameter arguments must specify different parameter types");
            float amplitude = this.extractTargetAmplitude(targetParameter1, targetParameter2);
            float frequencyHz = this.extractTargetFrequency(targetParameter1, targetParameter2);
            this.addTransitionSegment(duration, amplitude, frequencyHz);
            return this;
        }

        @NonNull
        public WaveformBuilder addSustain(@NonNull Duration duration) {
            int durationMs = (int)duration.toMillis();
            Preconditions.checkArgument(durationMs >= 1, "Sustain duration must be >= 1ms");
            this.mSegments.add(new StepSegment(this.mLastAmplitude, this.mLastFrequencyHz, durationMs));
            return this;
        }

        @NonNull
        public VibrationEffect build() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("WaveformBuilder must have at least one transition to build.");
            }
            Composed effect = new Composed(this.mSegments, -1);
            ((VibrationEffect)effect).validate();
            return effect;
        }

        private void checkVibrationParameter(@NonNull VibrationParameter vibrationParameter, String paramName) {
            Preconditions.checkNotNull(vibrationParameter, "%s is null", paramName);
            Preconditions.checkArgument(vibrationParameter instanceof AmplitudeVibrationParameter || vibrationParameter instanceof FrequencyVibrationParameter, "%s is a unknown parameter", paramName);
        }

        private float extractTargetAmplitude(@Nullable VibrationParameter target1, @Nullable VibrationParameter target2) {
            if (target2 instanceof AmplitudeVibrationParameter) {
                return ((AmplitudeVibrationParameter)target2).amplitude;
            }
            if (target1 instanceof AmplitudeVibrationParameter) {
                return ((AmplitudeVibrationParameter)target1).amplitude;
            }
            return this.mLastAmplitude;
        }

        private float extractTargetFrequency(@Nullable VibrationParameter target1, @Nullable VibrationParameter target2) {
            if (target2 instanceof FrequencyVibrationParameter) {
                return ((FrequencyVibrationParameter)target2).frequencyHz;
            }
            if (target1 instanceof FrequencyVibrationParameter) {
                return ((FrequencyVibrationParameter)target1).frequencyHz;
            }
            return this.mLastFrequencyHz;
        }

        private void addTransitionSegment(Duration duration, float targetAmplitude, float targetFrequency) {
            Preconditions.checkNotNull(duration, "Duration is null");
            Preconditions.checkArgument(!duration.isNegative(), "Transition duration must be non-negative");
            int durationMs = (int)duration.toMillis();
            if (durationMs > 0) {
                if (Math.abs(this.mLastAmplitude - targetAmplitude) < 1.0E-5f && Math.abs(this.mLastFrequencyHz - targetFrequency) < 1.0E-5f) {
                    this.mSegments.add(new StepSegment(targetAmplitude, targetFrequency, durationMs));
                } else {
                    this.mSegments.add(new RampSegment(this.mLastAmplitude, targetAmplitude, this.mLastFrequencyHz, targetFrequency, durationMs));
                }
            }
            this.mLastAmplitude = targetAmplitude;
            this.mLastFrequencyHz = targetFrequency;
        }
    }

    public static class VibrationParameter {
        VibrationParameter() {
        }

        @NonNull
        public static VibrationParameter targetAmplitude(float amplitude) {
            return new AmplitudeVibrationParameter(amplitude);
        }

        @NonNull
        public static VibrationParameter targetFrequency(float frequencyHz) {
            return new FrequencyVibrationParameter(frequencyHz);
        }
    }

    private static class FrequencyVibrationParameter
    extends VibrationParameter {
        public final float frequencyHz;

        FrequencyVibrationParameter(float frequencyHz) {
            Preconditions.checkArgument(frequencyHz >= 1.0f, "Frequency must be >= 1");
            Preconditions.checkArgument(Float.isFinite(frequencyHz), "Frequency must be finite");
            this.frequencyHz = frequencyHz;
        }
    }

    private static class AmplitudeVibrationParameter
    extends VibrationParameter {
        public final float amplitude;

        AmplitudeVibrationParameter(float amplitude) {
            Preconditions.checkArgument(amplitude >= 0.0f && amplitude <= 1.0f, "Amplitude must be within [0,1]");
            this.amplitude = amplitude;
        }
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public static class BasicEnvelopeBuilder {
        private ArrayList<BasicPwleSegment> mSegments = new ArrayList();
        private float mLastIntensity = 0.0f;
        private float mLastSharpness = Float.NaN;

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public BasicEnvelopeBuilder setInitialSharpness(float initialSharpness) {
            if (this.mSegments.isEmpty()) {
                this.mLastSharpness = initialSharpness;
            } else {
                BasicPwleSegment firstSegment = this.mSegments.getFirst();
                this.mSegments.set(0, new BasicPwleSegment(firstSegment.getStartIntensity(), firstSegment.getEndIntensity(), initialSharpness, firstSegment.getEndSharpness(), firstSegment.getDuration()));
            }
            return this;
        }

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public BasicEnvelopeBuilder addControlPoint(float intensity, float sharpness, long durationMillis) {
            if (Float.isNaN(this.mLastSharpness)) {
                this.mLastSharpness = sharpness;
            }
            this.mSegments.add(new BasicPwleSegment(this.mLastIntensity, intensity, this.mLastSharpness, sharpness, durationMillis));
            this.mLastIntensity = intensity;
            this.mLastSharpness = sharpness;
            return this;
        }

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public VibrationEffect build() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("BasicEnvelopeBuilder must have at least one control point to build.");
            }
            if (this.mSegments.getLast().getEndIntensity() != 0.0f) {
                throw new IllegalStateException("Basic envelope effects must end at a zero intensity control point.");
            }
            Composed effect = new Composed(this.mSegments, -1);
            ((VibrationEffect)effect).validate();
            return effect;
        }
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public static class WaveformEnvelopeBuilder {
        private ArrayList<PwleSegment> mSegments = new ArrayList();
        private float mLastAmplitude = 0.0f;
        private float mLastFrequencyHz = Float.NaN;

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public WaveformEnvelopeBuilder setInitialFrequencyHz(float initialFrequencyHz) {
            if (this.mSegments.isEmpty()) {
                this.mLastFrequencyHz = initialFrequencyHz;
            } else {
                PwleSegment firstSegment = this.mSegments.getFirst();
                this.mSegments.set(0, new PwleSegment(firstSegment.getStartAmplitude(), firstSegment.getEndAmplitude(), initialFrequencyHz, firstSegment.getEndFrequencyHz(), firstSegment.getDuration()));
            }
            return this;
        }

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public WaveformEnvelopeBuilder addControlPoint(float amplitude, float frequencyHz, long durationMillis) {
            if (Float.isNaN(this.mLastFrequencyHz)) {
                this.mLastFrequencyHz = frequencyHz;
            }
            this.mSegments.add(new PwleSegment(this.mLastAmplitude, amplitude, this.mLastFrequencyHz, frequencyHz, durationMillis));
            this.mLastAmplitude = amplitude;
            this.mLastFrequencyHz = frequencyHz;
            return this;
        }

        @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
        @NonNull
        public VibrationEffect build() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("WaveformEnvelopeBuilder must have at least one control point to build.");
            }
            Composed effect = new Composed(this.mSegments, -1);
            ((VibrationEffect)effect).validate();
            return effect;
        }
    }

    public static interface Transformation<ParamT> {
        @NonNull
        public VibrationEffect transform(@NonNull VibrationEffect var1, @NonNull ParamT var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EffectType {
    }
}

