/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.pm.SignedPackage;
import android.content.pm.SignedPackageParcel;
import android.os.CarrierAssociatedAppEntry;
import android.os.ISystemConfig;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArraySet;
import android.util.Log;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@SystemApi
public class SystemConfigManager {
    private static final String TAG = SystemConfigManager.class.getSimpleName();
    private final ISystemConfig mInterface = ISystemConfig.Stub.asInterface(ServiceManager.getService("system_config"));

    @RequiresPermission(value="android.permission.READ_CARRIER_APP_INFO")
    @NonNull
    public Set<String> getDisabledUntilUsedPreinstalledCarrierApps() {
        try {
            List<String> apps = this.mInterface.getDisabledUntilUsedPreinstalledCarrierApps();
            return new ArraySet<String>(apps);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Caught remote exception");
            return Collections.emptySet();
        }
    }

    @RequiresPermission(value="android.permission.READ_CARRIER_APP_INFO")
    @NonNull
    public Map<String, List<String>> getDisabledUntilUsedPreinstalledCarrierAssociatedApps() {
        try {
            return this.mInterface.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Caught remote exception");
            return Collections.emptyMap();
        }
    }

    @RequiresPermission(value="android.permission.READ_CARRIER_APP_INFO")
    @NonNull
    public Map<String, List<CarrierAssociatedAppEntry>> getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries() {
        try {
            return this.mInterface.getDisabledUntilUsedPreinstalledCarrierAssociatedAppEntries();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Caught remote exception", e);
            return Collections.emptyMap();
        }
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    @NonNull
    public int[] getSystemPermissionUids(@NonNull String permissionName) {
        try {
            return this.mInterface.getSystemPermissionUids(permissionName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public List<ComponentName> getEnabledComponentOverrides(@NonNull String packageName) {
        try {
            return this.mInterface.getEnabledComponentOverrides(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.QUERY_ALL_PACKAGES")
    public List<ComponentName> getDefaultVrComponents() {
        try {
            return this.mInterface.getDefaultVrComponents();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return Collections.emptyList();
        }
    }

    @NonNull
    public List<String> getPreventUserDisablePackages() {
        try {
            return this.mInterface.getPreventUserDisablePackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.permission.flags.enhanced_confirmation_mode_apis_enabled")
    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    @NonNull
    public Set<SignedPackage> getEnhancedConfirmationTrustedPackages() {
        try {
            List<SignedPackageParcel> parcels = this.mInterface.getEnhancedConfirmationTrustedPackages();
            return parcels.stream().map(SignedPackage::new).collect(Collectors.toSet());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.permission.flags.enhanced_confirmation_mode_apis_enabled")
    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    @NonNull
    public Set<SignedPackage> getEnhancedConfirmationTrustedInstallers() {
        try {
            List<SignedPackageParcel> parcels = this.mInterface.getEnhancedConfirmationTrustedInstallers();
            return parcels.stream().map(SignedPackage::new).collect(Collectors.toSet());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

