/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.IProfilingService;
import android.os.ProfilingFrameworkInitializer;
import android.os.RemoteException;
import android.os.profiling.Flags;
import com.android.internal.annotations.GuardedBy;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
public class ProfilingServiceHelper {
    private static final String TAG = ProfilingServiceHelper.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final Object sLock = new Object();
    @Nullable
    @GuardedBy(value={"sLock"})
    private static ProfilingServiceHelper sInstance;
    private final Object mLock = new Object();
    @NonNull
    @GuardedBy(value={"mLock"})
    private final IProfilingService mProfilingService;

    private ProfilingServiceHelper(@NonNull IProfilingService service) {
        this.mProfilingService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ProfilingServiceHelper getInstance() {
        Object object = sLock;
        synchronized (object) {
            IProfilingService service;
            if (sInstance != null) {
                return sInstance;
            }
            IProfilingService iProfilingService = service = Flags.telemetryApis() ? IProfilingService.Stub.asInterface(ProfilingFrameworkInitializer.getProfilingServiceManager().getProfilingServiceRegisterer().get()) : null;
            if (service == null) {
                throw new IllegalStateException("ProfilingService not yet set up.");
            }
            sInstance = new ProfilingServiceHelper(service);
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProfilingTriggerOccurred(int uid, @NonNull String packageName, int triggerType) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mProfilingService.processTrigger(uid, packageName, triggerType, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

