/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;

public class ParcelDuration
implements Parcelable {
    private final long mSeconds;
    private final int mNanos;
    @NonNull
    public static final Parcelable.Creator<ParcelDuration> CREATOR = new Parcelable.Creator<ParcelDuration>(){

        @Override
        @NonNull
        public ParcelDuration createFromParcel(@NonNull Parcel source) {
            return new ParcelDuration(source);
        }

        @NonNull
        public ParcelDuration[] newArray(int size) {
            return new ParcelDuration[size];
        }
    };

    public ParcelDuration(long ms) {
        this(Duration.ofMillis(ms));
    }

    public ParcelDuration(@NonNull Duration duration) {
        this.mSeconds = duration.getSeconds();
        this.mNanos = duration.getNano();
    }

    private ParcelDuration(@NonNull Parcel parcel) {
        this.mSeconds = parcel.readLong();
        this.mNanos = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeLong(this.mSeconds);
        parcel.writeInt(this.mNanos);
    }

    @NonNull
    public Duration getDuration() {
        return Duration.ofSeconds(this.mSeconds, this.mNanos);
    }

    @NonNull
    public String toString() {
        return ((Object)this.getDuration()).toString();
    }
}

