/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import android.os.PerfettoTrace;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.ThreadLocalWorkSource;
import android.os.Trace;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.Log;
import android.util.Printer;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import java.util.Objects;

@RavenwoodKeepWholeClass
@RavenwoodRedirectionClass(value="Looper_ravenwood")
public class Looper {
    private static final String TAG = "Looper";
    @UnsupportedAppUsage
    static final ThreadLocal<Looper> sThreadLocal = new ThreadLocal();
    @UnsupportedAppUsage
    private static Looper sMainLooper;
    private static Observer sObserver;
    @UnsupportedAppUsage
    final MessageQueue mQueue;
    final Thread mThread;
    private boolean mInLoop;
    @UnsupportedAppUsage
    private Printer mLogging;
    private long mTraceTag;
    private long mSlowDispatchThresholdMs;
    private long mSlowDeliveryThresholdMs;
    private boolean mSlowDeliveryDetected;

    public static void prepare() {
        Looper.prepare(true);
    }

    private static void prepare(boolean quitAllowed) {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper(quitAllowed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void prepareMainLooper() {
        Looper.prepare(false);
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            if (sMainLooper != null) {
                throw new IllegalStateException("The main Looper has already been prepared.");
            }
            sMainLooper = Looper.myLooper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Looper getMainLooper() {
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainLooper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMainLooperForTest(@NonNull Looper looper) {
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            sMainLooper = Objects.requireNonNull(looper);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMainLooperForTest() {
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            sMainLooper = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setObserver(@Nullable Observer observer) {
        sObserver = observer;
    }

    private static boolean loopOnce(Looper me, long ident, int thresholdOverride) {
        long newIdent;
        long dispatchEnd;
        boolean hasOverride;
        Printer logging;
        Message msg = me.mQueue.next();
        if (msg == null) {
            return false;
        }
        if (PerfettoTrace.MQ_CATEGORY.isEnabled()) {
            PerfettoTrace.begin(PerfettoTrace.MQ_CATEGORY, "message_queue_receive").beginProto().beginNested(2004L).addField(1L, msg.sendingThreadName).endNested().endProto().setTerminatingFlow(msg.mEventId.get()).emit();
        }
        if ((logging = me.mLogging) != null) {
            logging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
        }
        Observer observer = sObserver;
        long traceTag = me.mTraceTag;
        long slowDispatchThresholdMs = me.mSlowDispatchThresholdMs;
        long slowDeliveryThresholdMs = me.mSlowDeliveryThresholdMs;
        boolean bl = hasOverride = thresholdOverride >= 0;
        if (hasOverride) {
            slowDispatchThresholdMs = thresholdOverride;
            slowDeliveryThresholdMs = thresholdOverride;
        }
        boolean logSlowDelivery = (slowDeliveryThresholdMs > 0L || hasOverride) && msg.when > 0L;
        boolean logSlowDispatch = slowDispatchThresholdMs > 0L || hasOverride;
        boolean needStartTime = logSlowDelivery || logSlowDispatch;
        boolean needEndTime = logSlowDispatch;
        if (traceTag != 0L && Trace.isTagEnabled(traceTag)) {
            Trace.traceBegin(traceTag, msg.target.getTraceName(msg));
        }
        long dispatchStart = needStartTime ? SystemClock.uptimeMillis() : 0L;
        Object token = null;
        if (observer != null) {
            token = observer.messageDispatchStarting();
        }
        long origWorkSource = ThreadLocalWorkSource.setUid(msg.workSourceUid);
        try {
            Looper.dispatchMessage(msg);
            if (observer != null) {
                observer.messageDispatched(token, msg);
            }
            dispatchEnd = needEndTime ? SystemClock.uptimeMillis() : 0L;
        }
        catch (Exception exception) {
            if (observer != null) {
                observer.dispatchingThrewException(token, msg, exception);
            }
            throw exception;
        }
        finally {
            ThreadLocalWorkSource.restore(origWorkSource);
            if (traceTag != 0L) {
                Trace.traceEnd(traceTag);
            }
        }
        if (logSlowDelivery) {
            boolean slow = false;
            if (!me.mSlowDeliveryDetected || NoImagePreloadHolder.sVerboseLogging) {
                slow = Looper.showSlowLog(slowDeliveryThresholdMs, msg.when, dispatchStart, "delivery", msg);
            }
            if (me.mSlowDeliveryDetected) {
                if (!slow && dispatchStart - msg.when <= 10L) {
                    Slog.w(TAG, "Drained");
                    me.mSlowDeliveryDetected = false;
                }
            } else if (slow) {
                me.mSlowDeliveryDetected = true;
            }
        }
        if (logSlowDispatch) {
            Looper.showSlowLog(slowDispatchThresholdMs, dispatchStart, dispatchEnd, "dispatch", msg);
        }
        if (logging != null) {
            logging.println("<<<<< Finished to " + msg.target + " " + msg.callback);
        }
        if (ident != (newIdent = Binder.clearCallingIdentity())) {
            Log.wtf(TAG, "Thread identity changed from 0x" + Long.toHexString(ident) + " to 0x" + Long.toHexString(newIdent) + " while dispatching to " + msg.target.getClass().getName() + " " + msg.callback + " what=" + msg.what);
        }
        if (PerfettoTrace.MQ_CATEGORY.isEnabled()) {
            PerfettoTrace.end(PerfettoTrace.MQ_CATEGORY).emit();
        }
        msg.recycleUnchecked();
        return true;
    }

    @RavenwoodRedirect
    private static void dispatchMessage(Message msg) {
        msg.target.dispatchMessage(msg);
    }

    public static void loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        if (me.mInLoop) {
            Slog.w(TAG, "Loop again would have the queued messages be executed before this one completed.");
        }
        me.mInLoop = true;
        Binder.clearCallingIdentity();
        long ident = Binder.clearCallingIdentity();
        int thresholdOverride = Looper.getThresholdOverride();
        me.mSlowDeliveryDetected = false;
        while (Looper.loopOnce(me, ident, thresholdOverride)) {
        }
    }

    @RavenwoodReplace
    private static int getThresholdOverride() {
        int globalOverride;
        if (Looper.myLooper() == Looper.getMainLooper() && (globalOverride = SystemProperties.getInt("log.looper.any.main.slow", -1)) >= 0) {
            return globalOverride;
        }
        int processOverride = SystemProperties.getInt("log.looper." + Process.myUid() + ".any.slow", -1);
        if (processOverride >= 0) {
            return processOverride;
        }
        return SystemProperties.getInt("log.looper." + Process.myUid() + "." + Thread.currentThread().getName() + ".slow", -1);
    }

    private static int getThresholdOverride$ravenwood() {
        return -1;
    }

    private static int getThreadGroup() {
        int threadGroup = -1;
        if (!Process.isIsolated()) {
            threadGroup = Process.getProcessGroup(Process.myTid());
        }
        return threadGroup;
    }

    private static String threadGroupToString(int threadGroup) {
        switch (threadGroup) {
            case 0: {
                return "BACKGROUND";
            }
            case 1: {
                return "FOREGROUND";
            }
            case 2: {
                return "SYSTEM";
            }
            case 3: {
                return "AUDIO_APP";
            }
            case 4: {
                return "AUDIO_SYS";
            }
            case 5: {
                return "TOP_APP";
            }
            case 6: {
                return "RT_APP";
            }
            case 7: {
                return "RESTRICTED";
            }
        }
        return "UNKNOWN";
    }

    private static boolean showSlowLog(long threshold, long measureStart, long measureEnd, String what, Message msg) {
        long actualTime = measureEnd - measureStart;
        if (actualTime < threshold) {
            return false;
        }
        String name = Process.myProcessName();
        String threadGroup = Looper.threadGroupToString(Looper.getThreadGroup());
        boolean isMain = Looper.myLooper() == Looper.getMainLooper();
        Slog.w(TAG, "Slow " + what + " took " + actualTime + "ms " + Thread.currentThread().getName() + " app=" + name + " main=" + isMain + " group=" + threadGroup + " h=" + msg.target.getClass().getName() + " c=" + msg.callback + " m=" + msg.what);
        return true;
    }

    @Nullable
    public static Looper myLooper() {
        return sThreadLocal.get();
    }

    @NonNull
    public static MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    private Looper(boolean quitAllowed) {
        this.mQueue = new MessageQueue(quitAllowed);
        this.mThread = Thread.currentThread();
    }

    public boolean isCurrentThread() {
        return Thread.currentThread() == this.mThread;
    }

    public void setMessageLogging(@Nullable Printer printer) {
        this.mLogging = printer;
    }

    @UnsupportedAppUsage
    public void setTraceTag(long traceTag) {
        this.mTraceTag = traceTag;
    }

    public void setSlowLogThresholdMs(long slowDispatchThresholdMs, long slowDeliveryThresholdMs) {
        this.mSlowDispatchThresholdMs = slowDispatchThresholdMs;
        this.mSlowDeliveryThresholdMs = slowDeliveryThresholdMs;
    }

    public void quit() {
        this.mQueue.quit(false);
    }

    public void quitSafely() {
        this.mQueue.quit(true);
    }

    @NonNull
    public Thread getThread() {
        return this.mThread;
    }

    @NonNull
    public MessageQueue getQueue() {
        return this.mQueue;
    }

    public void dump(@NonNull Printer pw, @NonNull String prefix) {
        pw.println(prefix + this.toString());
        this.mQueue.dump(pw, prefix + "  ", null);
    }

    public void dump(@NonNull Printer pw, @NonNull String prefix, Handler handler) {
        pw.println(prefix + this.toString());
        this.mQueue.dump(pw, prefix + "  ", handler);
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long looperToken = proto.start(fieldId);
        proto.write(0x10900000001L, this.mThread.getName());
        proto.write(1112396529666L, this.mThread.getId());
        if (this.mQueue != null) {
            this.mQueue.dumpDebug(proto, 1146756268035L);
        }
        proto.end(looperToken);
    }

    public String toString() {
        return "Looper (" + this.mThread.getName() + ", tid " + this.mThread.getId() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    public static interface Observer {
        public Object messageDispatchStarting();

        public void messageDispatched(Object var1, Message var2);

        public void dispatchingThrewException(Object var1, Message var2, Exception var3);
    }

    private static class NoImagePreloadHolder {
        private static final boolean sVerboseLogging = SystemProperties.getBoolean("log.looper.slow.verbose", false);

        private NoImagePreloadHolder() {
        }
    }
}

