/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.PropertyInvalidatedCache;
import android.os.RemoteException;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@RavenwoodKeepWholeClass
public class IpcDataCache<Query, Result>
extends PropertyInvalidatedCache<Query, Result> {
    public static final String MODULE_TEST = "test";
    public static final String MODULE_SYSTEM = "system_server";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String MODULE_BLUETOOTH = "bluetooth";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.ipc_data_cache_module_adservices")
    public static final String MODULE_ADSERVICES = "adservices";

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public IpcDataCache(int maxEntries, @NonNull String module, @NonNull String api, @NonNull String cacheName, @NonNull QueryHandler<Query, Result> computer) {
        super(new PropertyInvalidatedCache.Args(module).maxEntries(maxEntries).api(api), cacheName, computer);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void disableForCurrentProcess() {
        super.disableForCurrentProcess();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void disableForCurrentProcess(@NonNull String cacheName) {
        PropertyInvalidatedCache.disableForCurrentProcess(cacheName);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Nullable
    public Result query(@NonNull Query query) {
        return super.query(query);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void invalidateCache() {
        super.invalidateCache();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void invalidateCache(@NonNull String module, @NonNull String api) {
        PropertyInvalidatedCache.invalidateCache(module, api);
    }

    public IpcDataCache(@NonNull Config config, @NonNull QueryHandler<Query, Result> computer) {
        super(config.mArgs, config.mName, computer);
    }

    public IpcDataCache(@NonNull Config config, final @NonNull RemoteCall<Query, Result> remoteCall) {
        this(config, new QueryHandler<Query, Result>(){

            @Override
            public Result apply(Query query) {
                try {
                    return remoteCall.apply(query);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        });
    }

    public IpcDataCache(@NonNull Config config, final @NonNull RemoteCall<Query, Result> remoteCall, final @NonNull BypassCall<Query> bypass) {
        this(config, new QueryHandler<Query, Result>(){

            @Override
            public Result apply(Query query) {
                try {
                    return remoteCall.apply(query);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }

            @Override
            public boolean shouldBypassCache(Query query) {
                return bypass.apply(query);
            }
        });
    }

    @Override
    public void forgetDisableLocal() {
        super.forgetDisableLocal();
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled();
    }

    public boolean getDisabledState() {
        return this.isDisabled();
    }

    @Override
    public void disableInstance() {
        super.disableInstance();
    }

    @Override
    public void disableSystemWide() {
        super.disableSystemWide();
    }

    public static void setTestMode(boolean mode) {
        PropertyInvalidatedCache.setTestMode(mode);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.ipc_data_cache_testmode_apis")
    public static void setCacheTestMode(boolean mode) {
        IpcDataCache.setTestMode(mode);
    }

    public static class Config {
        final PropertyInvalidatedCache.Args mArgs;
        final String mName;
        private ArraySet<String> mChildren;
        private boolean mDisabled = false;

        private Config(@NonNull PropertyInvalidatedCache.Args args, @NonNull String name) {
            this.mArgs = args;
            this.mName = name;
        }

        public Config(int maxEntries, @NonNull String module, @NonNull String api, @NonNull String name) {
            this(new PropertyInvalidatedCache.Args(module).api(api).maxEntries(maxEntries), name);
        }

        public Config(int maxEntries, @NonNull String module, @NonNull String api) {
            this(maxEntries, module, api, api);
        }

        public Config(@NonNull Config root, @NonNull String api, @NonNull String name) {
            this(root.mArgs.api(api), name);
        }

        public Config(@NonNull Config root, @NonNull String api) {
            this(root.mArgs.api(api), api);
        }

        public Config child(@NonNull String name) {
            Config result = new Config(this.mArgs, name);
            this.registerChild(name);
            return result;
        }

        public Config cacheNulls(boolean enable) {
            return new Config(this.mArgs.cacheNulls(enable), this.mName);
        }

        public Config isolateUids(boolean enable) {
            return new Config(this.mArgs.isolateUids(enable), this.mName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChild(String name) {
            Config config = this;
            synchronized (config) {
                if (this.mChildren == null) {
                    this.mChildren = new ArraySet();
                }
                this.mChildren.add(name);
                if (this.mDisabled) {
                    IpcDataCache.disableForCurrentProcess(name);
                }
            }
        }

        public void invalidateCache() {
            IpcDataCache.invalidateCache(this.mArgs);
        }

        public void disableForCurrentProcess() {
            IpcDataCache.disableForCurrentProcess(this.mName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disableAllForCurrentProcess() {
            Config config = this;
            synchronized (config) {
                this.mDisabled = true;
                this.disableForCurrentProcess();
                if (this.mChildren != null) {
                    for (String c : this.mChildren) {
                        IpcDataCache.disableForCurrentProcess(c);
                    }
                }
            }
        }
    }

    public static interface RemoteCall<Query, Result> {
        public Result apply(Query var1) throws RemoteException;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static abstract class QueryHandler<Q, R>
    extends PropertyInvalidatedCache.QueryHandler<Q, R> {
        @Override
        @Nullable
        public abstract R apply(@NonNull Q var1);

        @Override
        public boolean shouldBypassCache(@NonNull Q query) {
            return false;
        }
    }

    public static interface BypassCall<Query> {
        public Boolean apply(Query var1);
    }

    private static class SystemServerCallHandler<Query, Result>
    extends QueryHandler<Query, Result> {
        private final RemoteCall<Query, Result> mHandler;

        public SystemServerCallHandler(RemoteCall handler) {
            this.mHandler = handler;
        }

        @Override
        public Result apply(Query query) {
            try {
                return this.mHandler.apply(query);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IpcDataCacheModule {
    }
}

