/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInputConstants
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IInputConstants";
    public static final int UNMULTIPLIED_DEFAULT_DISPATCHING_TIMEOUT_MILLIS = 5000;
    public static final int INVALID_BATTERY_CAPACITY = -1;
    public static final int INVALID_INPUT_EVENT_ID = 0;
    public static final int INVALID_INPUT_DEVICE_ID = -2;
    public static final int POLICY_FLAG_INJECTED_FROM_ACCESSIBILITY = 131072;
    public static final int POLICY_FLAG_KEY_GESTURE_TRIGGERED = 262144;
    public static final int POLICY_FLAG_INJECTED_FROM_ACCESSIBILITY_TOOL = 524288;
    public static final int INPUT_EVENT_FLAG_CANCELED = 32;
    public static final int INPUT_EVENT_FLAG_IS_ACCESSIBILITY_EVENT = 2048;
    public static final int INPUT_EVENT_FLAG_INJECTED_FROM_ACCESSIBILITY_TOOL = 4096;
    public static final int INPUT_EVENT_FLAG_TAINTED = Integer.MIN_VALUE;
    public static final int DEFAULT_POINTER_ACCELERATION = 3;
    public static final int DEFAULT_MOUSE_WHEEL_ACCELERATION = 4;
    public static final int VELOCITY_TRACKER_STRATEGY_DEFAULT = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_IMPULSE = 0;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ1 = 1;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ2 = 2;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ3 = 3;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_DELTA = 4;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_CENTRAL = 5;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_RECENT = 6;
    public static final int VELOCITY_TRACKER_STRATEGY_INT1 = 7;
    public static final int VELOCITY_TRACKER_STRATEGY_INT2 = 8;
    public static final int VELOCITY_TRACKER_STRATEGY_LEGACY = 9;
    public static final int DEVICE_CLASS_KEYBOARD = 1;
    public static final int DEVICE_CLASS_ALPHAKEY = 2;
    public static final int DEVICE_CLASS_TOUCH = 4;
    public static final int DEVICE_CLASS_CURSOR = 8;
    public static final int DEVICE_CLASS_TOUCH_MT = 16;
    public static final int DEVICE_CLASS_DPAD = 32;
    public static final int DEVICE_CLASS_GAMEPAD = 64;
    public static final int DEVICE_CLASS_SWITCH = 128;
    public static final int DEVICE_CLASS_JOYSTICK = 256;
    public static final int DEVICE_CLASS_VIBRATOR = 512;
    public static final int DEVICE_CLASS_MIC = 1024;
    public static final int DEVICE_CLASS_EXTERNAL_STYLUS = 2048;
    public static final int DEVICE_CLASS_ROTARY_ENCODER = 4096;
    public static final int DEVICE_CLASS_SENSOR = 8192;
    public static final int DEVICE_CLASS_BATTERY = 16384;
    public static final int DEVICE_CLASS_LIGHT = 32768;
    public static final int DEVICE_CLASS_TOUCHPAD = 65536;
    public static final int DEVICE_CLASS_VIRTUAL = 0x20000000;
    public static final int DEVICE_CLASS_EXTERNAL = 0x40000000;

    public static abstract class Stub
    extends Binder
    implements IInputConstants {
        public Stub() {
            this.attachInterface(this, IInputConstants.DESCRIPTOR);
        }

        public static IInputConstants asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputConstants.DESCRIPTOR);
            if (iin != null && iin instanceof IInputConstants) {
                return (IInputConstants)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                default: 
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputConstants.DESCRIPTOR;
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                default: 
            }
            return super.onTransact(code, data, reply, flags);
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IInputConstants {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputConstants.DESCRIPTOR;
            }
        }
    }

    public static class Default
    implements IInputConstants {
        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

