/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.HidlMemory;
import android.os.NativeHandle;
import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class HidlMemoryUtil {
    private static final String TAG = "HidlMemoryUtil";

    private HidlMemoryUtil() {
    }

    @NonNull
    public static HidlMemory byteArrayToHidlMemory(@NonNull byte[] input) {
        return HidlMemoryUtil.byteArrayToHidlMemory(input, null);
    }

    @NonNull
    public static HidlMemory byteArrayToHidlMemory(@NonNull byte[] input, @Nullable String name) {
        Preconditions.checkNotNull(input);
        if (input.length == 0) {
            return new HidlMemory("ashmem", 0L, null);
        }
        SharedMemory shmem = SharedMemory.create(name != null ? name : "", input.length);
        try {
            ByteBuffer buffer = shmem.mapReadWrite();
            buffer.put(input);
            SharedMemory.unmap(buffer);
            HidlMemory hidlMemory = HidlMemoryUtil.sharedMemoryToHidlMemory(shmem);
            if (shmem != null) {
                shmem.close();
            }
            return hidlMemory;
        }
        catch (Throwable throwable) {
            try {
                if (shmem != null) {
                    try {
                        shmem.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ErrnoException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NonNull
    public static HidlMemory byteListToHidlMemory(@NonNull List<Byte> input) {
        return HidlMemoryUtil.byteListToHidlMemory(input, null);
    }

    @NonNull
    public static HidlMemory byteListToHidlMemory(@NonNull List<Byte> input, @Nullable String name) {
        Preconditions.checkNotNull(input);
        if (input.isEmpty()) {
            return new HidlMemory("ashmem", 0L, null);
        }
        SharedMemory shmem = SharedMemory.create(name != null ? name : "", input.size());
        try {
            ByteBuffer buffer = shmem.mapReadWrite();
            for (Byte b : input) {
                buffer.put(b);
            }
            SharedMemory.unmap(buffer);
            HidlMemory hidlMemory = HidlMemoryUtil.sharedMemoryToHidlMemory(shmem);
            if (shmem != null) {
                shmem.close();
            }
            return hidlMemory;
        }
        catch (Throwable throwable) {
            try {
                if (shmem != null) {
                    try {
                        shmem.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ErrnoException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NonNull
    public static byte[] hidlMemoryToByteArray(@NonNull HidlMemory mem) {
        Preconditions.checkNotNull(mem);
        Preconditions.checkArgumentInRange(mem.getSize(), 0L, Integer.MAX_VALUE, "Memory size");
        Preconditions.checkArgument(mem.getSize() == 0L || mem.getName().equals("ashmem"), "Unsupported memory type: %s", mem.getName());
        if (mem.getSize() == 0L) {
            return new byte[0];
        }
        ByteBuffer buffer = HidlMemoryUtil.getBuffer(mem);
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @SuppressLint(value={"ConcreteCollection"})
    @NonNull
    public static ArrayList<Byte> hidlMemoryToByteList(@NonNull HidlMemory mem) {
        Preconditions.checkNotNull(mem);
        Preconditions.checkArgumentInRange(mem.getSize(), 0L, Integer.MAX_VALUE, "Memory size");
        Preconditions.checkArgument(mem.getSize() == 0L || mem.getName().equals("ashmem"), "Unsupported memory type: %s", mem.getName());
        if (mem.getSize() == 0L) {
            return new ArrayList<Byte>();
        }
        ByteBuffer buffer = HidlMemoryUtil.getBuffer(mem);
        ArrayList<Byte> result = new ArrayList<Byte>(buffer.remaining());
        while (buffer.hasRemaining()) {
            result.add(buffer.get());
        }
        return result;
    }

    @NonNull
    public static HidlMemory sharedMemoryToHidlMemory(@Nullable SharedMemory shmem) {
        if (shmem == null) {
            return new HidlMemory("ashmem", 0L, null);
        }
        return HidlMemoryUtil.fileDescriptorToHidlMemory(shmem.getFileDescriptor(), shmem.getSize());
    }

    @NonNull
    public static HidlMemory fileDescriptorToHidlMemory(@Nullable FileDescriptor fd, int size) {
        Preconditions.checkArgument(fd != null || size == 0);
        if (fd == null) {
            return new HidlMemory("ashmem", 0L, null);
        }
        try {
            NativeHandle handle = new NativeHandle(Os.dup(fd), true);
            return new HidlMemory("ashmem", size, handle);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    private static ByteBuffer getBuffer(@NonNull HidlMemory mem) {
        try {
            int size = (int)mem.getSize();
            if (size == 0) {
                return ByteBuffer.wrap(new byte[0]);
            }
            NativeHandle handle = mem.getHandle();
            long address = Os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, handle.getFileDescriptor(), 0L);
            return new DirectByteBuffer(size, address, handle.getFileDescriptor(), () -> {
                try {
                    Os.munmap(address, size);
                }
                catch (ErrnoException e) {
                    Log.wtf(TAG, e);
                }
            }, true);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }
}

