/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandlerThread_Delegate {
    private static final Map<BridgeContext, List<HandlerThread>> sThreads = new HashMap<BridgeContext, List<HandlerThread>>();

    public static void cleanUp(BridgeContext context) {
        List<HandlerThread> list = sThreads.get(context);
        if (list != null) {
            for (HandlerThread thread : list) {
                thread.quit();
            }
            list.clear();
            sThreads.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static void run(HandlerThread theThread) {
        BridgeContext context = RenderAction.getCurrentContext();
        List list = sThreads.computeIfAbsent(context, k -> new ArrayList());
        list.add(theThread);
        theThread.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread = theThread;
        synchronized (handlerThread) {
            theThread.mLooper = Looper.myLooper();
            theThread.notifyAll();
        }
        Process.setThreadPriority(theThread.mPriority);
        theThread.onLooperPrepared();
        Looper.loop();
        theThread.mTid = -1;
    }
}

