/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread_Delegate;
import android.os.Looper;
import android.os.Process;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.concurrent.Executor;

@RavenwoodKeepWholeClass
public class HandlerThread
extends Thread {
    int mPriority;
    int mTid = -1;
    Looper mLooper;
    @Nullable
    private volatile Handler mHandler;
    @Nullable
    private volatile Executor mExecutor;

    public HandlerThread(String name) {
        super(name);
        this.mPriority = 0;
        this.onCreated();
    }

    public HandlerThread(String name, int priority) {
        super(name);
        this.mPriority = priority;
        this.onCreated();
    }

    @RavenwoodReplace
    protected void onCreated() {
    }

    protected void onCreated$ravenwood() {
        this.setDaemon(true);
    }

    protected void onLooperPrepared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run_Original() {
        this.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority(this.mPriority);
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }

    @Override
    @LayoutlibDelegate
    public void run() {
        HandlerThread_Delegate.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        boolean wasInterrupted = false;
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return this.mLooper;
    }

    @NonNull
    public Handler getThreadHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.getLooper());
        }
        return this.mHandler;
    }

    @NonNull
    public Executor getThreadExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = new HandlerExecutor(this.getThreadHandler());
        }
        return this.mExecutor;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public boolean quitSafely() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quitSafely();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.mTid;
    }
}

