/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.Arrays;

public class DdmSyncState {
    private static int sCurrentStageIndex = 0;

    public static synchronized Stage getStage() {
        return Stage.values()[sCurrentStageIndex];
    }

    public static void reset() {
        sCurrentStageIndex = 0;
    }

    public static synchronized void next(Stage nextStage) {
        int rover;
        Stage[] stages = Stage.values();
        for (rover = sCurrentStageIndex; rover < stages.length && stages[rover] != nextStage; ++rover) {
        }
        if (rover == stages.length || stages[rover] != nextStage) {
            throw new IllegalStateException("Cannot go to " + (Object)((Object)nextStage) + " from:" + DdmSyncState.getInternalState());
        }
        sCurrentStageIndex = rover;
    }

    private static String getInternalState() {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("level = ").append(sCurrentStageIndex);
        sb.append("\n");
        sb.append("stages = ");
        sb.append(Arrays.toString(Arrays.stream(Stage.values()).map(Enum::name).toArray()));
        sb.append("\n");
        return sb.toString();
    }

    public static enum Stage {
        Boot("BOOT"),
        Attach("ATCH"),
        Bind("BIND"),
        Named("NAMD"),
        Debugger("DEBG"),
        Running("A_GO");

        final String mLabel;

        private Stage(String label) {
            if (label.length() != 4) {
                throw new IllegalStateException("Bad stage id '" + label + "'. Must be four letters");
            }
            this.mLabel = label;
        }

        public int toInt() {
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                result = result << 8 | this.mLabel.charAt(i) & 0xFF;
            }
            return result;
        }
    }
}

