/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.os.BatteryConsumer;
import android.os.BatteryUsageStats;
import android.os.PowerComponents;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class AggregateBatteryConsumer
extends BatteryConsumer {
    static final int CONSUMER_TYPE_AGGREGATE = 0;
    static final int COLUMN_INDEX_SCOPE = 1;
    static final int COLUMN_INDEX_CONSUMED_POWER = 2;
    static final int COLUMN_COUNT = 3;

    AggregateBatteryConsumer(BatteryConsumer.BatteryConsumerData data) {
        super(data);
    }

    private AggregateBatteryConsumer(@NonNull Builder builder) {
        super(builder.mData, builder.mPowerComponentsBuilder.build());
    }

    int getScope() {
        return this.mData.getInt(1);
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        this.mPowerComponents.dump(pw, 0, 0, skipEmptyComponents);
    }

    @Override
    public double getConsumedPower() {
        return this.mData.getDouble(2);
    }

    void writeToXml(TypedXmlSerializer serializer, int scope) throws IOException {
        serializer.startTag(null, "aggregate");
        serializer.attributeInt(null, "scope", scope);
        serializer.attributeDouble(null, "power", this.getConsumedPower());
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "aggregate");
    }

    static void parseXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder) throws XmlPullParserException, IOException {
        int scope = parser.getAttributeInt(null, "scope");
        Builder consumerBuilder = builder.getAggregateBatteryConsumerBuilder(scope);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("aggregate")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        consumerBuilder.addConsumedPower(parser.getAttributeDouble(null, "power"));
        while (!(eventType == 3 && parser.getName().equals("aggregate") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        public Builder(BatteryConsumer.BatteryConsumerData data, int scope, double minConsumedPowerThreshold) {
            super(data, 0, minConsumedPowerThreshold);
            data.putInt(1, scope);
        }

        public Builder setConsumedPower(double consumedPowerMah) {
            this.mData.putDouble(2, consumedPowerMah);
            return this;
        }

        public Builder addConsumedPower(double consumedPowerMah) {
            this.mData.putDouble(2, this.mData.getDouble(2) + consumedPowerMah);
            return this;
        }

        public void add(AggregateBatteryConsumer aggregateBatteryConsumer) {
            this.addConsumedPower(aggregateBatteryConsumer.getConsumedPower());
            this.mPowerComponentsBuilder.addPowerAndDuration(aggregateBatteryConsumer.mPowerComponents);
        }

        @NonNull
        public AggregateBatteryConsumer build() {
            return new AggregateBatteryConsumer(this);
        }
    }
}

