/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.IT4tNdefNfcee;
import android.nfc.ITagRemovedCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcAntennaInfo;
import android.nfc.NfcControllerAlwaysOnListener;
import android.nfc.NfcEvent;
import android.nfc.NfcFrameworkInitializer;
import android.nfc.NfcManager;
import android.nfc.NfcOemExtension;
import android.nfc.NfcServiceManager;
import android.nfc.NfcVendorNciCallbackListener;
import android.nfc.NfcWlcStateListener;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.nfc.WlcListenerDeviceInfo;
import android.nfc.cardemulation.PollingFrame;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.android.nfc.x.android.nfc.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class NfcAdapter {
    static final String TAG = "NFC";
    private final NfcControllerAlwaysOnListener mControllerAlwaysOnListener;
    private final NfcWlcStateListener mNfcWlcStateListener;
    private final NfcVendorNciCallbackListener mNfcVendorNciCallbackListener;
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    @RequiresPermission(value="android.permission.NFC_TRANSACTION_EVENT")
    public static final String ACTION_TRANSACTION_DETECTED = "android.nfc.action.TRANSACTION_DETECTED";
    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    public static final String ACTION_PREFERRED_PAYMENT_CHANGED = "android.nfc.action.PREFERRED_PAYMENT_CHANGED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String ACTION_ADAPTER_STATE_CHANGED = "android.nfc.action.ADAPTER_STATE_CHANGED";
    public static final String EXTRA_ADAPTER_STATE = "android.nfc.extra.ADAPTER_STATE";
    public static final String EXTRA_AID = "android.nfc.extra.AID";
    public static final String EXTRA_DATA = "android.nfc.extra.DATA";
    public static final String EXTRA_SECURE_ELEMENT_NAME = "android.nfc.extra.SECURE_ELEMENT_NAME";
    public static final String EXTRA_PREFERRED_PAYMENT_CHANGED_REASON = "android.nfc.extra.PREFERRED_PAYMENT_CHANGED_REASON";
    @FlaggedApi(value="com.android.nfc.module.flags.reader_mode_annotations")
    public static final String EXTRA_READER_TECH_A_POLLING_LOOP_ANNOTATION = "android.nfc.extra.READER_TECH_A_POLLING_LOOP_ANNOTATION";
    public static final int PREFERRED_PAYMENT_LOADED = 1;
    public static final int PREFERRED_PAYMENT_CHANGED = 2;
    public static final int PREFERRED_PAYMENT_UPDATED = 3;
    public static final int STATE_OFF = 1;
    public static final int STATE_TURNING_ON = 2;
    public static final int STATE_ON = 3;
    public static final int STATE_TURNING_OFF = 4;
    public static final int FLAG_READER_NFC_A = 1;
    public static final int FLAG_READER_NFC_B = 2;
    public static final int FLAG_READER_NFC_F = 4;
    public static final int FLAG_READER_NFC_V = 8;
    public static final int FLAG_READER_NFC_BARCODE = 16;
    public static final int FLAG_READER_SKIP_NDEF_CHECK = 128;
    public static final int FLAG_READER_NO_PLATFORM_SOUNDS = 256;
    public static final String EXTRA_READER_PRESENCE_CHECK_DELAY = "presence";
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_LISTEN_NFC_PASSIVE_A = 1;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_LISTEN_NFC_PASSIVE_B = 2;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_LISTEN_NFC_PASSIVE_F = 4;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_LISTEN_DISABLE = 0;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_READER_DISABLE = 0;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_LISTEN_KEEP = Integer.MIN_VALUE;
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public static final int FLAG_READER_KEEP = Integer.MIN_VALUE;
    public static final int FLAG_USE_ALL_TECH = 255;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_set_default_disc_tech")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static final int FLAG_SET_DEFAULT_TECH = 0x40000000;
    @SystemApi
    @UnsupportedAppUsage
    public static final int FLAG_NDEF_PUSH_NO_CONFIRM = 1;
    public static final String ACTION_HANDOVER_TRANSFER_STARTED = "android.nfc.action.HANDOVER_TRANSFER_STARTED";
    public static final String ACTION_HANDOVER_TRANSFER_DONE = "android.nfc.action.HANDOVER_TRANSFER_DONE";
    public static final String EXTRA_HANDOVER_TRANSFER_STATUS = "android.nfc.extra.HANDOVER_TRANSFER_STATUS";
    public static final int HANDOVER_TRANSFER_STATUS_SUCCESS = 0;
    public static final int HANDOVER_TRANSFER_STATUS_FAILURE = 1;
    public static final String EXTRA_HANDOVER_TRANSFER_URI = "android.nfc.extra.HANDOVER_TRANSFER_URI";
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public static final String ACTION_REQUIRE_UNLOCK_FOR_NFC = "android.nfc.action.REQUIRE_UNLOCK_FOR_NFC";
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @RequiresPermission(value="android.permission.SHOW_CUSTOMIZED_RESOLVER")
    public static final String ACTION_SHOW_NFC_RESOLVER = "android.nfc.action.SHOW_NFC_RESOLVER";
    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public static final String EXTRA_RESOLVE_INFOS = "android.nfc.extra.RESOLVE_INFOS";
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_SUCCESS = 0;
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_PACKAGE_NOT_FOUND = -1;
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_UNAVAILABLE = -2;
    public static final int CONTROLLER_ALWAYS_ON_MODE_DEFAULT = 1;
    public static final int CONTROLLER_ALWAYS_ON_DISABLE = 0;
    static boolean sIsInitialized = false;
    static boolean sHasNfcFeature;
    static boolean sHasCeFeature;
    static boolean sHasNfcWlcFeature;
    static Object sLock;
    @UnsupportedAppUsage
    static INfcAdapter sService;
    static NfcServiceManager.ServiceRegisterer sServiceRegisterer;
    static INfcTag sTagService;
    static INfcCardEmulation sCardEmulationService;
    static INfcFCardEmulation sNfcFCardEmulationService;
    static IT4tNdefNfcee sNdefNfceeService;
    static HashMap<Context, NfcAdapter> sNfcAdapters;
    static NfcAdapter sNullContextNfcAdapter;
    final NfcActivityManager mNfcActivityManager;
    final Context mContext;
    final HashMap<NfcUnlockHandler, INfcUnlockHandler> mNfcUnlockHandlers;
    final Object mLock;
    final NfcOemExtension mNfcOemExtension;
    private static final int DISABLE_POLLING_FLAGS = 4096;
    private static final int ENABLE_POLLING_FLAGS = 0;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static final int SEND_VENDOR_NCI_STATUS_SUCCESS = 0;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static final int SEND_VENDOR_NCI_STATUS_REJECTED = 1;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static final int SEND_VENDOR_NCI_STATUS_MESSAGE_CORRUPTED = 2;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static final int SEND_VENDOR_NCI_STATUS_FAILED = 3;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static final int MESSAGE_TYPE_COMMAND = 1;
    @FlaggedApi(value="android.nfc.nfc_check_tag_intent_preference")
    public static final String ACTION_CHANGE_TAG_INTENT_PREFERENCE = "android.nfc.action.CHANGE_TAG_INTENT_PREFERENCE";

    @UnsupportedAppUsage
    public static IT4tNdefNfcee getNdefNfceeService() {
        return sNdefNfceeService;
    }

    @NonNull
    public List<String> getSupportedOffHostSecureElements() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  getSupportedOffHostSecureElements APIs");
        }
        ArrayList<String> offHostSE = new ArrayList<String>();
        PackageManager pm = this.mContext.getPackageManager();
        if (pm == null) {
            Log.e(TAG, "Cannot get package manager, assuming no off-host CE feature");
            return offHostSE;
        }
        if (pm.hasSystemFeature("android.hardware.nfc.uicc")) {
            offHostSE.add("SIM");
        }
        if (pm.hasSystemFeature("android.hardware.nfc.ese")) {
            offHostSE.add("eSE");
        }
        return offHostSE;
    }

    private static void retrieveServiceRegisterer() {
        if (sServiceRegisterer == null) {
            NfcServiceManager manager = NfcFrameworkInitializer.getNfcServiceManager();
            if (manager == null) {
                Log.e(TAG, "NfcServiceManager is null");
                throw new UnsupportedOperationException();
            }
            sServiceRegisterer = manager.getNfcManagerServiceRegisterer();
        }
    }

    @UnsupportedAppUsage
    public static synchronized NfcAdapter getNfcAdapter(Context context) {
        NfcAdapter adapter;
        if (context == null) {
            if (sNullContextNfcAdapter == null) {
                sNullContextNfcAdapter = new NfcAdapter(null);
            }
            return sNullContextNfcAdapter;
        }
        if (!sIsInitialized) {
            PackageManager pm = context.getPackageManager();
            sHasNfcFeature = pm.hasSystemFeature("android.hardware.nfc");
            sHasCeFeature = pm.hasSystemFeature("android.hardware.nfc.hce") || pm.hasSystemFeature("android.hardware.nfc.hcef") || pm.hasSystemFeature("android.hardware.nfc.uicc") || pm.hasSystemFeature("android.hardware.nfc.ese");
            sHasNfcWlcFeature = pm.hasSystemFeature("android.hardware.nfc.charging");
            if (!(sHasNfcFeature || sHasCeFeature || sHasNfcWlcFeature)) {
                Log.v(TAG, "this device does not have NFC support");
                throw new UnsupportedOperationException();
            }
            NfcAdapter.retrieveServiceRegisterer();
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                Log.e(TAG, "could not retrieve NFC service");
                throw new UnsupportedOperationException();
            }
            if (sHasNfcFeature) {
                try {
                    sTagService = sService.getNfcTagInterface();
                }
                catch (RemoteException e) {
                    sTagService = null;
                    Log.e(TAG, "could not retrieve NFC Tag service");
                    throw new UnsupportedOperationException();
                }
            }
            if (sHasCeFeature) {
                try {
                    sNfcFCardEmulationService = sService.getNfcFCardEmulationInterface();
                }
                catch (RemoteException e) {
                    sNfcFCardEmulationService = null;
                    Log.e(TAG, "could not retrieve NFC-F card emulation service");
                    throw new UnsupportedOperationException();
                }
                try {
                    sCardEmulationService = sService.getNfcCardEmulationInterface();
                }
                catch (RemoteException e) {
                    sCardEmulationService = null;
                    Log.e(TAG, "could not retrieve card emulation service");
                    throw new UnsupportedOperationException();
                }
            }
            try {
                sNdefNfceeService = sService.getT4tNdefNfceeInterface();
            }
            catch (RemoteException e) {
                sNdefNfceeService = null;
                Log.e(TAG, "could not retrieve NDEF NFCEE service");
                throw new UnsupportedOperationException();
            }
            sIsInitialized = true;
        }
        if ((adapter = sNfcAdapters.get(context)) == null) {
            adapter = new NfcAdapter(context);
            sNfcAdapters.put(context, adapter);
        }
        return adapter;
    }

    private static INfcAdapter getServiceInterface() {
        IBinder b = sServiceRegisterer.get();
        if (b == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NfcAdapter getDefaultAdapter(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if ((context = context.getApplicationContext()) == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        NfcAdapter.retrieveServiceRegisterer();
        if (sServiceRegisterer.tryGet() == null) {
            if (!sIsInitialized) return null;
            Class<NfcAdapter> clazz = NfcAdapter.class;
            synchronized (NfcAdapter.class) {
                if (!sIsInitialized) return null;
                sIsInitialized = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }
        NfcManager manager = (NfcManager)context.getSystemService("nfc");
        if (manager != null) return manager.getDefaultAdapter();
        return null;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static NfcAdapter getDefaultAdapter() {
        Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return NfcAdapter.getNfcAdapter(null);
    }

    NfcAdapter(Context context) {
        this.mContext = context;
        this.mNfcActivityManager = new NfcActivityManager(this);
        this.mNfcUnlockHandlers = new HashMap();
        this.mLock = new Object();
        this.mControllerAlwaysOnListener = new NfcControllerAlwaysOnListener();
        this.mNfcWlcStateListener = new NfcWlcStateListener(NfcAdapter.getService());
        this.mNfcVendorNciCallbackListener = new NfcVendorNciCallbackListener();
        this.mNfcOemExtension = new NfcOemExtension(this.mContext, this);
    }

    @UnsupportedAppUsage
    public Context getContext() {
        return this.mContext;
    }

    @UnsupportedAppUsage
    public static INfcAdapter getService() {
        NfcAdapter.isEnabledStatic();
        return sService;
    }

    public static INfcTag getTagService() {
        NfcAdapter.isEnabledStatic();
        return sTagService;
    }

    public static INfcCardEmulation getCardEmulationService() {
        NfcAdapter.isEnabledStatic();
        return sCardEmulationService;
    }

    public static INfcFCardEmulation getNfcFCardEmulationService() {
        NfcAdapter.isEnabledStatic();
        return sNfcFCardEmulationService;
    }

    public INfcDta getNfcDtaInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        return NfcAdapter.callServiceReturn(() -> sService.getNfcDtaInterface(this.mContext.getPackageName()), null);
    }

    @UnsupportedAppUsage
    public static void attemptDeadServiceRecovery(RemoteException e) {
        Log.e(TAG, "NFC service dead - attempting to recover", e);
        INfcAdapter service = NfcAdapter.getServiceInterface();
        if (service == null) {
            Log.e(TAG, "could not retrieve NFC service during service recovery");
            e.rethrowAsRuntimeException();
        }
        sService = service;
        if (sHasNfcFeature) {
            try {
                sTagService = service.getNfcTagInterface();
            }
            catch (RemoteException ee) {
                sTagService = null;
                Log.e(TAG, "could not retrieve NFC tag service during service recovery");
                ee.rethrowAsRuntimeException();
            }
        }
        if (sHasCeFeature) {
            try {
                sCardEmulationService = service.getNfcCardEmulationInterface();
            }
            catch (RemoteException ee) {
                sCardEmulationService = null;
                Log.e(TAG, "could not retrieve NFC card emulation service during service recovery");
            }
            try {
                sNfcFCardEmulationService = service.getNfcFCardEmulationInterface();
            }
            catch (RemoteException ee) {
                sNfcFCardEmulationService = null;
                Log.e(TAG, "could not retrieve NFC-F card emulation service during service recovery");
            }
        }
        try {
            sNdefNfceeService = service.getT4tNdefNfceeInterface();
        }
        catch (RemoteException ee) {
            sNdefNfceeService = null;
            Log.e(TAG, "could not retrieve NDEF NFCEE service");
            throw new UnsupportedOperationException();
        }
    }

    private static boolean isCardEmulationEnabled() {
        if (sHasCeFeature) {
            return sCardEmulationService != null || sNfcFCardEmulationService != null;
        }
        return false;
    }

    private static boolean isTagReadingEnabled() {
        if (sHasNfcFeature) {
            return sTagService != null;
        }
        return false;
    }

    private static boolean isEnabledStatic() {
        boolean serviceState = NfcAdapter.callServiceReturn(() -> sService.getState() == 3, false);
        return serviceState && (NfcAdapter.isTagReadingEnabled() || NfcAdapter.isCardEmulationEnabled() || sHasNfcWlcFeature);
    }

    public boolean isEnabled() {
        return NfcAdapter.isEnabledStatic();
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int getAdapterState() {
        return NfcAdapter.callServiceReturn(() -> sService.getState(), 1);
    }

    @FlaggedApi(value="android.nfc.nfc_state_change")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enable() {
        return NfcAdapter.callServiceReturn(() -> sService.enable(this.mContext.getPackageName()), false);
    }

    @FlaggedApi(value="android.nfc.nfc_state_change")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean disable() {
        return NfcAdapter.callServiceReturn(() -> sService.disable(true, this.mContext.getPackageName()), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean disable(boolean persist) {
        return NfcAdapter.callServiceReturn(() -> sService.disable(persist, this.mContext.getPackageName()), false);
    }

    public void pausePolling(int timeoutInMs) {
        NfcAdapter.callService(() -> sService.pausePolling(timeoutInMs));
    }

    @FlaggedApi(value="com.android.nfc.module.flags.reader_mode_annotations")
    public boolean isReaderModeAnnotationSupported() {
        return NfcAdapter.callServiceReturn(() -> sService.isReaderModeAnnotationSupported(), false);
    }

    public boolean isObserveModeSupported() {
        return NfcAdapter.callServiceReturn(() -> sService.isObserveModeSupported(), false);
    }

    public boolean isObserveModeEnabled() {
        return NfcAdapter.callServiceReturn(() -> sService.isObserveModeEnabled(), false);
    }

    public boolean setObserveModeEnabled(boolean enabled) {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  observe mode APIs");
        }
        return NfcAdapter.callServiceReturn(() -> sService.setObserveMode(enabled, this.mContext.getPackageName()), false);
    }

    @FlaggedApi(value="com.android.nfc.module.flags.nfc_power_saving_mode")
    public boolean isPowerSavingModeSupported() {
        return NfcAdapter.callServiceReturn(sService::isPowerSavingModeSupported, false);
    }

    @FlaggedApi(value="com.android.nfc.module.flags.nfc_power_saving_mode")
    public boolean isPowerSavingModeEnabled() {
        return NfcAdapter.callServiceReturn(sService::isPowerSavingModeEnabled, false);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="com.android.nfc.module.flags.nfc_power_saving_mode")
    public void setPowerSavingMode(boolean enabled) {
        NfcAdapter.callService(() -> sService.setPowerSavingMode(enabled));
    }

    public void resumePolling() {
        NfcAdapter.callService(() -> sService.resumePolling());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setBeamPushUris(Uri[] uris, Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setBeamPushUrisCallback(CreateBeamUrisCallback callback, Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @UnsupportedAppUsage
    public void setNdefPushMessage(NdefMessage message, Activity activity, int flags) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setNdefPushMessageCallback(CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        if (activity == null || intent == null) {
            throw new NullPointerException();
        }
        TechListParcel parcel = techLists != null && techLists.length > 0 ? new TechListParcel(techLists) : null;
        NfcAdapter.callService(() -> sService.setForegroundDispatch(intent, filters, parcel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableForegroundDispatch(Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        NfcAdapter.callService(() -> sService.setForegroundDispatch(null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableReaderMode(Activity activity, ReaderCallback callback, int flags, Bundle extras) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        this.mNfcActivityManager.enableReaderMode(activity, callback, flags, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableReaderMode(Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        this.mNfcActivityManager.disableReaderMode(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @SuppressLint(value={"VisiblySynchronized"})
    public void setReaderModePollingEnabled(boolean enable) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        Binder token = new Binder();
        int flags = enable ? 0 : 4096;
        NfcAdapter.callService(() -> sService.setReaderMode(token, null, flags, null, this.mContext.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public void setDiscoveryTechnology(@NonNull Activity activity, int pollTechnology, int listenTechnology) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature && !sHasCeFeature) {
                throw new UnsupportedOperationException();
            }
        }
        if (Flags.nfcSetDefaultDiscTech() && ((pollTechnology & 0x40000000) == 0x40000000 || (listenTechnology & 0x40000000) == 0x40000000)) {
            Binder token = new Binder();
            NfcAdapter.callService(() -> sService.updateDiscoveryTechnology(token, pollTechnology, listenTechnology, this.mContext.getPackageName()));
        } else {
            this.mNfcActivityManager.setDiscoveryTech(activity, pollTechnology, listenTechnology);
        }
    }

    @FlaggedApi(value="android.nfc.enable_nfc_set_discovery_tech")
    public void resetDiscoveryTechnology(@NonNull Activity activity) {
        this.mNfcActivityManager.resetDiscoveryTech(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public boolean invokeBeam(Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void enableForegroundNdefPush(Activity activity, NdefMessage message) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void disableForegroundNdefPush(Activity activity) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enableSecureNfc(boolean enable) {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.setNfcSecure(enable), false);
    }

    public boolean isSecureNfcSupported() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.deviceSupportsNfcSecure(), false);
    }

    @Nullable
    public NfcAntennaInfo getNfcAntennaInfo() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.getNfcAntennaInfo(), null);
    }

    public boolean isSecureNfcEnabled() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isNfcSecureEnabled(), false);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_reader_option")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enableReaderOption(boolean enable) {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.enableReaderOption(enable, this.mContext.getPackageName()), false);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_reader_option")
    public boolean isReaderOptionSupported() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isReaderOptionSupported(), false);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_reader_option")
    public boolean isReaderOptionEnabled() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isReaderOptionEnabled(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @UnsupportedAppUsage
    public boolean enableNdefPush() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @UnsupportedAppUsage
    public boolean disableNdefPush() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public boolean isNdefPushEnabled() {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        return false;
    }

    public boolean ignore(Tag tag, int debounceMs, final OnTagRemovedListener tagRemovedListener, final Handler handler) {
        ITagRemovedCallback.Stub iListener = null;
        if (tagRemovedListener != null) {
            iListener = new ITagRemovedCallback.Stub(this){

                @Override
                public void onTagRemoved() throws RemoteException {
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                tagRemovedListener.onTagRemoved();
                            }
                        });
                    } else {
                        tagRemovedListener.onTagRemoved();
                    }
                }
            };
        }
        ITagRemovedCallback.Stub passedListener = iListener;
        return NfcAdapter.callServiceReturn(() -> sService.ignore(tag.getServiceHandle(), debounceMs, passedListener), false);
    }

    public void dispatch(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag cannot be null");
        }
        NfcAdapter.callService(() -> sService.dispatch(tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean addNfcUnlockHandler(final NfcUnlockHandler unlockHandler, String[] tagTechnologies) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        if (tagTechnologies.length == 0) {
            return false;
        }
        try {
            object = this.mLock;
            synchronized (object) {
                if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                    NfcAdapter.callService(() -> {
                        sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.get(unlockHandler));
                        this.mNfcUnlockHandlers.remove(unlockHandler);
                    });
                }
                INfcUnlockHandler.Stub iHandler = new INfcUnlockHandler.Stub(this){

                    @Override
                    public boolean onUnlockAttempted(Tag tag) throws RemoteException {
                        return unlockHandler.onUnlockAttempted(tag);
                    }
                };
                return NfcAdapter.callServiceReturn(() -> {
                    sService.addNfcUnlockHandler(iHandler, Tag.getTechCodesFromStrings(tagTechnologies));
                    this.mNfcUnlockHandlers.put(unlockHandler, iHandler);
                    return true;
                }, false);
            }
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Unable to register LockscreenDispatch", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean removeNfcUnlockHandler(NfcUnlockHandler unlockHandler) {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                return NfcAdapter.callServiceReturn(() -> {
                    sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.remove(unlockHandler));
                    return true;
                }, false);
            }
            return true;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        return NfcAdapter.callServiceReturn(() -> sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName()), null);
    }

    public void enforceResumed(Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalStateException("API cannot be called while activity is paused");
        }
    }

    public int getSdkVersion() {
        if (this.mContext == null) {
            return 9;
        }
        return this.mContext.getApplicationInfo().targetSdkVersion;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean setControllerAlwaysOn(boolean value) {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        int mode = value ? 1 : 0;
        try {
            NfcAdapter.callService(() -> sService.setControllerAlwaysOn(mode));
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean isControllerAlwaysOn() {
        return NfcAdapter.callServiceReturn(() -> sService.isControllerAlwaysOn(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean isControllerAlwaysOnSupported() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isControllerAlwaysOnSupported(), false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public void registerControllerAlwaysOnListener(@NonNull Executor executor, @NonNull ControllerAlwaysOnListener listener) {
        this.mControllerAlwaysOnListener.register(executor, listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public void unregisterControllerAlwaysOnListener(@NonNull ControllerAlwaysOnListener listener) {
        this.mControllerAlwaysOnListener.unregister(listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int setTagIntentAppPreferenceForUser(int userId, @NonNull String pkg, boolean allow) {
        Objects.requireNonNull(pkg, "pkg cannot be null");
        if (!this.isTagIntentAppPreferenceSupported()) {
            Log.e(TAG, "TagIntentAppPreference is not supported");
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.setTagIntentAppPreferenceForUser(userId, pkg, allow), -2);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @NonNull
    public Map<String, Boolean> getTagIntentAppPreferenceForUser(int userId) {
        if (!this.isTagIntentAppPreferenceSupported()) {
            Log.e(TAG, "TagIntentAppPreference is not supported");
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.getTagIntentAppPreferenceForUser(userId), Collections.emptyMap());
    }

    @FlaggedApi(value="android.nfc.nfc_check_tag_intent_preference")
    public boolean isTagIntentAppPreferenceSupported() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isTagIntentAppPreferenceSupported(), false);
    }

    public void notifyPollingLoop(@NonNull PollingFrame pollingFrame) {
        NfcAdapter.callService(() -> sService.notifyPollingLoop(pollingFrame));
    }

    public void notifyTestHceData(int technology, byte[] data) {
        NfcAdapter.callService(() -> sService.notifyTestHceData(technology, data));
    }

    public static void callService(ServiceCall call) {
        try {
            if (sService == null) {
                NfcAdapter.attemptDeadServiceRecovery(new RemoteException("NFC Service is null"));
            }
            call.call();
        }
        catch (RemoteException e) {
            NfcAdapter.attemptDeadServiceRecovery(e);
            try {
                call.call();
            }
            catch (RemoteException ee) {
                ee.rethrowAsRuntimeException();
            }
        }
    }

    public static <T> T callServiceReturn(ServiceCallReturn<T> call, T defaultReturn) {
        try {
            if (sService == null) {
                NfcAdapter.attemptDeadServiceRecovery(new RemoteException("NFC Service is null"));
            }
            return call.call();
        }
        catch (RemoteException e) {
            NfcAdapter.attemptDeadServiceRecovery(e);
            try {
                return call.call();
            }
            catch (RemoteException ee) {
                ee.rethrowAsRuntimeException();
                return defaultReturn;
            }
        }
    }

    public void notifyHceDeactivated() {
        NfcAdapter.callService(() -> sService.notifyHceDeactivated());
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean setWlcEnabled(boolean enable) {
        if (!sHasNfcWlcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.setWlcEnabled(enable), false);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    public boolean isWlcEnabled() {
        if (!sHasNfcWlcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.isWlcEnabled(), false);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    public void registerWlcStateListener(@NonNull Executor executor, @NonNull WlcStateListener listener) {
        if (!sHasNfcWlcFeature) {
            throw new UnsupportedOperationException();
        }
        this.mNfcWlcStateListener.register(executor, listener);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    public void unregisterWlcStateListener(@NonNull WlcStateListener listener) {
        if (!sHasNfcWlcFeature) {
            throw new UnsupportedOperationException();
        }
        this.mNfcWlcStateListener.unregister(listener);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    @Nullable
    public WlcListenerDeviceInfo getWlcListenerDeviceInfo() {
        if (!sHasNfcWlcFeature) {
            throw new UnsupportedOperationException();
        }
        return NfcAdapter.callServiceReturn(() -> sService.getWlcListenerDeviceInfo(), null);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int sendVendorNciMessage(int mt, int gid, int oid, @NonNull byte[] payload) {
        Objects.requireNonNull(payload, "Payload must not be null");
        return NfcAdapter.callServiceReturn(() -> sService.sendVendorNciMessage(mt, gid, oid, payload), 3);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void registerNfcVendorNciCallback(@NonNull Executor executor, @NonNull NfcVendorNciCallback callback) {
        this.mNfcVendorNciCallbackListener.register(executor, callback);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void unregisterNfcVendorNciCallback(@NonNull NfcVendorNciCallback callback) {
        this.mNfcVendorNciCallbackListener.unregister(callback);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void indicateDataMigration(boolean inProgress) {
        NfcAdapter.callService(() -> sService.indicateDataMigration(inProgress, this.mContext.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @NonNull
    public NfcOemExtension getNfcOemExtension() {
        Object object = sLock;
        synchronized (object) {
            if (!sHasNfcFeature && !sHasCeFeature) {
                throw new UnsupportedOperationException();
            }
        }
        return this.mNfcOemExtension;
    }

    @FlaggedApi(value="android.nfc.nfc_check_tag_intent_preference")
    public boolean isTagIntentAllowed() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        if (!this.isTagIntentAppPreferenceSupported()) {
            return true;
        }
        return NfcAdapter.callServiceReturn(() -> sService.isTagIntentAllowed(this.mContext.getPackageName(), UserHandle.myUserId()), false);
    }

    static {
        sLock = new Object();
        sNfcAdapters = new HashMap();
    }

    public static interface ServiceCallReturn<T> {
        public T call() throws RemoteException;
    }

    public static interface ServiceCall {
        public void call() throws RemoteException;
    }

    public static interface ReaderCallback {
        public void onTagDiscovered(Tag var1);
    }

    public static interface OnTagRemovedListener {
        public void onTagRemoved();
    }

    @SystemApi
    public static interface NfcUnlockHandler {
        public boolean onUnlockAttempted(Tag var1);
    }

    @SystemApi
    public static interface ControllerAlwaysOnListener {
        public void onControllerAlwaysOnChanged(boolean var1);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.enable_nfc_charging")
    public static interface WlcStateListener {
        public void onWlcStateChanged(@NonNull WlcListenerDeviceInfo var1);
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
    public static interface NfcVendorNciCallback {
        @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
        public void onVendorNciResponse(int var1, int var2, @NonNull byte[] var3);

        @FlaggedApi(value="android.nfc.nfc_vendor_cmd")
        public void onVendorNciNotification(int var1, int var2, @NonNull byte[] var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SendVendorNciStatus {
    }

    @Deprecated
    public static interface CreateBeamUrisCallback {
        public Uri[] createBeamUris(NfcEvent var1);
    }

    @Deprecated
    public static interface CreateNdefMessageCallback {
        public NdefMessage createNdefMessage(NfcEvent var1);
    }

    @Deprecated
    public static interface OnNdefPushCompleteCallback {
        public void onNdefPushComplete(NfcEvent var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagIntentAppPreferenceResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ListenTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PollTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterState {
    }
}

