/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.util;

import android.content.ApexEnvironment;
import android.content.pm.ApplicationInfo;
import android.os.UserHandle;
import android.os._Original_Build;
import android.util.Log;
import com.android.wifi.x.android.sysprop.VndkProperties;
import java.io.File;

public class Environment {
    private static final String WIFI_APEX_NAME = "com.android.wifi";
    private static final String TAG = "Environment";
    private static final String WIFI_APEX_PATH = new File("/apex", "com.android.wifi").getAbsolutePath();
    private static final String MAINLINE_SUPPLICANT_BINARY_PATH = WIFI_APEX_PATH + "/bin/wpa_supplicant_mainline";

    public static File getWifiSharedDirectory() {
        return ApexEnvironment.getApexEnvironment(WIFI_APEX_NAME).getDeviceProtectedDataDir();
    }

    public static File getWifiUserDirectory(int userId) {
        return ApexEnvironment.getApexEnvironment(WIFI_APEX_NAME).getCredentialProtectedDataDirForUser(UserHandle.of(userId));
    }

    public static boolean isAppInWifiApex(ApplicationInfo appInfo) {
        return appInfo.sourceDir.startsWith(WIFI_APEX_PATH);
    }

    public static boolean isMainlineSupplicantBinaryInWifiApex() {
        return new File(MAINLINE_SUPPLICANT_BINARY_PATH).isFile();
    }

    public static boolean isVndkApiLevelNewerThan(int apiLevel) {
        int vndkApiLevel;
        block3: {
            String version = VndkProperties.vendor_vndk_version().orElse("");
            vndkApiLevel = 0;
            if (!version.isEmpty()) {
                try {
                    vndkApiLevel = Integer.parseInt(version);
                }
                catch (NumberFormatException ignore) {
                    if ("REL".equals(_Original_Build.VERSION.CODENAME)) break block3;
                    Log.d(TAG, "developer build, bypass the vndk version check");
                    return true;
                }
            }
        }
        return vndkApiLevel > apiLevel;
    }

    public static boolean isSdkAtLeastB() {
        return _Original_Build.VERSION.CODENAME.equals("Baklava") || _Original_Build.VERSION.SDK_INT >= 36;
    }

    public static boolean isSdkNewerThanB() {
        return _Original_Build.VERSION.SDK_INT > 36;
    }
}

