/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.IBooleanListener;
import android.net.wifi.usd.Characteristics;
import android.net.wifi.usd.DiscoveryResult;
import android.net.wifi.usd.IPublishSessionCallback;
import android.net.wifi.usd.ISubscribeSessionCallback;
import android.net.wifi.usd.IUsdManager;
import android.net.wifi.usd.PublishConfig;
import android.net.wifi.usd.PublishSession;
import android.net.wifi.usd.PublishSessionCallback;
import android.net.wifi.usd.SubscribeConfig;
import android.net.wifi.usd.SubscribeSession;
import android.net.wifi.usd.SubscribeSessionCallback;
import android.net.wifi.util.Environment;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
@RequiresApi(value=36)
@FlaggedApi(value="android.net.wifi.flags.usd")
public class UsdManager {
    private final Context mContext;
    private final IUsdManager mService;
    private static final String TAG = UsdManager.class.getName();
    private static final SparseArray<IBooleanListener> sPublisherAvailabilityListenerMap = new SparseArray();
    private static final SparseArray<IBooleanListener> sSubscriberAvailabilityListenerMap = new SparseArray();

    public UsdManager(@NonNull Context context, @NonNull IUsdManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public void sendMessage(int sessionId, int peerId, @NonNull byte[] message, final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultCallback) {
        try {
            this.mService.sendMessage(sessionId, peerId, message, new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) throws RemoteException {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelSubscribe(int sessionId) {
        try {
            this.mService.cancelSubscribe(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelPublish(int sessionId) {
        try {
            this.mService.cancelPublish(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updatePublish(int sessionId, byte[] serviceSpecificInfo) {
        try {
            this.mService.updatePublish(sessionId, serviceSpecificInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    @Nullable
    public Characteristics getCharacteristics() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.getCharacteristics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void publish(@NonNull PublishConfig publishConfig, @NonNull Executor executor, @NonNull PublishSessionCallback publishSessionCallback) {
        Objects.requireNonNull(publishConfig, "publishConfig must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(publishSessionCallback, "publishSessionCallback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        try {
            PublishSessionCallbackProxy publishSessionCallbackProxy = new PublishSessionCallbackProxy(this, executor, publishSessionCallback);
            this.mService.publish(publishConfig, publishSessionCallbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void subscribe(@NonNull SubscribeConfig subscribeConfig, @NonNull Executor executor, @NonNull SubscribeSessionCallback subscribeSessionCallback) {
        Objects.requireNonNull(subscribeConfig, "subscribeConfig must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(subscribeSessionCallback, "subscribeSessionCallback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        try {
            SubscribeSessionCallbackProxy subscribeSessionCallbackProxy = new SubscribeSessionCallbackProxy(this, executor, subscribeSessionCallback);
            this.mService.subscribe(subscribeConfig, subscribeSessionCallbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void registerSubscriberStatusListener(final @NonNull Executor executor, final @NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        int callbackHash = System.identityHashCode(callback);
        SparseArray<IBooleanListener> sparseArray = sSubscriberAvailabilityListenerMap;
        synchronized (sparseArray) {
            try {
                IBooleanListener.Stub listener = new IBooleanListener.Stub(this){

                    @Override
                    public void onResult(boolean value) throws RemoteException {
                        Binder.clearCallingIdentity();
                        executor.execute(() -> callback.accept(value));
                    }
                };
                sSubscriberAvailabilityListenerMap.put(callbackHash, listener);
                this.mService.registerSubscriberStatusListener(listener);
            }
            catch (RemoteException e) {
                sSubscriberAvailabilityListenerMap.remove(callbackHash);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void unregisterSubscriberStatusListener(@NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        int callbackHash = System.identityHashCode(callback);
        SparseArray<IBooleanListener> sparseArray = sSubscriberAvailabilityListenerMap;
        synchronized (sparseArray) {
            if (!sSubscriberAvailabilityListenerMap.contains(callbackHash)) {
                Log.w(TAG, "Unknown callback");
                return;
            }
            try {
                this.mService.unregisterSubscriberStatusListener(sSubscriberAvailabilityListenerMap.get(callbackHash));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sSubscriberAvailabilityListenerMap.remove(callbackHash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void registerPublisherStatusListener(final @NonNull Executor executor, final @NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        int callbackHash = System.identityHashCode(callback);
        SparseArray<IBooleanListener> sparseArray = sPublisherAvailabilityListenerMap;
        synchronized (sparseArray) {
            try {
                IBooleanListener.Stub listener = new IBooleanListener.Stub(this){

                    @Override
                    public void onResult(boolean value) throws RemoteException {
                        Binder.clearCallingIdentity();
                        executor.execute(() -> callback.accept(value));
                    }
                };
                sPublisherAvailabilityListenerMap.put(callbackHash, listener);
                this.mService.registerPublisherStatusListener(listener);
            }
            catch (RemoteException e) {
                sPublisherAvailabilityListenerMap.remove(callbackHash);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void unregisterPublisherStatusListener(@NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        int callbackHash = System.identityHashCode(callback);
        SparseArray<IBooleanListener> sparseArray = sPublisherAvailabilityListenerMap;
        synchronized (sparseArray) {
            if (!sPublisherAvailabilityListenerMap.contains(callbackHash)) {
                Log.w(TAG, "Unknown callback");
                return;
            }
            try {
                this.mService.unregisterPublisherStatusListener(sPublisherAvailabilityListenerMap.get(callbackHash));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sPublisherAvailabilityListenerMap.remove(callbackHash);
            }
        }
    }

    private static class PublishSessionCallbackProxy
    extends IPublishSessionCallback.Stub {
        private final Executor mExecutor;
        private final PublishSessionCallback mPublishSessionCallback;
        private final UsdManager mUsdManager;

        private PublishSessionCallbackProxy(UsdManager usdManager, Executor executor, PublishSessionCallback publishSessionCallback) {
            this.mUsdManager = usdManager;
            this.mExecutor = executor;
            this.mPublishSessionCallback = publishSessionCallback;
        }

        @Override
        public void onPublishFailed(int reasonCode) throws RemoteException {
            Log.d(TAG, "onPublishFailed (reasonCode = " + reasonCode + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mPublishSessionCallback.onPublishFailed(reasonCode));
        }

        @Override
        public void onPublishStarted(int sessionId) throws RemoteException {
            Log.d(TAG, "onPublishStarted ( sessionId = " + sessionId + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mPublishSessionCallback.onPublishStarted(new PublishSession(this.mUsdManager, sessionId)));
        }

        @Override
        public void onPublishReplied(int peerId, byte[] ssi, int protoType, boolean isFsdEnabled) throws RemoteException {
            Log.d(TAG, "onPublishReplied ( peerId = " + peerId + ", protoType = " + protoType + ", isFsdEnabled = " + isFsdEnabled + " )");
            Binder.clearCallingIdentity();
            DiscoveryResult discoveryResult = new DiscoveryResult.Builder(peerId).setServiceSpecificInfo(ssi).setServiceProtoType(protoType).setFsdEnabled(isFsdEnabled).build();
            this.mExecutor.execute(() -> this.mPublishSessionCallback.onPublishReplied(discoveryResult));
        }

        @Override
        public void onPublishSessionTerminated(int reasonCode) throws RemoteException {
            Log.d(TAG, "onPublishSessionTerminated ( reasonCode = " + reasonCode + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mPublishSessionCallback.onSessionTerminated(reasonCode));
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
            Log.d(TAG, "onMessageReceived ( peerId = " + peerId + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mPublishSessionCallback.onMessageReceived(peerId, message));
        }
    }

    private static class SubscribeSessionCallbackProxy
    extends ISubscribeSessionCallback.Stub {
        private final UsdManager mUsdManager;
        private final Executor mExecutor;
        private final SubscribeSessionCallback mSubscribeSessionCallback;

        private SubscribeSessionCallbackProxy(UsdManager usdManager, Executor executor, SubscribeSessionCallback subscribeSessionCallback) {
            this.mUsdManager = usdManager;
            this.mExecutor = executor;
            this.mSubscribeSessionCallback = subscribeSessionCallback;
        }

        @Override
        public void onSubscribeFailed(int reasonCode) throws RemoteException {
            Log.d(TAG, "onSubscribeFailed (reasonCode = " + reasonCode + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mSubscribeSessionCallback.onSubscribeFailed(reasonCode));
        }

        @Override
        public void onSubscribeStarted(int sessionId) throws RemoteException {
            Log.d(TAG, "onSubscribeStarted ( sessionId = " + sessionId + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mSubscribeSessionCallback.onSubscribeStarted(new SubscribeSession(this.mUsdManager, sessionId)));
        }

        @Override
        public void onSubscribeDiscovered(int peerId, byte[] ssi, int protoType, boolean isFsdEnabled) throws RemoteException {
            Log.d(TAG, "onSubscribeDiscovered ( peerId = " + peerId + ", protoType = " + protoType + ", isFsdEnabled = " + isFsdEnabled + " )");
            Binder.clearCallingIdentity();
            DiscoveryResult discoveryResult = new DiscoveryResult.Builder(peerId).setServiceSpecificInfo(ssi).setServiceProtoType(protoType).setFsdEnabled(isFsdEnabled).build();
            this.mExecutor.execute(() -> this.mSubscribeSessionCallback.onServiceDiscovered(discoveryResult));
        }

        @Override
        public void onSubscribeSessionTerminated(int reasonCode) throws RemoteException {
            Log.d(TAG, "onSubscribeSessionTerminated ( reasonCode = " + reasonCode + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mSubscribeSessionCallback.onSessionTerminated(reasonCode));
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
            Log.d(TAG, "onMessageReceived ( peerId = " + peerId + " )");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mSubscribeSessionCallback.onMessageReceived(peerId, message));
        }
    }
}

