/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPublishSessionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.usd.IPublishSessionCallback";

    public void onPublishFailed(int var1) throws RemoteException;

    public void onPublishStarted(int var1) throws RemoteException;

    public void onPublishReplied(int var1, byte[] var2, int var3, boolean var4) throws RemoteException;

    public void onPublishSessionTerminated(int var1) throws RemoteException;

    public void onMessageReceived(int var1, byte[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPublishSessionCallback {
        static final int TRANSACTION_onPublishFailed = 1;
        static final int TRANSACTION_onPublishStarted = 2;
        static final int TRANSACTION_onPublishReplied = 3;
        static final int TRANSACTION_onPublishSessionTerminated = 4;
        static final int TRANSACTION_onMessageReceived = 5;

        public Stub() {
            this.attachInterface(this, IPublishSessionCallback.DESCRIPTOR);
        }

        public static IPublishSessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPublishSessionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IPublishSessionCallback) {
                return (IPublishSessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onPublishFailed";
                }
                case 2: {
                    return "onPublishStarted";
                }
                case 3: {
                    return "onPublishReplied";
                }
                case 4: {
                    return "onPublishSessionTerminated";
                }
                case 5: {
                    return "onMessageReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPublishSessionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onPublishFailed(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onPublishStarted(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    this.onPublishReplied(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.onPublishSessionTerminated(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    this.onMessageReceived(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IPublishSessionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPublishSessionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishFailed(int reasonCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPublishSessionCallback.DESCRIPTOR);
                    _data.writeInt(reasonCode);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishStarted(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPublishSessionCallback.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishReplied(int peerId, byte[] ssi, int protoType, boolean isFsdEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPublishSessionCallback.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeByteArray(ssi);
                    _data.writeInt(protoType);
                    _data.writeBoolean(isFsdEnabled);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishSessionTerminated(int reasonCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPublishSessionCallback.DESCRIPTOR);
                    _data.writeInt(reasonCode);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPublishSessionCallback.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeByteArray(message);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPublishSessionCallback {
        @Override
        public void onPublishFailed(int reasonCode) throws RemoteException {
        }

        @Override
        public void onPublishStarted(int sessionId) throws RemoteException {
        }

        @Override
        public void onPublishReplied(int peerId, byte[] ssi, int protoType, boolean isFsdEnabled) throws RemoteException {
        }

        @Override
        public void onPublishSessionTerminated(int reasonCode) throws RemoteException {
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

