/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.PasnConfig;
import android.net.wifi.rtt.SecureRangingConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ResponderConfig
implements Parcelable {
    private static final String TAG = "ResponderConfig";
    private static final int AWARE_BAND_2_DISCOVERY_CHANNEL = 2437;
    public static final int RESPONDER_AP = 0;
    public static final int RESPONDER_STA = 1;
    @SystemApi
    public static final int RESPONDER_P2P_GO = 2;
    @SystemApi
    public static final int RESPONDER_P2P_CLIENT = 3;
    @SystemApi
    public static final int RESPONDER_AWARE = 4;
    @SystemApi
    public static final int CHANNEL_WIDTH_20MHZ = 0;
    @SystemApi
    public static final int CHANNEL_WIDTH_40MHZ = 1;
    @SystemApi
    public static final int CHANNEL_WIDTH_80MHZ = 2;
    @SystemApi
    public static final int CHANNEL_WIDTH_160MHZ = 3;
    @SystemApi
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4;
    @SystemApi
    public static final int CHANNEL_WIDTH_320MHZ = 5;
    @SystemApi
    public static final int PREAMBLE_LEGACY = 0;
    @SystemApi
    public static final int PREAMBLE_HT = 1;
    @SystemApi
    public static final int PREAMBLE_VHT = 2;
    @SystemApi
    public static final int PREAMBLE_HE = 3;
    @SystemApi
    public static final int PREAMBLE_EHT = 4;
    private static final long DEFAULT_NTB_MIN_TIME_BETWEEN_MEASUREMENTS_MICROS = 250000L;
    private static final long DEFAULT_NTB_MAX_TIME_BETWEEN_MEASUREMENTS_MICROS = 15000000L;
    @SystemApi
    @Nullable
    public final MacAddress macAddress;
    @SystemApi
    @Nullable
    public final PeerHandle peerHandle;
    @SystemApi
    public final int responderType;
    @SystemApi
    public final boolean supports80211mc;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public final boolean supports80211azNtb;
    @SystemApi
    public final int channelWidth;
    @SystemApi
    public final int frequency;
    @SystemApi
    public final int centerFreq0;
    @SystemApi
    public final int centerFreq1;
    @SystemApi
    public final int preamble;
    private long mNtbMinMeasurementTime = 250000L;
    private long mNtbMaxMeasurementTime = 15000000L;
    private final SecureRangingConfig mSecureRangingConfig;
    @NonNull
    public static final Parcelable.Creator<ResponderConfig> CREATOR = new Parcelable.Creator<ResponderConfig>(){

        public ResponderConfig[] newArray(int size) {
            return new ResponderConfig[size];
        }

        @Override
        public ResponderConfig createFromParcel(Parcel in) {
            boolean macAddressPresent = in.readBoolean();
            MacAddress macAddress = null;
            if (macAddressPresent) {
                macAddress = MacAddress.CREATOR.createFromParcel(in);
            }
            boolean peerHandlePresent = in.readBoolean();
            PeerHandle peerHandle = null;
            if (peerHandlePresent) {
                peerHandle = new PeerHandle(in.readInt());
            }
            Builder builder = new Builder().setMacAddress(macAddress).setPeerHandle(peerHandle).setResponderType(in.readInt()).set80211mcSupported(in.readBoolean()).set80211azNtbSupported(in.readBoolean()).setChannelWidth(in.readInt()).setFrequencyMhz(in.readInt()).setCenterFreq0Mhz(in.readInt()).setCenterFreq1Mhz(in.readInt()).setPreamble(in.readInt()).setNtbMinTimeBetweenMeasurementsMicros(in.readLong()).setNtbMaxTimeBetweenMeasurementsMicros(in.readLong());
            SecureRangingConfig secureRangingConfig = (SecureRangingConfig)in.readParcelable(SecureRangingConfig.class.getClassLoader());
            if (secureRangingConfig != null) {
                builder.setSecureRangingConfig(secureRangingConfig);
            }
            return new ResponderConfig(builder);
        }
    };

    public ResponderConfig(Builder builder) {
        if (builder.mMacAddress == null && builder.mPeerHandle == null) {
            throw new IllegalArgumentException("Invalid ResponderConfig - must specify a MAC address or Peer handle");
        }
        this.macAddress = builder.mMacAddress;
        this.peerHandle = builder.mPeerHandle;
        this.responderType = builder.mResponderType;
        this.supports80211mc = builder.mSupports80211Mc;
        this.supports80211azNtb = builder.mSupports80211azNtb;
        this.channelWidth = builder.mChannelWidth;
        this.frequency = builder.mFrequency;
        this.centerFreq0 = builder.mCenterFreq0;
        this.centerFreq1 = builder.mCenterFreq1;
        this.preamble = builder.mPreamble;
        this.mNtbMinMeasurementTime = builder.mNtbMinMeasurementTime;
        this.mNtbMaxMeasurementTime = builder.mNtbMaxMeasurementTime;
        this.mSecureRangingConfig = builder.mSecureRangingConfig;
    }

    @SystemApi
    public ResponderConfig(@NonNull MacAddress macAddress, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        if (macAddress == null) {
            throw new IllegalArgumentException("Invalid ResponderConfig - must specify a MAC address");
        }
        this.macAddress = macAddress;
        this.peerHandle = null;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
        this.supports80211azNtb = false;
        this.mNtbMinMeasurementTime = 250000L;
        this.mNtbMaxMeasurementTime = 15000000L;
        this.mSecureRangingConfig = null;
    }

    @SystemApi
    public ResponderConfig(@NonNull PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = null;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
        this.supports80211azNtb = false;
        this.mNtbMinMeasurementTime = 250000L;
        this.mNtbMaxMeasurementTime = 15000000L;
        this.mSecureRangingConfig = null;
    }

    public ResponderConfig(@NonNull MacAddress macAddress, @NonNull PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = macAddress;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
        this.supports80211azNtb = false;
        this.mNtbMinMeasurementTime = 250000L;
        this.mNtbMaxMeasurementTime = 15000000L;
        this.mSecureRangingConfig = null;
    }

    @NonNull
    public static ResponderConfig fromScanResult(@NonNull ScanResult scanResult) {
        int preamble;
        boolean isHeOrEhtAllowed;
        MacAddress macAddress = MacAddress.fromString(scanResult.BSSID);
        int responderType = 0;
        boolean supports80211mc = scanResult.is80211mcResponder();
        boolean supports80211azNtbRanging = scanResult.is80211azNtbResponder();
        int channelWidth = scanResult.channelWidth;
        int frequency = scanResult.frequency;
        int centerFreq0 = scanResult.centerFreq0;
        int centerFreq1 = scanResult.centerFreq1;
        boolean bl = isHeOrEhtAllowed = supports80211azNtbRanging || ScanResult.is6GHz(frequency);
        if (scanResult.informationElements != null && scanResult.informationElements.length != 0) {
            boolean htCapabilitiesPresent = false;
            boolean vhtCapabilitiesPresent = false;
            boolean heCapabilitiesPresent = false;
            boolean ehtCapabilitiesPresent = false;
            for (ScanResult.InformationElement ie : scanResult.informationElements) {
                if (ie.id == 45) {
                    htCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id == 191) {
                    vhtCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id == 255 && ie.idExt == 35) {
                    heCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id != 255 || ie.idExt != 108) continue;
                ehtCapabilitiesPresent = true;
            }
            preamble = ehtCapabilitiesPresent && isHeOrEhtAllowed ? 4 : (supports80211azNtbRanging || heCapabilitiesPresent && isHeOrEhtAllowed ? 3 : (vhtCapabilitiesPresent ? 2 : (htCapabilitiesPresent ? 1 : 0)));
        } else {
            Log.e(TAG, "Scan Results do not contain IEs - using backup method to select preamble");
            preamble = channelWidth == 5 && isHeOrEhtAllowed ? 4 : (channelWidth == 5 || channelWidth == 2 || channelWidth == 3 ? 2 : 1);
        }
        Builder builder = new Builder().setMacAddress(macAddress).setResponderType(responderType).set80211mcSupported(supports80211mc).set80211azNtbSupported(supports80211azNtbRanging).setChannelWidth(channelWidth).setFrequencyMhz(frequency).setCenterFreq0Mhz(centerFreq0).setCenterFreq1Mhz(centerFreq1).setPreamble(preamble);
        if (ResponderConfig.isSecureRangingResponder(scanResult)) {
            builder.setSecureRangingConfig(ResponderConfig.getSecureRangingConfig(scanResult));
        }
        return builder.build();
    }

    private static boolean isSecureRangingResponder(ScanResult scanResult) {
        return scanResult.capabilities != null && scanResult.capabilities.contains("PASN");
    }

    private static SecureRangingConfig getSecureRangingConfig(ScanResult scanResult) {
        PasnConfig.Builder pasnConfigBuilder = new PasnConfig.Builder(PasnConfig.getBaseAkmsFromCapabilities(scanResult.capabilities), PasnConfig.getCiphersFromCapabilities(scanResult.capabilities));
        if (scanResult.getWifiSsid() != null) {
            pasnConfigBuilder.setWifiSsid(scanResult.getWifiSsid());
        }
        return new SecureRangingConfig.Builder(pasnConfigBuilder.build()).setSecureHeLtfEnabled(scanResult.isSecureHeLtfSupported()).setRangingFrameProtectionEnabled(true).build();
    }

    @SystemApi
    @NonNull
    public static ResponderConfig fromWifiAwarePeerMacAddressWithDefaults(@NonNull MacAddress macAddress) {
        return new Builder().setMacAddress(macAddress).setResponderType(4).build();
    }

    @SystemApi
    @NonNull
    public static ResponderConfig fromWifiAwarePeerHandleWithDefaults(@NonNull PeerHandle peerHandle) {
        return new Builder().setPeerHandle(peerHandle).setResponderType(4).build();
    }

    private static boolean isResponderTypeSupported(int responderType) {
        switch (responderType) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean isValid(boolean awareSupported) {
        if (!ResponderConfig.isResponderTypeSupported(this.responderType)) {
            return false;
        }
        if (this.macAddress == null && this.peerHandle == null || this.macAddress != null && this.peerHandle != null) {
            return false;
        }
        return awareSupported || this.responderType != 4;
    }

    @Nullable
    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    @Nullable
    public PeerHandle getPeerHandle() {
        return this.peerHandle;
    }

    public boolean is80211mcSupported() {
        return this.supports80211mc;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean is80211azNtbSupported() {
        return this.supports80211azNtb;
    }

    public int getChannelWidth() {
        return ResponderConfig.translateFromLocalToScanResultChannelWidth(this.channelWidth);
    }

    public int getFrequencyMhz() {
        return this.frequency;
    }

    public int getCenterFreq0Mhz() {
        return this.centerFreq0;
    }

    public int getCenterFreq1Mhz() {
        return this.centerFreq1;
    }

    public int getPreamble() {
        return ResponderConfig.translateFromLocalToScanResultPreamble(this.preamble);
    }

    public int getResponderType() {
        return this.responderType;
    }

    public long getNtbMinTimeBetweenMeasurementsMicros() {
        return this.mNtbMinMeasurementTime;
    }

    public long getNtbMaxTimeBetweenMeasurementsMicros() {
        return this.mNtbMaxMeasurementTime;
    }

    public void setNtbMinTimeBetweenMeasurementsMicros(long ntbMinMeasurementTime) {
        this.mNtbMinMeasurementTime = ntbMinMeasurementTime;
    }

    public void setNtbMaxTimeBetweenMeasurementsMicros(long ntbMaxMeasurementTime) {
        this.mNtbMaxMeasurementTime = ntbMaxMeasurementTime;
    }

    @Nullable
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public SecureRangingConfig getSecureRangingConfig() {
        return this.mSecureRangingConfig;
    }

    private static boolean isHeSupported(int preamble) {
        return preamble != 0 && preamble != 1 && preamble != 2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        if (this.macAddress == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.macAddress.writeToParcel(dest, flags);
        }
        if (this.peerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.peerHandle.peerId);
        }
        dest.writeInt(this.responderType);
        dest.writeBoolean(this.supports80211mc);
        dest.writeBoolean(this.supports80211azNtb);
        dest.writeInt(this.channelWidth);
        dest.writeInt(this.frequency);
        dest.writeInt(this.centerFreq0);
        dest.writeInt(this.centerFreq1);
        dest.writeInt(this.preamble);
        dest.writeLong(this.mNtbMinMeasurementTime);
        dest.writeLong(this.mNtbMaxMeasurementTime);
        dest.writeParcelable(this.mSecureRangingConfig, flags);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponderConfig)) {
            return false;
        }
        ResponderConfig lhs = (ResponderConfig)o;
        return Objects.equals(this.macAddress, lhs.macAddress) && Objects.equals(this.peerHandle, lhs.peerHandle) && this.responderType == lhs.responderType && this.supports80211mc == lhs.supports80211mc && this.channelWidth == lhs.channelWidth && this.frequency == lhs.frequency && this.centerFreq0 == lhs.centerFreq0 && this.centerFreq1 == lhs.centerFreq1 && this.preamble == lhs.preamble && this.supports80211azNtb == lhs.supports80211azNtb && this.mNtbMinMeasurementTime == lhs.mNtbMinMeasurementTime && this.mNtbMaxMeasurementTime == lhs.mNtbMaxMeasurementTime && Objects.equals(this.mSecureRangingConfig, lhs.mSecureRangingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.macAddress, this.peerHandle, this.responderType, this.supports80211mc, this.channelWidth, this.frequency, this.centerFreq0, this.centerFreq1, this.preamble, this.supports80211azNtb, this.mNtbMinMeasurementTime, this.mNtbMaxMeasurementTime, this.mSecureRangingConfig);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ResponderConfig: macAddress=").append(this.macAddress).append(", peerHandle=").append(this.peerHandle == null ? "<null>" : Integer.valueOf(this.peerHandle.peerId)).append(", responderType=").append(this.responderType).append(", supports80211mc=").append(this.supports80211mc).append(", channelWidth=").append(this.channelWidth).append(", frequency=").append(this.frequency).append(", centerFreq0=").append(this.centerFreq0).append(", centerFreq1=").append(this.centerFreq1).append(", preamble=").append(this.preamble).append(", supports80211azNtb=").append(this.supports80211azNtb).append(", mNtbMinMeasurementTime=").append(this.mNtbMinMeasurementTime).append(", mNtbMaxMeasurementTime=").append(this.mNtbMaxMeasurementTime);
        if (this.mSecureRangingConfig != null) {
            sb.append(", mSecureRangingConfig=").append(this.mSecureRangingConfig);
        }
        return sb.toString();
    }

    public static int translateFromScanResultToLocalChannelWidth(int scanResultChannelWidth) {
        switch (scanResultChannelWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        throw new IllegalArgumentException("translateFromScanResultChannelWidth: bad " + scanResultChannelWidth);
    }

    public static int translateFromLocalToScanResultChannelWidth(int localChannelWidth) {
        switch (localChannelWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        throw new IllegalArgumentException("translateFromLocalChannelWidth: bad " + localChannelWidth);
    }

    public static int translateFromScanResultToLocalPreamble(int scanResultPreamble) {
        switch (scanResultPreamble) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("translateFromScanResultPreamble: bad " + scanResultPreamble);
    }

    public static int translateFromLocalToScanResultPreamble(int localPreamble) {
        switch (localPreamble) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("translateFromLocalPreamble: bad " + localPreamble);
    }

    public static class Builder {
        private MacAddress mMacAddress;
        private PeerHandle mPeerHandle;
        private int mResponderType = 0;
        private boolean mSupports80211Mc = true;
        private boolean mSupports80211azNtb = false;
        private int mChannelWidth = 0;
        private int mFrequency = 0;
        private int mCenterFreq0 = 0;
        private int mCenterFreq1 = 0;
        private int mPreamble = 0;
        private long mNtbMinMeasurementTime = 250000L;
        private long mNtbMaxMeasurementTime = 15000000L;
        private SecureRangingConfig mSecureRangingConfig = null;

        @NonNull
        public Builder setMacAddress(@NonNull MacAddress macAddress) {
            this.mMacAddress = macAddress;
            return this;
        }

        @NonNull
        public Builder setPeerHandle(@NonNull PeerHandle peerHandle) {
            this.mPeerHandle = peerHandle;
            return this;
        }

        @NonNull
        public Builder set80211mcSupported(boolean supports80211mc) {
            this.mSupports80211Mc = supports80211mc;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azNtbSupported(boolean supports80211azNtb) {
            this.mSupports80211azNtb = supports80211azNtb;
            return this;
        }

        @NonNull
        public Builder setChannelWidth(int channelWidth) {
            this.mChannelWidth = ResponderConfig.translateFromScanResultToLocalChannelWidth(channelWidth);
            return this;
        }

        @NonNull
        public Builder setFrequencyMhz(int frequency) {
            this.mFrequency = frequency;
            return this;
        }

        @NonNull
        public Builder setCenterFreq0Mhz(int centerFreq0) {
            this.mCenterFreq0 = centerFreq0;
            return this;
        }

        @NonNull
        public Builder setCenterFreq1Mhz(int centerFreq1) {
            this.mCenterFreq1 = centerFreq1;
            return this;
        }

        @NonNull
        public Builder setPreamble(int preamble) {
            this.mPreamble = ResponderConfig.translateFromScanResultToLocalPreamble(preamble);
            return this;
        }

        @NonNull
        public Builder setResponderType(int responderType) {
            if (!ResponderConfig.isResponderTypeSupported(responderType)) {
                throw new IllegalArgumentException("invalid responder type " + responderType);
            }
            this.mResponderType = responderType;
            return this;
        }

        public Builder setNtbMinTimeBetweenMeasurementsMicros(long ntbMinMeasurementTime) {
            if (this.mNtbMinMeasurementTime == 0L || this.mNtbMinMeasurementTime >= 0x19000000L) {
                throw new IllegalArgumentException("Should be a non-zero number less than 419430400 microseconds");
            }
            if (this.mNtbMinMeasurementTime % 100L != 0L) {
                throw new IllegalArgumentException("Should be a multiple of 100 microseconds");
            }
            this.mNtbMinMeasurementTime = ntbMinMeasurementTime;
            return this;
        }

        public Builder setNtbMaxTimeBetweenMeasurementsMicros(long ntbMaxMeasurementTime) {
            if (this.mNtbMaxMeasurementTime % 10000L != 0L) {
                throw new IllegalArgumentException("Should be a multiple of 10000 microseconds");
            }
            if (this.mNtbMaxMeasurementTime == 0L || this.mNtbMaxMeasurementTime >= 5242880000L) {
                throw new IllegalArgumentException("Should be a non-zero number less than 5242880000 microseconds");
            }
            this.mNtbMaxMeasurementTime = ntbMaxMeasurementTime;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setSecureRangingConfig(@NonNull SecureRangingConfig secureRangingConfig) {
            Objects.requireNonNull(secureRangingConfig, "secureRangingConfig cannot be null");
            this.mSecureRangingConfig = secureRangingConfig;
            return this;
        }

        @NonNull
        public ResponderConfig build() {
            if (this.mMacAddress == null && this.mPeerHandle == null || this.mMacAddress != null && this.mPeerHandle != null) {
                throw new IllegalArgumentException("Invalid ResponderConfig - must specify a MAC address or peer handle but not both");
            }
            if (this.mSupports80211azNtb && !ResponderConfig.isHeSupported(this.mPreamble)) {
                throw new IllegalArgumentException("IEEE 802.11az responder must support HE preamble");
            }
            if (this.mResponderType == 4) {
                this.mSupports80211Mc = true;
                this.mFrequency = 2437;
                this.mChannelWidth = 0;
                this.mPreamble = 1;
            }
            return new ResponderConfig(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreambleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelWidth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResponderType {
    }
}

