/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pGroupList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiP2pListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.p2p.IWifiP2pListener";

    public void onP2pStateChanged(int var1) throws RemoteException;

    public void onDiscoveryStateChanged(int var1) throws RemoteException;

    public void onListenStateChanged(int var1) throws RemoteException;

    public void onDeviceConfigurationChanged(WifiP2pDevice var1) throws RemoteException;

    public void onPeerListChanged(WifiP2pDeviceList var1) throws RemoteException;

    public void onPersistentGroupsChanged(WifiP2pGroupList var1) throws RemoteException;

    public void onGroupCreating() throws RemoteException;

    public void onGroupNegotiationRejectedByUser() throws RemoteException;

    public void onGroupCreationFailed(int var1) throws RemoteException;

    public void onGroupCreated(WifiP2pInfo var1, WifiP2pGroup var2) throws RemoteException;

    public void onPeerClientJoined(WifiP2pInfo var1, WifiP2pGroup var2) throws RemoteException;

    public void onPeerClientDisconnected(WifiP2pInfo var1, WifiP2pGroup var2) throws RemoteException;

    public void onFrequencyChanged(WifiP2pInfo var1, WifiP2pGroup var2) throws RemoteException;

    public void onGroupRemoved() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiP2pListener {
        static final int TRANSACTION_onP2pStateChanged = 1;
        static final int TRANSACTION_onDiscoveryStateChanged = 2;
        static final int TRANSACTION_onListenStateChanged = 3;
        static final int TRANSACTION_onDeviceConfigurationChanged = 4;
        static final int TRANSACTION_onPeerListChanged = 5;
        static final int TRANSACTION_onPersistentGroupsChanged = 6;
        static final int TRANSACTION_onGroupCreating = 7;
        static final int TRANSACTION_onGroupNegotiationRejectedByUser = 8;
        static final int TRANSACTION_onGroupCreationFailed = 9;
        static final int TRANSACTION_onGroupCreated = 10;
        static final int TRANSACTION_onPeerClientJoined = 11;
        static final int TRANSACTION_onPeerClientDisconnected = 12;
        static final int TRANSACTION_onFrequencyChanged = 13;
        static final int TRANSACTION_onGroupRemoved = 14;

        public Stub() {
            this.attachInterface(this, IWifiP2pListener.DESCRIPTOR);
        }

        public static IWifiP2pListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiP2pListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiP2pListener) {
                return (IWifiP2pListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onP2pStateChanged";
                }
                case 2: {
                    return "onDiscoveryStateChanged";
                }
                case 3: {
                    return "onListenStateChanged";
                }
                case 4: {
                    return "onDeviceConfigurationChanged";
                }
                case 5: {
                    return "onPeerListChanged";
                }
                case 6: {
                    return "onPersistentGroupsChanged";
                }
                case 7: {
                    return "onGroupCreating";
                }
                case 8: {
                    return "onGroupNegotiationRejectedByUser";
                }
                case 9: {
                    return "onGroupCreationFailed";
                }
                case 10: {
                    return "onGroupCreated";
                }
                case 11: {
                    return "onPeerClientJoined";
                }
                case 12: {
                    return "onPeerClientDisconnected";
                }
                case 13: {
                    return "onFrequencyChanged";
                }
                case 14: {
                    return "onGroupRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiP2pListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onP2pStateChanged(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onDiscoveryStateChanged(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    this.onListenStateChanged(_arg0);
                    break;
                }
                case 4: {
                    WifiP2pDevice _arg0 = data.readTypedObject(WifiP2pDevice.CREATOR);
                    this.onDeviceConfigurationChanged(_arg0);
                    break;
                }
                case 5: {
                    WifiP2pDeviceList _arg0 = data.readTypedObject(WifiP2pDeviceList.CREATOR);
                    this.onPeerListChanged(_arg0);
                    break;
                }
                case 6: {
                    WifiP2pGroupList _arg0 = data.readTypedObject(WifiP2pGroupList.CREATOR);
                    this.onPersistentGroupsChanged(_arg0);
                    break;
                }
                case 7: {
                    this.onGroupCreating();
                    break;
                }
                case 8: {
                    this.onGroupNegotiationRejectedByUser();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    this.onGroupCreationFailed(_arg0);
                    break;
                }
                case 10: {
                    WifiP2pInfo _arg0 = data.readTypedObject(WifiP2pInfo.CREATOR);
                    WifiP2pGroup _arg1 = data.readTypedObject(WifiP2pGroup.CREATOR);
                    this.onGroupCreated(_arg0, _arg1);
                    break;
                }
                case 11: {
                    WifiP2pInfo _arg0 = data.readTypedObject(WifiP2pInfo.CREATOR);
                    WifiP2pGroup _arg1 = data.readTypedObject(WifiP2pGroup.CREATOR);
                    this.onPeerClientJoined(_arg0, _arg1);
                    break;
                }
                case 12: {
                    WifiP2pInfo _arg0 = data.readTypedObject(WifiP2pInfo.CREATOR);
                    WifiP2pGroup _arg1 = data.readTypedObject(WifiP2pGroup.CREATOR);
                    this.onPeerClientDisconnected(_arg0, _arg1);
                    break;
                }
                case 13: {
                    WifiP2pInfo _arg0 = data.readTypedObject(WifiP2pInfo.CREATOR);
                    WifiP2pGroup _arg1 = data.readTypedObject(WifiP2pGroup.CREATOR);
                    this.onFrequencyChanged(_arg0, _arg1);
                    break;
                }
                case 14: {
                    this.onGroupRemoved();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IWifiP2pListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiP2pListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onP2pStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDiscoveryStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceConfigurationChanged(WifiP2pDevice p2pDevice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pDevice, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPeerListChanged(WifiP2pDeviceList p2pDeviceList) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pDeviceList, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPersistentGroupsChanged(WifiP2pGroupList p2pGroupList) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pGroupList, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onGroupCreating() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onGroupNegotiationRejectedByUser() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupCreationFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupCreated(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pInfo, 0);
                    _data.writeTypedObject(p2pGroup, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPeerClientJoined(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pInfo, 0);
                    _data.writeTypedObject(p2pGroup, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPeerClientDisconnected(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pInfo, 0);
                    _data.writeTypedObject(p2pGroup, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFrequencyChanged(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    _data.writeTypedObject(p2pInfo, 0);
                    _data.writeTypedObject(p2pGroup, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onGroupRemoved() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiP2pListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiP2pListener {
        @Override
        public void onP2pStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onDiscoveryStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onListenStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onDeviceConfigurationChanged(WifiP2pDevice p2pDevice) throws RemoteException {
        }

        @Override
        public void onPeerListChanged(WifiP2pDeviceList p2pDeviceList) throws RemoteException {
        }

        @Override
        public void onPersistentGroupsChanged(WifiP2pGroupList p2pGroupList) throws RemoteException {
        }

        @Override
        public void onGroupCreating() throws RemoteException {
        }

        @Override
        public void onGroupNegotiationRejectedByUser() throws RemoteException {
        }

        @Override
        public void onGroupCreationFailed(int reason) throws RemoteException {
        }

        @Override
        public void onGroupCreated(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
        }

        @Override
        public void onPeerClientJoined(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
        }

        @Override
        public void onPeerClientDisconnected(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
        }

        @Override
        public void onFrequencyChanged(WifiP2pInfo p2pInfo, WifiP2pGroup p2pGroup) throws RemoteException {
        }

        @Override
        public void onGroupRemoved() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

