/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.MacAddress;
import android.net.NetworkSpecifier;
import android.net.wifi.IBooleanListener;
import android.net.wifi.IIntegerListener;
import android.net.wifi.IListListener;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.AwarePairingConfig;
import android.net.wifi.aware.AwareParams;
import android.net.wifi.aware.AwareResources;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.ConfigRequest;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareDiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareEventCallback;
import android.net.wifi.aware.IWifiAwareMacAddressProvider;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.IdentityChangedListener;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.ServiceDiscoveryInfo;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.aware.WifiAwareSession;
import android.net.wifi.aware.WifiAwareUtils;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.util.HexEncoding;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.HandlerExecutor;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class WifiAwareManager {
    private static final String TAG = "WifiAwareManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final String ACTION_WIFI_AWARE_STATE_CHANGED = "android.net.wifi.aware.action.WIFI_AWARE_STATE_CHANGED";
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static final String ACTION_WIFI_AWARE_RESOURCE_CHANGED = "android.net.wifi.aware.action.WIFI_AWARE_RESOURCE_CHANGED";
    public static final String EXTRA_AWARE_RESOURCES = "android.net.wifi.aware.extra.AWARE_RESOURCES";
    public static final int WIFI_AWARE_DATA_PATH_ROLE_INITIATOR = 0;
    public static final int WIFI_AWARE_DATA_PATH_ROLE_RESPONDER = 1;
    public static final int WIFI_AWARE_DISCOVERY_LOST_REASON_UNKNOWN = 0;
    public static final int WIFI_AWARE_DISCOVERY_LOST_REASON_PEER_NOT_VISIBLE = 1;
    @SystemApi
    public static final int WIFI_AWARE_SUSPEND_REDUNDANT_REQUEST = 0;
    @SystemApi
    public static final int WIFI_AWARE_SUSPEND_INVALID_SESSION = 1;
    @SystemApi
    public static final int WIFI_AWARE_SUSPEND_CANNOT_SUSPEND = 2;
    @SystemApi
    public static final int WIFI_AWARE_SUSPEND_INTERNAL_ERROR = 3;
    @SystemApi
    public static final int WIFI_AWARE_RESUME_REDUNDANT_REQUEST = 0;
    @SystemApi
    public static final int WIFI_AWARE_RESUME_INVALID_SESSION = 1;
    @SystemApi
    public static final int WIFI_AWARE_RESUME_INTERNAL_ERROR = 2;
    private final Context mContext;
    private final IWifiAwareManager mService;
    private final Object mLock = new Object();

    public WifiAwareManager(@NonNull Context context, @NonNull IWifiAwareManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isAvailable() {
        try {
            return this.mService.isUsageEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isDeviceAttached() {
        try {
            return this.mService.isDeviceAttached();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isSetChannelOnDataPathSupported() {
        try {
            return this.mService.isSetChannelOnDataPathSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(allOf={"android.permission.CHANGE_WIFI_STATE", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void enableInstantCommunicationMode(boolean enable) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.mService.enableInstantCommunicationMode(this.mContext.getOpPackageName(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isInstantCommunicationModeEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.isInstantCommunicationModeEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @Nullable
    public Characteristics getCharacteristics() {
        try {
            return this.mService.getCharacteristics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @Nullable
    public AwareResources getAvailableAwareResources() {
        try {
            return this.mService.getAvailableAwareResources();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    public void attach(@NonNull AttachCallback attachCallback, @Nullable Handler handler) {
        this.attach(handler, null, attachCallback, null, false, null);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void attach(@NonNull AttachCallback attachCallback, @NonNull IdentityChangedListener identityChangedListener, @Nullable Handler handler) {
        this.attach(handler, null, attachCallback, identityChangedListener, false, null);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"}, conditional=true)
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void attach(@NonNull ConfigRequest configRequest, @NonNull Executor executor, @NonNull AttachCallback attachCallback, @NonNull IdentityChangedListener identityChangedListener) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(configRequest);
        Objects.requireNonNull(executor);
        this.attach(null, configRequest, attachCallback, identityChangedListener, false, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Handler handler, ConfigRequest configRequest, AttachCallback attachCallback, IdentityChangedListener identityChangedListener, boolean forOffloading, Executor executor) {
        if (attachCallback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        Object object = this.mLock;
        synchronized (object) {
            Executor localExecutor = executor;
            if (localExecutor == null) {
                localExecutor = new HandlerExecutor(handler == null ? new Handler(Looper.getMainLooper()) : handler);
            }
            try {
                Binder binder = new Binder();
                Bundle extras = new Bundle();
                if (SdkLevel.isAtLeastS()) {
                    extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
                }
                this.mService.connect(binder, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), new WifiAwareEventCallbackProxy(this, localExecutor, binder, attachCallback, identityChangedListener), configRequest, identityChangedListener != null, extras, forOffloading);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void disconnect(int clientId, Binder binder) {
        try {
            this.mService.disconnect(clientId, binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setMasterPreference(int clientId, Binder binder, int mp) {
        try {
            this.mService.setMasterPreference(clientId, binder, mp);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getMasterPreference(int clientId, Binder binder, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getMasterPreference(clientId, binder, new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void publish(int clientId, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            this.mService.publish(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), clientId, publishConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, true, callback, clientId), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updatePublish(int clientId, int sessionId, PublishConfig publishConfig) {
        try {
            this.mService.updatePublish(clientId, sessionId, publishConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void subscribe(int clientId, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            this.mService.subscribe(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), clientId, subscribeConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, false, callback, clientId), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateSubscribe(int clientId, int sessionId, SubscribeConfig subscribeConfig) {
        try {
            this.mService.updateSubscribe(clientId, sessionId, subscribeConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void terminateSession(int clientId, int sessionId) {
        try {
            this.mService.terminateSession(clientId, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendMessage(int clientId, int sessionId, PeerHandle peerHandle, byte[] message, int messageId, int retryCount) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("sendMessage: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.sendMessage(clientId, sessionId, peerHandle.peerId, message, messageId, retryCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void initiateNanPairingSetupRequest(int clientId, int sessionId, PeerHandle peerHandle, String password, String pairingDeviceAlias, int cipherSuite) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("initiateNanPairingRequest: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.initiateNanPairingSetupRequest(clientId, sessionId, peerHandle.peerId, password, pairingDeviceAlias, cipherSuite);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void responseNanPairingSetupRequest(int clientId, int sessionId, PeerHandle peerHandle, int requestId, String password, String pairingDeviceAlias, boolean accept, int cipherSuite) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("initiateNanPairingRequest: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.responseNanPairingSetupRequest(clientId, sessionId, peerHandle.peerId, requestId, password, pairingDeviceAlias, accept, cipherSuite);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void initiateBootStrappingSetupRequest(int clientId, int sessionId, PeerHandle peerHandle, int method) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("initiateBootStrappingSetupRequest: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.initiateBootStrappingSetupRequest(clientId, sessionId, peerHandle.peerId, method);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void requestMacAddresses(int uid, int[] peerIds, IWifiAwareMacAddressProvider callback) {
        try {
            this.mService.requestMacAddresses(uid, peerIds, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NetworkSpecifier createNetworkSpecifier(int clientId, int role, int sessionId, @NonNull PeerHandle peerHandle, @Nullable byte[] pmk, @Nullable String passphrase) {
        if (!WifiAwareUtils.isLegacyVersion(this.mContext, 29)) {
            throw new UnsupportedOperationException("API deprecated - use WifiAwareNetworkSpecifier.Builder");
        }
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (!(role != 0 && WifiAwareUtils.isLegacyVersion(this.mContext, 28) || peerHandle != null)) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer handle - cannot be null");
        }
        return new WifiAwareNetworkSpecifier(peerHandle == null ? 1 : 0, role, clientId, sessionId, peerHandle != null ? peerHandle.peerId : 0, null, pmk, passphrase, 0, -1);
    }

    public NetworkSpecifier createNetworkSpecifier(int clientId, int role, @NonNull byte[] peer, @Nullable byte[] pmk, @Nullable String passphrase) {
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (!(role != 0 && WifiAwareUtils.isLegacyVersion(this.mContext, 28) || peer != null)) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC - cannot be null");
        }
        if (peer != null && peer.length != 6) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC address");
        }
        return new WifiAwareNetworkSpecifier(peer == null ? 3 : 2, role, clientId, 0, 0, peer, pmk, passphrase, 0, -1);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.OVERRIDE_WIFI_CONFIG", "android.permission.CHANGE_WIFI_STATE"})
    public void setAwareParams(@Nullable AwareParams params) {
        try {
            this.mService.setAwareParams(params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public void setOpportunisticModeEnabled(boolean enabled) {
        try {
            this.mService.setOpportunisticModeEnabled(this.mContext.getOpPackageName(), enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void isOpportunisticModeEnabled(final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.isOpportunisticModeEnabled(this.mContext.getOpPackageName(), new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public void resetPairedDevices() {
        try {
            this.mService.resetPairedDevices(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public void removePairedDevice(@NonNull String alias) {
        try {
            this.mService.removePairedDevice(this.mContext.getOpPackageName(), alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void getPairedDevices(final @NonNull Executor executor, final @NonNull Consumer<List<String>> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getPairedDevices(this.mContext.getOpPackageName(), new IListListener.Stub(this){

                @Override
                public void onResult(List value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void suspend(int clientId, int sessionId) {
        try {
            this.mService.suspend(clientId, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resume(int clientId, int sessionId) {
        try {
            this.mService.resume(clientId, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void attachOffload(@NonNull Executor executor, @NonNull AttachCallback attachCallback) {
        if (executor == null) {
            throw new IllegalArgumentException("Null executor provided");
        }
        this.attach(null, null, attachCallback, null, true, executor);
    }

    private static class WifiAwareEventCallbackProxy
    extends IWifiAwareEventCallback.Stub {
        private final WeakReference<WifiAwareManager> mAwareManager;
        private final Binder mBinder;
        private final Executor mExecutor;
        private final AttachCallback mAttachCallback;
        private final IdentityChangedListener mIdentityChangedListener;

        WifiAwareEventCallbackProxy(WifiAwareManager mgr, Executor executor, Binder binder, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mExecutor = executor;
            this.mBinder = binder;
            this.mAttachCallback = attachCallback;
            this.mIdentityChangedListener = identityChangedListener;
        }

        @Override
        public void onConnectSuccess(int clientId) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
                if (mgr == null) {
                    Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                    return;
                }
                this.mAttachCallback.onAttached(new WifiAwareSession(mgr, this.mBinder, clientId));
            });
        }

        @Override
        public void onConnectFail(int reason) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
                if (mgr == null) {
                    Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                    return;
                }
                this.mAwareManager.clear();
                this.mAttachCallback.onAttachFailed();
            });
        }

        @Override
        public void onIdentityChanged(byte[] mac) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
                if (mgr == null) {
                    Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                    return;
                }
                if (this.mIdentityChangedListener == null) {
                    Log.e(WifiAwareManager.TAG, "CALLBACK_IDENTITY_CHANGED: null listener.");
                } else {
                    this.mIdentityChangedListener.onIdentityChanged(mac);
                }
            });
        }

        @Override
        public void onAttachTerminate() {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
                if (mgr == null) {
                    Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                    return;
                }
                this.mAwareManager.clear();
                this.mAttachCallback.onAwareSessionTerminated();
            });
        }

        @Override
        public void onClusterIdChanged(int clusterEventType, byte[] clusterId) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
                if (mgr == null) {
                    Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                    return;
                }
                if (this.mIdentityChangedListener == null) {
                    Log.e(WifiAwareManager.TAG, "CALLBACK_CLUSTER_ID_CHANGED: null listener.");
                } else {
                    try {
                        this.mIdentityChangedListener.onClusterIdChanged(clusterEventType, MacAddress.fromBytes(clusterId));
                    }
                    catch (IllegalArgumentException iae) {
                        Log.e(WifiAwareManager.TAG, " Invalid MAC address, " + iae);
                    }
                }
            });
        }
    }

    private static class WifiAwareDiscoverySessionCallbackProxy
    extends IWifiAwareDiscoverySessionCallback.Stub {
        private final WeakReference<WifiAwareManager> mAwareManager;
        private final boolean mIsPublish;
        private final DiscoverySessionCallback mOriginalCallback;
        private final int mClientId;
        private final Handler mHandler;
        private DiscoverySession mSession;

        WifiAwareDiscoverySessionCallbackProxy(WifiAwareManager mgr, Looper looper, boolean isPublish, DiscoverySessionCallback originalCallback, int clientId) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mIsPublish = isPublish;
            this.mOriginalCallback = originalCallback;
            this.mClientId = clientId;
            this.mHandler = new Handler(looper);
        }

        @Override
        public void onSessionStarted(int sessionId) {
            this.mHandler.post(() -> this.onProxySessionStarted(sessionId));
        }

        @Override
        public void onSessionConfigSuccess() {
            this.mHandler.post(this.mOriginalCallback::onSessionConfigUpdated);
        }

        @Override
        public void onSessionConfigFail(int reason) {
            this.mHandler.post(() -> {
                this.mOriginalCallback.onSessionConfigFailed();
                if (this.mSession == null) {
                    this.mAwareManager.clear();
                }
            });
        }

        @Override
        public void onSessionTerminated(int reason) {
            this.mHandler.post(() -> this.onProxySessionTerminated(reason));
        }

        @Override
        public void onSessionSuspendSucceeded() {
            this.mHandler.post(this.mOriginalCallback::onSessionSuspendSucceeded);
        }

        @Override
        public void onSessionSuspendFail(int reason) {
            this.mHandler.post(() -> this.mOriginalCallback.onSessionSuspendFailed(reason));
        }

        @Override
        public void onSessionResumeSucceeded() {
            this.mHandler.post(this.mOriginalCallback::onSessionResumeSucceeded);
        }

        @Override
        public void onSessionResumeFail(int reason) {
            this.mHandler.post(() -> this.mOriginalCallback.onSessionResumeFailed(reason));
        }

        @Override
        public void onMatch(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, @Nullable OuiKeyedData[] vendorData) {
            this.mHandler.post(() -> {
                List<byte[]> matchFilterList = this.getMatchFilterList(matchFilter);
                this.mOriginalCallback.onServiceDiscovered(new PeerHandle(peerId), serviceSpecificInfo, matchFilterList);
                this.mOriginalCallback.onServiceDiscovered(new ServiceDiscoveryInfo(new PeerHandle(peerId), peerCipherSuite, serviceSpecificInfo, matchFilterList, scid, pairingAlias, pairingConfig, vendorData));
            });
        }

        private List<byte[]> getMatchFilterList(byte[] matchFilter) {
            List<byte[]> matchFilterList = null;
            try {
                matchFilterList = new TlvBufferUtils.TlvIterable(0, 1, matchFilter).toList();
            }
            catch (BufferOverflowException e) {
                matchFilterList = Collections.emptyList();
                Log.e(WifiAwareManager.TAG, "onServiceDiscovered: invalid match filter byte array '" + new String(HexEncoding.encode(matchFilter)) + "' - cannot be parsed: e=" + e);
            }
            return matchFilterList;
        }

        @Override
        public void onMatchWithDistance(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int distanceMm, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, @Nullable OuiKeyedData[] vendorData) {
            this.mHandler.post(() -> {
                List<byte[]> matchFilterList = this.getMatchFilterList(matchFilter);
                this.mOriginalCallback.onServiceDiscoveredWithinRange(new PeerHandle(peerId), serviceSpecificInfo, matchFilterList, distanceMm);
                this.mOriginalCallback.onServiceDiscoveredWithinRange(new ServiceDiscoveryInfo(new PeerHandle(peerId), peerCipherSuite, serviceSpecificInfo, matchFilterList, scid, pairingAlias, pairingConfig, vendorData), distanceMm);
            });
        }

        @Override
        public void onMatchExpired(int peerId) {
            this.mHandler.post(() -> this.mOriginalCallback.onServiceLost(new PeerHandle(peerId), 1));
        }

        @Override
        public void onMessageSendSuccess(int messageId) {
            this.mHandler.post(() -> this.mOriginalCallback.onMessageSendSucceeded(messageId));
        }

        @Override
        public void onMessageSendFail(int messageId, int reason) {
            this.mHandler.post(() -> this.mOriginalCallback.onMessageSendFailed(messageId));
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) {
            this.mHandler.post(() -> this.mOriginalCallback.onMessageReceived(new PeerHandle(peerId), message));
        }

        @Override
        public void onPairingSetupRequestReceived(int peerId, int requestId) {
            this.mHandler.post(() -> this.mOriginalCallback.onPairingSetupRequestReceived(new PeerHandle(peerId), requestId));
        }

        @Override
        public void onPairingSetupConfirmed(int peerId, boolean accept, String alias) {
            if (accept) {
                this.mHandler.post(() -> this.mOriginalCallback.onPairingSetupSucceeded(new PeerHandle(peerId), alias));
            } else {
                this.mHandler.post(() -> this.mOriginalCallback.onPairingSetupFailed(new PeerHandle(peerId)));
            }
        }

        @Override
        public void onPairingVerificationConfirmed(int peerId, boolean accept, String alias) {
            if (accept) {
                this.mHandler.post(() -> this.mOriginalCallback.onPairingVerificationSucceed(new PeerHandle(peerId), alias));
            } else {
                this.mHandler.post(() -> this.mOriginalCallback.onPairingVerificationFailed(new PeerHandle(peerId)));
            }
        }

        @Override
        public void onBootstrappingVerificationConfirmed(int peerId, boolean accept, int method) {
            if (accept) {
                this.mHandler.post(() -> this.mOriginalCallback.onBootstrappingSucceeded(new PeerHandle(peerId), method));
            } else {
                this.mHandler.post(() -> this.mOriginalCallback.onBootstrappingFailed(new PeerHandle(peerId)));
            }
        }

        @Override
        public void onRangingResultsReceived(List<RangingResult> rangingResults) {
            this.mHandler.post(() -> this.mOriginalCallback.onRangingResultsReceived(rangingResults));
        }

        public void onProxySessionStarted(int sessionId) {
            if (this.mSession != null) {
                Log.e(WifiAwareManager.TAG, "onSessionStarted: sessionId=" + sessionId + ": session already created!?");
                throw new IllegalStateException("onSessionStarted: sessionId=" + sessionId + ": session already created!?");
            }
            WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
            if (mgr == null) {
                Log.w(WifiAwareManager.TAG, "onProxySessionStarted: mgr GC'd");
                return;
            }
            if (this.mIsPublish) {
                PublishDiscoverySession session = new PublishDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onPublishStarted(session);
            } else {
                SubscribeDiscoverySession session = new SubscribeDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onSubscribeStarted(session);
            }
        }

        public void onProxySessionTerminated(int reason) {
            if (this.mSession != null) {
                this.mSession.setTerminated();
                this.mSession = null;
            } else {
                Log.w(WifiAwareManager.TAG, "Proxy: onSessionTerminated called but mSession is null!?");
            }
            this.mAwareManager.clear();
            this.mOriginalCallback.onSessionTerminated();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstantModeBand {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionResumptionFailedReasonCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionSuspensionFailedReasonCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DiscoveryLostReasonCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataPathRole {
    }
}

