/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class WifiConnectedSessionInfo
implements Parcelable {
    private final int mSessionId;
    private final boolean mIsUserSelected;
    @NonNull
    public static final Parcelable.Creator<WifiConnectedSessionInfo> CREATOR = new Parcelable.Creator<WifiConnectedSessionInfo>(){

        @Override
        public WifiConnectedSessionInfo createFromParcel(Parcel in) {
            return new WifiConnectedSessionInfo(in.readInt(), in.readBoolean());
        }

        public WifiConnectedSessionInfo[] newArray(int size) {
            return new WifiConnectedSessionInfo[size];
        }
    };

    private WifiConnectedSessionInfo(int sessionId, boolean isUserSelected) {
        this.mSessionId = sessionId;
        this.mIsUserSelected = isUserSelected;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSessionId);
        dest.writeBoolean(this.mIsUserSelected);
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public boolean isUserSelected() {
        return this.mIsUserSelected;
    }

    public static class Builder {
        private final int mSessionId;
        private boolean mIsUserSelected = false;

        public Builder(int sessionId) {
            this.mSessionId = sessionId;
        }

        @NonNull
        public Builder setUserSelected(boolean isUserSelected) {
            this.mIsUserSelected = isUserSelected;
            return this;
        }

        @NonNull
        public WifiConnectedSessionInfo build() {
            return new WifiConnectedSessionInfo(this.mSessionId, this.mIsUserSelected);
        }
    }
}

