/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.Objects;

@SystemApi
public class WifiClient
implements Parcelable {
    private static final String TAG = "WifiClient";
    private final MacAddress mMacAddress;
    private final String mApInstanceIdentifier;
    private final int mDisconnectReason;
    @NonNull
    public static final Parcelable.Creator<WifiClient> CREATOR = new Parcelable.Creator<WifiClient>(){

        @Override
        public WifiClient createFromParcel(Parcel in) {
            return new WifiClient(in);
        }

        public WifiClient[] newArray(int size) {
            return new WifiClient[size];
        }
    };

    @NonNull
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    @NonNull
    public String getApInstanceIdentifier() {
        return this.mApInstanceIdentifier;
    }

    @FlaggedApi(value="com.android.wifi.flags.softap_disconnect_reason")
    public int getDisconnectReason() {
        return this.mDisconnectReason;
    }

    private WifiClient(Parcel in) {
        this.mMacAddress = (MacAddress)in.readParcelable(null);
        this.mApInstanceIdentifier = in.readString();
        this.mDisconnectReason = in.readInt();
    }

    public WifiClient(@NonNull MacAddress macAddress, @NonNull String apInstanceIdentifier) {
        this(macAddress, apInstanceIdentifier, 0);
    }

    public WifiClient(@NonNull MacAddress macAddress, @NonNull String apInstanceIdentifier, int disconnectReason) {
        if (macAddress == null) {
            Log.wtf(TAG, "Null MacAddress provided");
            this.mMacAddress = WifiManager.ALL_ZEROS_MAC_ADDRESS;
        } else {
            this.mMacAddress = macAddress;
        }
        this.mApInstanceIdentifier = apInstanceIdentifier;
        this.mDisconnectReason = disconnectReason;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mMacAddress, flags);
        dest.writeString(this.mApInstanceIdentifier);
        dest.writeInt(this.mDisconnectReason);
    }

    @NonNull
    public String toString() {
        return "WifiClient{mMacAddress=" + this.mMacAddress + "mApInstanceIdentifier=" + this.mApInstanceIdentifier + "mDisconnectReason=" + this.mDisconnectReason + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WifiClient)) {
            return false;
        }
        WifiClient client = (WifiClient)o;
        return Objects.equals(this.mMacAddress, client.mMacAddress) && this.mApInstanceIdentifier.equals(client.mApInstanceIdentifier) && this.mDisconnectReason == client.mDisconnectReason;
    }

    public int hashCode() {
        return Objects.hash(this.mMacAddress, this.mApInstanceIdentifier, this.mDisconnectReason);
    }
}

