/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class WifiAvailableChannel
implements Parcelable {
    public static final int OP_MODE_STA = 1;
    public static final int OP_MODE_SAP = 2;
    public static final int OP_MODE_WIFI_DIRECT_CLI = 4;
    public static final int OP_MODE_WIFI_DIRECT_GO = 8;
    public static final int OP_MODE_WIFI_AWARE = 16;
    public static final int OP_MODE_TDLS = 32;
    public static final int FILTER_REGULATORY = 0;
    public static final int FILTER_CELLULAR_COEXISTENCE = 1;
    public static final int FILTER_CONCURRENCY = 2;
    public static final int FILTER_NAN_INSTANT_MODE = 4;
    private int mFrequency;
    private int mOpModes;
    private int mChannelWidth;
    @NonNull
    public static final Parcelable.Creator<WifiAvailableChannel> CREATOR = new Parcelable.Creator<WifiAvailableChannel>(){

        @Override
        public WifiAvailableChannel createFromParcel(@NonNull Parcel in) {
            return new WifiAvailableChannel(in);
        }

        public WifiAvailableChannel[] newArray(int size) {
            return new WifiAvailableChannel[size];
        }
    };

    public WifiAvailableChannel(int freq, int opModes) {
        this(freq, opModes, 0);
    }

    public WifiAvailableChannel(int freq, int opModes, int channelWidth) {
        this.mFrequency = freq;
        this.mOpModes = opModes;
        this.mChannelWidth = channelWidth;
    }

    private WifiAvailableChannel(@NonNull Parcel in) {
        this.readFromParcel(in);
    }

    private void readFromParcel(@NonNull Parcel in) {
        this.mFrequency = in.readInt();
        this.mOpModes = in.readInt();
        this.mChannelWidth = in.readInt();
    }

    public int getFrequencyMhz() {
        return this.mFrequency;
    }

    public int getOperationalModes() {
        return this.mOpModes;
    }

    public static int getUsableFilter() {
        return 3;
    }

    @FlaggedApi(value="com.android.wifi.flags.get_channel_width_api")
    public int getChannelWidth() {
        return this.mChannelWidth;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WifiAvailableChannel that = (WifiAvailableChannel)o;
        return this.mFrequency == that.mFrequency && this.mOpModes == that.mOpModes && this.mChannelWidth == that.mChannelWidth;
    }

    public int hashCode() {
        return Objects.hash(this.mFrequency, this.mOpModes, this.mChannelWidth);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("mFrequency = ").append(this.mFrequency).append(", mChannelWidth = ").append(this.mChannelWidth).append(", mOpModes = ").append(String.format("%x", this.mOpModes));
        return sbuf.toString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mOpModes);
        dest.writeInt(this.mChannelWidth);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Filter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OpMode {
    }
}

