/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.Keep;

public enum SupplicantState implements Parcelable
{
    DISCONNECTED,
    INTERFACE_DISABLED,
    INACTIVE,
    SCANNING,
    AUTHENTICATING,
    ASSOCIATING,
    ASSOCIATED,
    FOUR_WAY_HANDSHAKE,
    GROUP_HANDSHAKE,
    COMPLETED,
    DORMANT,
    UNINITIALIZED,
    INVALID;

    @NonNull
    public static final Parcelable.Creator<SupplicantState> CREATOR;

    public static boolean isValidState(SupplicantState state) {
        return state != UNINITIALIZED && state != INVALID;
    }

    public static boolean isHandshakeState(SupplicantState state) {
        switch (state.ordinal()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    @Keep
    public static boolean isConnecting(SupplicantState state) {
        switch (state.ordinal()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    public static boolean isDriverActive(SupplicantState state) {
        switch (state.ordinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 1: 
            case 11: 
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name());
    }

    static {
        CREATOR = new Parcelable.Creator<SupplicantState>(){

            @Override
            public SupplicantState createFromParcel(Parcel in) {
                return SupplicantState.valueOf(in.readString());
            }

            public SupplicantState[] newArray(int size) {
                return new SupplicantState[size];
            }
        };
    }
}

