/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class SoftApInfo
implements Parcelable {
    public static final int CHANNEL_WIDTH_AUTO = -1;
    public static final int CHANNEL_WIDTH_INVALID = 0;
    public static final int CHANNEL_WIDTH_20MHZ_NOHT = 1;
    public static final int CHANNEL_WIDTH_20MHZ = 2;
    public static final int CHANNEL_WIDTH_40MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ = 4;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 5;
    public static final int CHANNEL_WIDTH_160MHZ = 6;
    public static final int CHANNEL_WIDTH_2160MHZ = 7;
    public static final int CHANNEL_WIDTH_4320MHZ = 8;
    public static final int CHANNEL_WIDTH_6480MHZ = 9;
    public static final int CHANNEL_WIDTH_8640MHZ = 10;
    public static final int CHANNEL_WIDTH_320MHZ = 11;
    private int mFrequency = 0;
    private int mBandwidth = 0;
    @Nullable
    private MacAddress mBssid;
    @Nullable
    private String mApInstanceIdentifier;
    private int mWifiStandard = 0;
    private long mIdleShutdownTimeoutMillis;
    private List<OuiKeyedData> mVendorData = Collections.emptyList();
    @Nullable
    private MacAddress mMldAddress;
    @NonNull
    public static final Parcelable.Creator<SoftApInfo> CREATOR = new Parcelable.Creator<SoftApInfo>(){

        @Override
        public SoftApInfo createFromParcel(Parcel in) {
            SoftApInfo info = new SoftApInfo();
            info.mFrequency = in.readInt();
            info.mBandwidth = in.readInt();
            info.mBssid = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            info.mWifiStandard = in.readInt();
            info.mApInstanceIdentifier = in.readString();
            info.mIdleShutdownTimeoutMillis = in.readLong();
            info.mVendorData = ParcelUtil.readOuiKeyedDataList(in);
            info.mMldAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            return info;
        }

        public SoftApInfo[] newArray(int size) {
            return new SoftApInfo[size];
        }
    };

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int freq) {
        this.mFrequency = freq;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.mBandwidth = bandwidth;
    }

    @RequiresApi(value=31)
    @Nullable
    public MacAddress getBssid() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getBssidInternal();
    }

    @Nullable
    public MacAddress getBssidInternal() {
        return this.mBssid;
    }

    public void setBssid(@Nullable MacAddress bssid) {
        if (bssid != null) {
            Preconditions.checkArgument(!((Object)bssid).equals(WifiManager.ALL_ZEROS_MAC_ADDRESS));
            Preconditions.checkArgument(!((Object)bssid).equals(MacAddress.BROADCAST_ADDRESS));
        }
        this.mBssid = bssid;
    }

    public void setWifiStandard(int wifiStandard) {
        this.mWifiStandard = wifiStandard;
    }

    @RequiresApi(value=31)
    public int getWifiStandard() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getWifiStandardInternal();
    }

    public int getWifiStandardInternal() {
        return this.mWifiStandard;
    }

    public void setApInstanceIdentifier(@NonNull String apInstanceIdentifier) {
        this.mApInstanceIdentifier = apInstanceIdentifier;
    }

    @Nullable
    public String getApInstanceIdentifier() {
        return this.mApInstanceIdentifier;
    }

    public void setAutoShutdownTimeoutMillis(long idleShutdownTimeoutMillis) {
        this.mIdleShutdownTimeoutMillis = idleShutdownTimeoutMillis;
    }

    public long getAutoShutdownTimeoutMillis() {
        return this.mIdleShutdownTimeoutMillis;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void setVendorData(@NonNull List<OuiKeyedData> vendorData) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        if (vendorData == null) {
            throw new IllegalArgumentException("setVendorData received a null value");
        }
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @FlaggedApi(value="com.android.wifi.flags.mlo_sap")
    @Nullable
    public MacAddress getMldAddress() {
        return this.mMldAddress;
    }

    public void setMldAddress(@Nullable MacAddress mldAddress) {
        this.mMldAddress = mldAddress;
    }

    public SoftApInfo(@Nullable SoftApInfo source) {
        if (source != null) {
            this.mFrequency = source.mFrequency;
            this.mBandwidth = source.mBandwidth;
            this.mBssid = source.mBssid;
            this.mWifiStandard = source.mWifiStandard;
            this.mApInstanceIdentifier = source.mApInstanceIdentifier;
            this.mIdleShutdownTimeoutMillis = source.mIdleShutdownTimeoutMillis;
            this.mVendorData = new ArrayList<OuiKeyedData>(source.mVendorData);
            this.mMldAddress = source.mMldAddress;
        }
    }

    public SoftApInfo() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mBandwidth);
        dest.writeParcelable(this.mBssid, flags);
        dest.writeInt(this.mWifiStandard);
        dest.writeString(this.mApInstanceIdentifier);
        dest.writeLong(this.mIdleShutdownTimeoutMillis);
        dest.writeList(this.mVendorData);
        dest.writeParcelable(this.mMldAddress, flags);
    }

    @NonNull
    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("SoftApInfo{");
        sbuf.append("bandwidth= ").append(this.mBandwidth);
        sbuf.append(", frequency= ").append(this.mFrequency);
        if (this.mBssid != null) {
            sbuf.append(",bssid=").append(((Object)this.mBssid).toString());
        }
        sbuf.append(", wifiStandard= ").append(this.mWifiStandard);
        sbuf.append(", mApInstanceIdentifier= ").append(this.mApInstanceIdentifier);
        sbuf.append(", mIdleShutdownTimeoutMillis= ").append(this.mIdleShutdownTimeoutMillis);
        sbuf.append(", mVendorData= ").append(this.mVendorData);
        if (this.mMldAddress != null) {
            sbuf.append(",mMldAddress=").append(((Object)this.mMldAddress).toString());
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApInfo)) {
            return false;
        }
        SoftApInfo softApInfo = (SoftApInfo)o;
        return this.mFrequency == softApInfo.mFrequency && this.mBandwidth == softApInfo.mBandwidth && Objects.equals(this.mBssid, softApInfo.mBssid) && this.mWifiStandard == softApInfo.mWifiStandard && Objects.equals(this.mApInstanceIdentifier, softApInfo.mApInstanceIdentifier) && this.mIdleShutdownTimeoutMillis == softApInfo.mIdleShutdownTimeoutMillis && Objects.equals(this.mVendorData, softApInfo.mVendorData) && Objects.equals(this.mMldAddress, softApInfo.mMldAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mFrequency, this.mBandwidth, this.mBssid, this.mWifiStandard, this.mApInstanceIdentifier, this.mIdleShutdownTimeoutMillis, this.mVendorData, this.mMldAddress);
    }
}

