/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class QosCharacteristics
implements Parcelable {
    private static final String TAG = "QosCharacteristics";
    public static final int MAX_MSDU_SIZE = 1;
    public static final int SERVICE_START_TIME = 2;
    public static final int MEAN_DATA_RATE = 4;
    public static final int BURST_SIZE = 8;
    public static final int MSDU_LIFETIME = 16;
    public static final int MSDU_DELIVERY_INFO = 32;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_95 = 0;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_96 = 1;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_97 = 2;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_98 = 3;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_99 = 5;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_99_9 = 6;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_99_99 = 7;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_99_999 = 8;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int DELIVERY_RATIO_99_9999 = 9;
    private final int mMinServiceIntervalMicros;
    private final int mMaxServiceIntervalMicros;
    private final int mMinDataRateKbps;
    private final int mDelayBoundMicros;
    private final int mOptionalFieldBitmap;
    private final int mMaxMsduSizeOctets;
    private final int mServiceStartTimeMicros;
    private final int mServiceStartTimeLinkId;
    private final int mMeanDataRateKbps;
    private final int mBurstSizeOctets;
    private final int mMsduLifetimeMillis;
    private final int mDeliveryRatio;
    private final int mCountExponent;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public static final Parcelable.Creator<QosCharacteristics> CREATOR = new Parcelable.Creator<QosCharacteristics>(){

        @Override
        public QosCharacteristics createFromParcel(Parcel in) {
            return new QosCharacteristics(in);
        }

        public QosCharacteristics[] newArray(int size) {
            return new QosCharacteristics[size];
        }
    };

    private QosCharacteristics(int minServiceIntervalMicros, int maxServiceIntervalMicros, int minDataRateKbps, int delayBoundMicros, int optionalFieldBitmap, int maxMsduSizeOctets, int serviceStartTimeMicros, int serviceStartTimeLinkId, int meanDataRateKbps, int burstSizeOctets, int msduLifetimeMillis, int deliveryRatio, int countExponent) {
        this.mMinServiceIntervalMicros = minServiceIntervalMicros;
        this.mMaxServiceIntervalMicros = maxServiceIntervalMicros;
        this.mMinDataRateKbps = minDataRateKbps;
        this.mDelayBoundMicros = delayBoundMicros;
        this.mOptionalFieldBitmap = optionalFieldBitmap;
        this.mMaxMsduSizeOctets = maxMsduSizeOctets;
        this.mServiceStartTimeMicros = serviceStartTimeMicros;
        this.mServiceStartTimeLinkId = serviceStartTimeLinkId;
        this.mMeanDataRateKbps = meanDataRateKbps;
        this.mBurstSizeOctets = burstSizeOctets;
        this.mMsduLifetimeMillis = msduLifetimeMillis;
        this.mDeliveryRatio = deliveryRatio;
        this.mCountExponent = countExponent;
    }

    public boolean containsOptionalField(int field) {
        return (this.mOptionalFieldBitmap & field) != 0;
    }

    private static boolean checkSizeInBits(int value, int expectedSizeInBits) {
        int bitmask = (1 << expectedSizeInBits) - 1;
        return (bitmask & value) == value;
    }

    private static boolean checkIntRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public boolean validate() {
        if (this.mMinServiceIntervalMicros <= 0 || this.mMaxServiceIntervalMicros <= 0 || this.mMinDataRateKbps <= 0 || this.mDelayBoundMicros <= 0) {
            Log.e(TAG, "All mandatory fields must be positive integers");
            return false;
        }
        if (this.mMinServiceIntervalMicros > this.mMaxServiceIntervalMicros) {
            Log.e(TAG, "Minimum service interval must be less than or equal to the maximum service interval");
            return false;
        }
        if (this.containsOptionalField(1) && !QosCharacteristics.checkIntRange(this.mMaxMsduSizeOctets, 1, Short.MAX_VALUE)) {
            Log.e(TAG, "Invalid value provided for maxMsduSize");
            return false;
        }
        if (this.containsOptionalField(2) && (this.mServiceStartTimeMicros < 0 || !QosCharacteristics.checkSizeInBits(this.mServiceStartTimeLinkId, 4))) {
            Log.e(TAG, "serviceStartTime information is invalid");
            return false;
        }
        if (this.containsOptionalField(4) && this.mMeanDataRateKbps <= 0) {
            Log.e(TAG, "meanDataRateKbps must be a positive integer");
            return false;
        }
        if (this.containsOptionalField(8) && this.mBurstSizeOctets == 0) {
            Log.e(TAG, "burstSizeOctets must be non-zero");
            return false;
        }
        if (this.containsOptionalField(16) && !QosCharacteristics.checkIntRange(this.mMsduLifetimeMillis, 1, Short.MAX_VALUE)) {
            Log.e(TAG, "Invalid value provided for msduLifetimeMillis");
            return false;
        }
        if (this.containsOptionalField(16) && this.mMsduLifetimeMillis * 1000 < this.mDelayBoundMicros) {
            Log.e(TAG, "MSDU lifetime must be greater than or equal to the delay bound");
            return false;
        }
        if (this.containsOptionalField(32) && !QosCharacteristics.checkIntRange(this.mDeliveryRatio, 0, 9)) {
            Log.e(TAG, "MSDU delivery ratio must be a valid enum value");
            return false;
        }
        if (this.containsOptionalField(32) && !QosCharacteristics.checkIntRange(this.mCountExponent, 0, 15)) {
            Log.e(TAG, "MSDU count exponent must be between 0 and 15 (inclusive)");
            return false;
        }
        return true;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMinServiceIntervalMicros() {
        return this.mMinServiceIntervalMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMaxServiceIntervalMicros() {
        return this.mMaxServiceIntervalMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMinDataRateKbps() {
        return this.mMinDataRateKbps;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getDelayBoundMicros() {
        return this.mDelayBoundMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMaxMsduSizeOctets() {
        if (!this.containsOptionalField(1)) {
            throw new IllegalStateException("maxMsduSize was not provided in the builder");
        }
        return this.mMaxMsduSizeOctets;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getServiceStartTimeMicros() {
        if (!this.containsOptionalField(2)) {
            throw new IllegalStateException("serviceStartTime was not provided in the builder");
        }
        return this.mServiceStartTimeMicros;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getServiceStartTimeLinkId() {
        if (!this.containsOptionalField(2)) {
            throw new IllegalStateException("serviceStartTime was not provided in the builder");
        }
        return this.mServiceStartTimeLinkId;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMeanDataRateKbps() {
        if (!this.containsOptionalField(4)) {
            throw new IllegalStateException("meanDataRate was not provided in the builder");
        }
        return this.mMeanDataRateKbps;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getBurstSizeOctets() {
        if (!this.containsOptionalField(8)) {
            throw new IllegalStateException("burstSize was not provided in the builder");
        }
        return this.mBurstSizeOctets;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getMsduLifetimeMillis() {
        if (!this.containsOptionalField(16)) {
            throw new IllegalStateException("msduLifetime was not provided in the builder");
        }
        return this.mMsduLifetimeMillis;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getDeliveryRatio() {
        if (!this.containsOptionalField(32)) {
            throw new IllegalStateException("msduDeliveryInfo was not provided in the builder");
        }
        return this.mDeliveryRatio;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getCountExponent() {
        if (!this.containsOptionalField(32)) {
            throw new IllegalStateException("msduDeliveryInfo was not provided in the builder");
        }
        return this.mCountExponent;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QosCharacteristics that = (QosCharacteristics)o;
        return this.mMinServiceIntervalMicros == that.mMinServiceIntervalMicros && this.mMaxServiceIntervalMicros == that.mMaxServiceIntervalMicros && this.mMinDataRateKbps == that.mMinDataRateKbps && this.mDelayBoundMicros == that.mDelayBoundMicros && this.mOptionalFieldBitmap == that.mOptionalFieldBitmap && this.mMaxMsduSizeOctets == that.mMaxMsduSizeOctets && this.mServiceStartTimeMicros == that.mServiceStartTimeMicros && this.mServiceStartTimeLinkId == that.mServiceStartTimeLinkId && this.mMeanDataRateKbps == that.mMeanDataRateKbps && this.mBurstSizeOctets == that.mBurstSizeOctets && this.mMsduLifetimeMillis == that.mMsduLifetimeMillis && this.mDeliveryRatio == that.mDeliveryRatio && this.mCountExponent == that.mCountExponent;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int hashCode() {
        return Objects.hash(this.mMinServiceIntervalMicros, this.mMaxServiceIntervalMicros, this.mMinDataRateKbps, this.mDelayBoundMicros, this.mOptionalFieldBitmap, this.mMaxMsduSizeOctets, this.mServiceStartTimeMicros, this.mServiceStartTimeLinkId, this.mMeanDataRateKbps, this.mBurstSizeOctets, this.mMsduLifetimeMillis, this.mDeliveryRatio, this.mCountExponent);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("mMinServiceIntervalMicros=").append(this.mMinServiceIntervalMicros);
        sb.append(", mMaxServiceIntervalMicros=").append(this.mMaxServiceIntervalMicros);
        sb.append(", mMinDataRateKbps=").append(this.mMinDataRateKbps);
        sb.append(", mDelayBoundMicros=").append(this.mDelayBoundMicros);
        sb.append(", mOptionalFieldBitmap=").append(String.format("%02x", this.mOptionalFieldBitmap));
        if (this.containsOptionalField(1)) {
            sb.append(", mMaxMsduSizeOctets=").append(this.mMaxMsduSizeOctets);
        }
        if (this.containsOptionalField(2)) {
            sb.append(", mServiceStartTimeMicros=").append(this.mServiceStartTimeMicros);
            sb.append(", mServiceStartTimeLinkId=");
            sb.append(String.format("%01x", this.mServiceStartTimeLinkId));
        }
        if (this.containsOptionalField(4)) {
            sb.append(", mMeanDataRateKbps=").append(this.mMeanDataRateKbps);
        }
        if (this.containsOptionalField(8)) {
            sb.append(", mBurstSizeOctets=").append(this.mBurstSizeOctets);
        }
        if (this.containsOptionalField(16)) {
            sb.append(", mMsduLifetimeMillis=").append(this.mMsduLifetimeMillis);
        }
        if (this.containsOptionalField(32)) {
            sb.append(", mDeliveryRatio=").append(this.mDeliveryRatio);
            sb.append(", mCountExponent=").append(this.mCountExponent);
        }
        return sb.append("}").toString();
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mMinServiceIntervalMicros);
        dest.writeInt(this.mMaxServiceIntervalMicros);
        dest.writeInt(this.mMinDataRateKbps);
        dest.writeInt(this.mDelayBoundMicros);
        dest.writeInt(this.mOptionalFieldBitmap);
        dest.writeInt(this.mMaxMsduSizeOctets);
        dest.writeInt(this.mServiceStartTimeMicros);
        dest.writeInt(this.mServiceStartTimeLinkId);
        dest.writeInt(this.mMeanDataRateKbps);
        dest.writeInt(this.mBurstSizeOctets);
        dest.writeInt(this.mMsduLifetimeMillis);
        dest.writeInt(this.mDeliveryRatio);
        dest.writeInt(this.mCountExponent);
    }

    QosCharacteristics(@NonNull Parcel in) {
        this.mMinServiceIntervalMicros = in.readInt();
        this.mMaxServiceIntervalMicros = in.readInt();
        this.mMinDataRateKbps = in.readInt();
        this.mDelayBoundMicros = in.readInt();
        this.mOptionalFieldBitmap = in.readInt();
        this.mMaxMsduSizeOctets = in.readInt();
        this.mServiceStartTimeMicros = in.readInt();
        this.mServiceStartTimeLinkId = in.readInt();
        this.mMeanDataRateKbps = in.readInt();
        this.mBurstSizeOctets = in.readInt();
        this.mMsduLifetimeMillis = in.readInt();
        this.mDeliveryRatio = in.readInt();
        this.mCountExponent = in.readInt();
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private final int mMinServiceIntervalMicros;
        private final int mMaxServiceIntervalMicros;
        private final int mMinDataRateKbps;
        private final int mDelayBoundMicros;
        private int mOptionalFieldBitmap;
        private int mMaxMsduSizeOctets;
        private int mServiceStartTimeMicros;
        private int mServiceStartTimeLinkId;
        private int mMeanDataRateKbps;
        private int mBurstSizeOctets;
        private int mMsduLifetimeMillis;
        private int mDeliveryRatio;
        private int mCountExponent;

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public Builder(int minServiceIntervalMicros, int maxServiceIntervalMicros, int minDataRateKbps, int delayBoundMicros) {
            this.mMinServiceIntervalMicros = minServiceIntervalMicros;
            this.mMaxServiceIntervalMicros = maxServiceIntervalMicros;
            this.mMinDataRateKbps = minDataRateKbps;
            this.mDelayBoundMicros = delayBoundMicros;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMaxMsduSizeOctets(int maxMsduSizeOctets) {
            this.mOptionalFieldBitmap |= 1;
            this.mMaxMsduSizeOctets = maxMsduSizeOctets;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setServiceStartTimeInfo(int serviceStartTimeMicros, int serviceStartTimeLinkId) {
            this.mOptionalFieldBitmap |= 2;
            this.mServiceStartTimeMicros = serviceStartTimeMicros;
            this.mServiceStartTimeLinkId = serviceStartTimeLinkId;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMeanDataRateKbps(int meanDataRateKbps) {
            this.mOptionalFieldBitmap |= 4;
            this.mMeanDataRateKbps = meanDataRateKbps;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setBurstSizeOctets(int burstSizeOctets) {
            this.mOptionalFieldBitmap |= 8;
            this.mBurstSizeOctets = burstSizeOctets;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMsduLifetimeMillis(int msduLifetimeMillis) {
            this.mOptionalFieldBitmap |= 0x10;
            this.mMsduLifetimeMillis = msduLifetimeMillis;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMsduDeliveryInfo(int deliveryRatio, int countExponent) {
            this.mOptionalFieldBitmap |= 0x20;
            this.mDeliveryRatio = deliveryRatio;
            this.mCountExponent = countExponent;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public QosCharacteristics build() {
            QosCharacteristics qosCharacteristics = new QosCharacteristics(this.mMinServiceIntervalMicros, this.mMaxServiceIntervalMicros, this.mMinDataRateKbps, this.mDelayBoundMicros, this.mOptionalFieldBitmap, this.mMaxMsduSizeOctets, this.mServiceStartTimeMicros, this.mServiceStartTimeLinkId, this.mMeanDataRateKbps, this.mBurstSizeOctets, this.mMsduLifetimeMillis, this.mDeliveryRatio, this.mCountExponent);
            if (!qosCharacteristics.validate()) {
                throw new IllegalArgumentException("Provided parameters are invalid");
            }
            return qosCharacteristics;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeliveryRatio {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QosCharacteristicsOptionalField {
    }
}

