/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class MloLink
implements Parcelable {
    public static final int INVALID_MLO_LINK_ID = -1;
    public static final int MIN_MLO_LINK_ID = 0;
    public static final int MAX_MLO_LINK_ID = 15;
    public static final int MLO_LINK_STATE_INVALID = 0;
    public static final int MLO_LINK_STATE_UNASSOCIATED = 1;
    public static final int MLO_LINK_STATE_IDLE = 2;
    public static final int MLO_LINK_STATE_ACTIVE = 3;
    private int mLinkId;
    private MacAddress mApMacAddress;
    private MacAddress mStaMacAddress;
    private int mState;
    private int mBand;
    private int mChannel;
    private int mRssi;
    private int mRxLinkSpeed;
    private int mTxLinkSpeed;
    public long txBad;
    public long txRetries;
    public long txSuccess;
    public long rxSuccess;
    public long lastPacketCountUpdateTimeStamp = Long.MIN_VALUE;
    private double mLostTxPacketsPerSecond;
    private double mTxRetriedTxPacketsPerSecond;
    private double mSuccessfulTxPacketsPerSecond;
    private double mSuccessfulRxPacketsPerSecond;
    @NonNull
    public static final Parcelable.Creator<MloLink> CREATOR = new Parcelable.Creator<MloLink>(){

        @Override
        public MloLink createFromParcel(Parcel in) {
            MloLink link = new MloLink();
            link.mBand = in.readInt();
            link.mChannel = in.readInt();
            link.mLinkId = in.readInt();
            link.mState = in.readInt();
            link.mRssi = in.readInt();
            link.mRxLinkSpeed = in.readInt();
            link.mTxLinkSpeed = in.readInt();
            link.mApMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            link.mStaMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            link.mLostTxPacketsPerSecond = in.readDouble();
            link.mSuccessfulTxPacketsPerSecond = in.readDouble();
            link.mSuccessfulRxPacketsPerSecond = in.readDouble();
            link.mTxRetriedTxPacketsPerSecond = in.readDouble();
            link.txBad = in.readLong();
            link.txRetries = in.readLong();
            link.txSuccess = in.readLong();
            link.rxSuccess = in.readLong();
            return link;
        }

        public MloLink[] newArray(int size) {
            return new MloLink[size];
        }
    };

    public MloLink() {
        this.mBand = 0;
        this.mChannel = 0;
        this.mState = 1;
        this.mApMacAddress = null;
        this.mStaMacAddress = null;
        this.mLinkId = -1;
        this.mRssi = -127;
        this.mRxLinkSpeed = -1;
        this.mTxLinkSpeed = -1;
    }

    public MloLink(MloLink source, long redactions) {
        this.mBand = source.mBand;
        this.mChannel = source.mChannel;
        this.mLinkId = source.mLinkId;
        this.mState = source.mState;
        this.mRssi = source.mRssi;
        this.mRxLinkSpeed = source.mRxLinkSpeed;
        this.mTxLinkSpeed = source.mTxLinkSpeed;
        this.mLostTxPacketsPerSecond = source.mLostTxPacketsPerSecond;
        this.mTxRetriedTxPacketsPerSecond = source.mTxRetriedTxPacketsPerSecond;
        this.mSuccessfulRxPacketsPerSecond = source.mSuccessfulRxPacketsPerSecond;
        this.mSuccessfulTxPacketsPerSecond = source.mSuccessfulTxPacketsPerSecond;
        this.txBad = source.txBad;
        this.txRetries = source.txRetries;
        this.txSuccess = source.txSuccess;
        this.rxSuccess = source.rxSuccess;
        this.mStaMacAddress = (redactions & 2L) != 0L || source.mStaMacAddress == null ? null : MacAddress.fromString(((Object)source.mStaMacAddress).toString());
        this.mApMacAddress = (redactions & 1L) != 0L || source.mApMacAddress == null ? null : MacAddress.fromString(((Object)source.mApMacAddress).toString());
    }

    public int getBand() {
        return this.mBand;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getLinkId() {
        return this.mLinkId;
    }

    public int getState() {
        return this.mState;
    }

    @Nullable
    public MacAddress getApMacAddress() {
        return this.mApMacAddress;
    }

    @Nullable
    public MacAddress getStaMacAddress() {
        return this.mStaMacAddress;
    }

    public void setChannel(int channel) {
        this.mChannel = channel;
    }

    public void setBand(int band) {
        this.mBand = band;
    }

    public void setLinkId(int linkId) {
        this.mLinkId = linkId;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public void setApMacAddress(MacAddress address) {
        this.mApMacAddress = address;
    }

    public void setStaMacAddress(MacAddress address) {
        this.mStaMacAddress = address;
    }

    public void setRxLinkSpeedMbps(int rxLinkSpeed) {
        this.mRxLinkSpeed = rxLinkSpeed;
    }

    public int getRxLinkSpeedMbps() {
        return this.mRxLinkSpeed;
    }

    public void setTxLinkSpeedMbps(int txLinkSpeed) {
        this.mTxLinkSpeed = txLinkSpeed;
    }

    public int getTxLinkSpeedMbps() {
        return this.mTxLinkSpeed;
    }

    public void setRssi(int rssi) {
        if (rssi < -127) {
            rssi = -127;
        }
        if (rssi > 200) {
            rssi = 200;
        }
        this.mRssi = rssi;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public double getLostTxPacketsPerSecond() {
        return this.mLostTxPacketsPerSecond;
    }

    public void setLostTxPacketsPerSecond(double lostTxPacketsPerSecond) {
        this.mLostTxPacketsPerSecond = lostTxPacketsPerSecond;
    }

    public double getRetriedTxPacketsPerSecond() {
        return this.mTxRetriedTxPacketsPerSecond;
    }

    public void setRetriedTxPacketsRate(double txRetriedTxPacketsPerSecond) {
        this.mTxRetriedTxPacketsPerSecond = txRetriedTxPacketsPerSecond;
    }

    public double getSuccessfulTxPacketsPerSecond() {
        return this.mSuccessfulTxPacketsPerSecond;
    }

    public void setSuccessfulTxPacketsPerSecond(double successfulTxPacketsPerSecond) {
        this.mSuccessfulTxPacketsPerSecond = successfulTxPacketsPerSecond;
    }

    public double getSuccessfulRxPacketsPerSecond() {
        return this.mSuccessfulRxPacketsPerSecond;
    }

    public void setSuccessfulRxPacketsPerSecond(double successfulRxPacketsPerSecond) {
        this.mSuccessfulRxPacketsPerSecond = successfulRxPacketsPerSecond;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MloLink that = (MloLink)o;
        return this.mBand == that.mBand && this.mChannel == that.mChannel && this.mLinkId == that.mLinkId && Objects.equals(this.mApMacAddress, that.mApMacAddress) && Objects.equals(this.mStaMacAddress, that.mStaMacAddress) && this.mState == that.mState && this.mRssi == that.mRssi && this.mRxLinkSpeed == that.mRxLinkSpeed && this.mTxLinkSpeed == that.mTxLinkSpeed && this.mTxRetriedTxPacketsPerSecond == that.mTxRetriedTxPacketsPerSecond && this.mSuccessfulTxPacketsPerSecond == that.mSuccessfulTxPacketsPerSecond && this.mLostTxPacketsPerSecond == that.mLostTxPacketsPerSecond && this.mSuccessfulRxPacketsPerSecond == that.mSuccessfulRxPacketsPerSecond && this.txBad == that.txBad && this.txRetries == that.txRetries && this.txSuccess == that.txSuccess && this.rxSuccess == that.rxSuccess;
    }

    public int hashCode() {
        return Objects.hash(this.mBand, this.mChannel, this.mLinkId, this.mApMacAddress, this.mStaMacAddress, this.mState, this.mRssi, this.mRxLinkSpeed, this.mTxLinkSpeed, this.mTxRetriedTxPacketsPerSecond, this.mSuccessfulTxPacketsPerSecond, this.mLostTxPacketsPerSecond, this.mSuccessfulRxPacketsPerSecond, this.txBad, this.txRetries, this.txSuccess, this.rxSuccess);
    }

    public static String getStateString(int state) {
        switch (state) {
            case 0: {
                return "MLO_LINK_STATE_INVALID";
            }
            case 1: {
                return "MLO_LINK_STATE_UNASSOCIATED";
            }
            case 2: {
                return "MLO_LINK_STATE_IDLE";
            }
            case 3: {
                return "MLO_LINK_STATE_ACTIVE";
            }
        }
        return "Unknown MLO link state";
    }

    public static boolean isValidState(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MloLink{");
        if (this.mBand == 1) {
            sb.append("2.4GHz");
        } else if (this.mBand == 2) {
            sb.append("5GHz");
        } else if (this.mBand == 8) {
            sb.append("6GHz");
        } else {
            sb.append("UNKNOWN BAND");
        }
        sb.append(", channel: ").append(this.mChannel);
        sb.append(", id: ").append(this.mLinkId);
        sb.append(", state: ").append(MloLink.getStateString(this.mState));
        sb.append(", RSSI: ").append(this.getRssi());
        sb.append(", Rx Link speed: ").append(this.getRxLinkSpeedMbps()).append("Mbps");
        sb.append(", Tx Link speed: ").append(this.getTxLinkSpeedMbps()).append("Mbps");
        if (this.mApMacAddress != null) {
            sb.append(", AP MAC Address: ").append(((Object)this.mApMacAddress).toString());
        }
        if (this.mStaMacAddress != null) {
            sb.append(", STA MAC Address: ").append(((Object)this.mStaMacAddress).toString());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mBand);
        dest.writeInt(this.mChannel);
        dest.writeInt(this.mLinkId);
        dest.writeInt(this.mState);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mRxLinkSpeed);
        dest.writeInt(this.mTxLinkSpeed);
        dest.writeParcelable(this.mApMacAddress, flags);
        dest.writeParcelable(this.mStaMacAddress, flags);
        dest.writeDouble(this.mLostTxPacketsPerSecond);
        dest.writeDouble(this.mSuccessfulTxPacketsPerSecond);
        dest.writeDouble(this.mSuccessfulRxPacketsPerSecond);
        dest.writeDouble(this.mTxRetriedTxPacketsPerSecond);
        dest.writeLong(this.txBad);
        dest.writeLong(this.txRetries);
        dest.writeLong(this.txSuccess);
        dest.writeLong(this.rxSuccess);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MloLinkState {
    }
}

