/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiStateChangedListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiStateChangedListener";

    public void onWifiStateChanged() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiStateChangedListener {
        static final int TRANSACTION_onWifiStateChanged = 1;

        public Stub() {
            this.attachInterface(this, IWifiStateChangedListener.DESCRIPTOR);
        }

        public static IWifiStateChangedListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiStateChangedListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiStateChangedListener) {
                return (IWifiStateChangedListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onWifiStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiStateChangedListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onWifiStateChanged();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWifiStateChangedListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiStateChangedListener.DESCRIPTOR;
            }

            @Override
            public void onWifiStateChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiStateChangedListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiStateChangedListener {
        @Override
        public void onWifiStateChanged() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

