/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiScanner;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;

public interface IWifiScannerListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiScannerListener";

    public void onSuccess() throws RemoteException;

    public void onFailure(int var1, String var2) throws RemoteException;

    public void onResults(WifiScanner.ScanData[] var1) throws RemoteException;

    public void onFullResult(ScanResult var1) throws RemoteException;

    public void onSingleScanCompleted() throws RemoteException;

    public void onPnoNetworkFound(ScanResult[] var1) throws RemoteException;

    public void onFullResults(ParceledListSlice<ScanResult> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiScannerListener {
        static final int TRANSACTION_onSuccess = 1;
        static final int TRANSACTION_onFailure = 2;
        static final int TRANSACTION_onResults = 3;
        static final int TRANSACTION_onFullResult = 4;
        static final int TRANSACTION_onSingleScanCompleted = 5;
        static final int TRANSACTION_onPnoNetworkFound = 6;
        static final int TRANSACTION_onFullResults = 7;

        public Stub() {
            this.attachInterface(this, IWifiScannerListener.DESCRIPTOR);
        }

        public static IWifiScannerListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiScannerListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiScannerListener) {
                return (IWifiScannerListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccess";
                }
                case 2: {
                    return "onFailure";
                }
                case 3: {
                    return "onResults";
                }
                case 4: {
                    return "onFullResult";
                }
                case 5: {
                    return "onSingleScanCompleted";
                }
                case 6: {
                    return "onPnoNetworkFound";
                }
                case 7: {
                    return "onFullResults";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiScannerListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onSuccess();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.onFailure(_arg0, _arg1);
                    break;
                }
                case 3: {
                    WifiScanner.ScanData[] _arg0 = data.createTypedArray(WifiScanner.ScanData.CREATOR);
                    this.onResults(_arg0);
                    break;
                }
                case 4: {
                    ScanResult _arg0 = data.readTypedObject(ScanResult.CREATOR);
                    this.onFullResult(_arg0);
                    break;
                }
                case 5: {
                    this.onSingleScanCompleted();
                    break;
                }
                case 6: {
                    ScanResult[] _arg0 = data.createTypedArray(ScanResult.CREATOR);
                    this.onPnoNetworkFound(_arg0);
                    break;
                }
                case 7: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    this.onFullResults(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IWifiScannerListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiScannerListener.DESCRIPTOR;
            }

            @Override
            public void onSuccess() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(int reason, String description) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeString(description);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResults(WifiScanner.ScanData[] results) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    _data.writeTypedArray(results, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFullResult(ScanResult fullScanResult) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    _data.writeTypedObject(fullScanResult, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSingleScanCompleted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPnoNetworkFound(ScanResult[] results) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    _data.writeTypedArray(results, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFullResults(ParceledListSlice<ScanResult> scanResult) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerListener.DESCRIPTOR);
                    _data.writeTypedObject(scanResult, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiScannerListener {
        @Override
        public void onSuccess() throws RemoteException {
        }

        @Override
        public void onFailure(int reason, String description) throws RemoteException {
        }

        @Override
        public void onResults(WifiScanner.ScanData[] results) throws RemoteException {
        }

        @Override
        public void onFullResult(ScanResult fullScanResult) throws RemoteException {
        }

        @Override
        public void onSingleScanCompleted() throws RemoteException {
        }

        @Override
        public void onPnoNetworkFound(ScanResult[] results) throws RemoteException {
        }

        @Override
        public void onFullResults(ParceledListSlice<ScanResult> scanResult) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

