/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.connectivity.android.util.IndentingPrintWriter;
import android.net.vcn.VcnCellUnderlyingNetworkTemplate;
import android.net.vcn.VcnWifiUnderlyingNetworkTemplate;
import android.os.PersistableBundle;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;

public abstract class VcnUnderlyingNetworkTemplate {
    static final int NETWORK_PRIORITY_TYPE_WIFI = 1;
    static final int NETWORK_PRIORITY_TYPE_CELL = 2;
    public static final int MATCH_ANY = 0;
    public static final int MATCH_REQUIRED = 1;
    public static final int MATCH_FORBIDDEN = 2;
    private static final SparseArray<String> MATCH_CRITERIA_TO_STRING_MAP = new SparseArray();
    private static final String NETWORK_PRIORITY_TYPE_KEY = "mNetworkPriorityType";
    private final int mNetworkPriorityType;
    static final String METERED_MATCH_KEY = "mMeteredMatchCriteria";
    static final int DEFAULT_METERED_MATCH_CRITERIA = 0;
    private final int mMeteredMatchCriteria;
    public static final int DEFAULT_MIN_BANDWIDTH_KBPS = 0;
    static final String MIN_ENTRY_UPSTREAM_BANDWIDTH_KBPS_KEY = "mMinEntryUpstreamBandwidthKbps";
    private final int mMinEntryUpstreamBandwidthKbps;
    static final String MIN_EXIT_UPSTREAM_BANDWIDTH_KBPS_KEY = "mMinExitUpstreamBandwidthKbps";
    private final int mMinExitUpstreamBandwidthKbps;
    static final String MIN_ENTRY_DOWNSTREAM_BANDWIDTH_KBPS_KEY = "mMinEntryDownstreamBandwidthKbps";
    private final int mMinEntryDownstreamBandwidthKbps;
    static final String MIN_EXIT_DOWNSTREAM_BANDWIDTH_KBPS_KEY = "mMinExitDownstreamBandwidthKbps";
    private final int mMinExitDownstreamBandwidthKbps;

    VcnUnderlyingNetworkTemplate(int networkPriorityType, int meteredMatchCriteria, int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps, int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) {
        this.mNetworkPriorityType = networkPriorityType;
        this.mMeteredMatchCriteria = meteredMatchCriteria;
        this.mMinEntryUpstreamBandwidthKbps = minEntryUpstreamBandwidthKbps;
        this.mMinExitUpstreamBandwidthKbps = minExitUpstreamBandwidthKbps;
        this.mMinEntryDownstreamBandwidthKbps = minEntryDownstreamBandwidthKbps;
        this.mMinExitDownstreamBandwidthKbps = minExitDownstreamBandwidthKbps;
    }

    static void validateMatchCriteria(int matchCriteria, String matchingCapability) {
        Preconditions.checkArgument(MATCH_CRITERIA_TO_STRING_MAP.contains(matchCriteria), "Invalid matching criteria: " + matchCriteria + " for " + matchingCapability);
    }

    static void validateMinBandwidthKbps(int minEntryBandwidth, int minExitBandwidth) {
        Preconditions.checkArgument(minEntryBandwidth >= 0, "Invalid minEntryBandwidth, must be >= 0");
        Preconditions.checkArgument(minExitBandwidth >= 0, "Invalid minExitBandwidth, must be >= 0");
        Preconditions.checkArgument(minEntryBandwidth >= minExitBandwidth, "Minimum entry bandwidth must be >= exit bandwidth");
    }

    protected void validate() {
        VcnUnderlyingNetworkTemplate.validateMatchCriteria(this.mMeteredMatchCriteria, METERED_MATCH_KEY);
        VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(this.mMinEntryUpstreamBandwidthKbps, this.mMinExitUpstreamBandwidthKbps);
        VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(this.mMinEntryDownstreamBandwidthKbps, this.mMinExitDownstreamBandwidthKbps);
    }

    @NonNull
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public static VcnUnderlyingNetworkTemplate fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        int networkPriorityType = in.getInt(NETWORK_PRIORITY_TYPE_KEY);
        switch (networkPriorityType) {
            case 1: {
                return VcnWifiUnderlyingNetworkTemplate.fromPersistableBundle(in);
            }
            case 2: {
                return VcnCellUnderlyingNetworkTemplate.fromPersistableBundle(in);
            }
        }
        throw new IllegalArgumentException("Invalid networkPriorityType:" + networkPriorityType);
    }

    @NonNull
    PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putInt(NETWORK_PRIORITY_TYPE_KEY, this.mNetworkPriorityType);
        result.putInt(METERED_MATCH_KEY, this.mMeteredMatchCriteria);
        result.putInt(MIN_ENTRY_UPSTREAM_BANDWIDTH_KBPS_KEY, this.mMinEntryUpstreamBandwidthKbps);
        result.putInt(MIN_EXIT_UPSTREAM_BANDWIDTH_KBPS_KEY, this.mMinExitUpstreamBandwidthKbps);
        result.putInt(MIN_ENTRY_DOWNSTREAM_BANDWIDTH_KBPS_KEY, this.mMinEntryDownstreamBandwidthKbps);
        result.putInt(MIN_EXIT_DOWNSTREAM_BANDWIDTH_KBPS_KEY, this.mMinExitDownstreamBandwidthKbps);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkPriorityType, this.mMeteredMatchCriteria, this.mMinEntryUpstreamBandwidthKbps, this.mMinExitUpstreamBandwidthKbps, this.mMinEntryDownstreamBandwidthKbps, this.mMinExitDownstreamBandwidthKbps);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof VcnUnderlyingNetworkTemplate)) {
            return false;
        }
        VcnUnderlyingNetworkTemplate rhs = (VcnUnderlyingNetworkTemplate)other;
        return this.mNetworkPriorityType == rhs.mNetworkPriorityType && this.mMeteredMatchCriteria == rhs.mMeteredMatchCriteria && this.mMinEntryUpstreamBandwidthKbps == rhs.mMinEntryUpstreamBandwidthKbps && this.mMinExitUpstreamBandwidthKbps == rhs.mMinExitUpstreamBandwidthKbps && this.mMinEntryDownstreamBandwidthKbps == rhs.mMinEntryDownstreamBandwidthKbps && this.mMinExitDownstreamBandwidthKbps == rhs.mMinExitDownstreamBandwidthKbps;
    }

    static String getNameString(SparseArray<String> toStringMap, int key) {
        return toStringMap.get(key, "Invalid value " + key);
    }

    static String getMatchCriteriaString(int matchCriteria) {
        return VcnUnderlyingNetworkTemplate.getNameString(MATCH_CRITERIA_TO_STRING_MAP, matchCriteria);
    }

    abstract void dumpTransportSpecificFields(IndentingPrintWriter var1);

    public void dump(IndentingPrintWriter pw) {
        pw.println(this.getClass().getSimpleName() + ":");
        pw.increaseIndent();
        if (this.mMeteredMatchCriteria != 0) {
            pw.println("mMeteredMatchCriteria: " + VcnUnderlyingNetworkTemplate.getMatchCriteriaString(this.mMeteredMatchCriteria));
        }
        if (this.mMinEntryUpstreamBandwidthKbps != 0) {
            pw.println("mMinEntryUpstreamBandwidthKbps: " + this.mMinEntryUpstreamBandwidthKbps);
        }
        if (this.mMinExitUpstreamBandwidthKbps != 0) {
            pw.println("mMinExitUpstreamBandwidthKbps: " + this.mMinExitUpstreamBandwidthKbps);
        }
        if (this.mMinEntryDownstreamBandwidthKbps != 0) {
            pw.println("mMinEntryDownstreamBandwidthKbps: " + this.mMinEntryDownstreamBandwidthKbps);
        }
        if (this.mMinExitDownstreamBandwidthKbps != 0) {
            pw.println("mMinExitDownstreamBandwidthKbps: " + this.mMinExitDownstreamBandwidthKbps);
        }
        this.dumpTransportSpecificFields(pw);
        pw.decreaseIndent();
    }

    public int getMetered() {
        return this.mMeteredMatchCriteria;
    }

    public int getMinEntryUpstreamBandwidthKbps() {
        return this.mMinEntryUpstreamBandwidthKbps;
    }

    public int getMinExitUpstreamBandwidthKbps() {
        return this.mMinExitUpstreamBandwidthKbps;
    }

    public int getMinEntryDownstreamBandwidthKbps() {
        return this.mMinEntryDownstreamBandwidthKbps;
    }

    public int getMinExitDownstreamBandwidthKbps() {
        return this.mMinExitDownstreamBandwidthKbps;
    }

    public abstract Map<Integer, Integer> getCapabilitiesMatchCriteria();

    static {
        MATCH_CRITERIA_TO_STRING_MAP.put(0, "MATCH_ANY");
        MATCH_CRITERIA_TO_STRING_MAP.put(1, "MATCH_REQUIRED");
        MATCH_CRITERIA_TO_STRING_MAP.put(2, "MATCH_FORBIDDEN");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchCriteria {
    }
}

