/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.connectivity.android.net.thread.IThreadNetworkController;
import android.net.connectivity.android.net.thread.IThreadNetworkManager;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.thread.ThreadNetworkController;
import android.os.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class ThreadNetworkManager {
    public static final String SERVICE_NAME = "thread_network";
    public static final String FEATURE_NAME = "android.hardware.thread_network";
    public static final String PERMISSION_THREAD_NETWORK_PRIVILEGED = "android.permission.THREAD_NETWORK_PRIVILEGED";
    public static final String PERMISSION_THREAD_NETWORK_TESTING = "android.permission.THREAD_NETWORK_TESTING";
    public static final String DISALLOW_THREAD_NETWORK = "no_thread_network";
    @NonNull
    private final Context mContext;
    @NonNull
    private final List<ThreadNetworkController> mUnmodifiableControllerServices;

    public ThreadNetworkManager(@NonNull Context context, @NonNull IThreadNetworkManager managerService) {
        this(context, ThreadNetworkManager.makeControllers(managerService));
    }

    private static List<ThreadNetworkController> makeControllers(@NonNull IThreadNetworkManager managerService) {
        List<IThreadNetworkController> controllerServices;
        Objects.requireNonNull(managerService, "managerService cannot be null");
        try {
            controllerServices = managerService.getAllThreadNetworkControllers();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return Collections.emptyList();
        }
        return CollectionUtils.map(controllerServices, ThreadNetworkController::new);
    }

    private ThreadNetworkManager(@NonNull Context context, @NonNull List<ThreadNetworkController> controllerServices) {
        this.mContext = context;
        this.mUnmodifiableControllerServices = Collections.unmodifiableList(controllerServices);
    }

    @NonNull
    public List<ThreadNetworkController> getAllThreadNetworkControllers() {
        return this.mUnmodifiableControllerServices;
    }
}

