/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.security.net.config.UserCertificateSource;
import com.android.internal.hidden_from_bootclasspath.com.android.org.conscrypt.flags.Flags;
import com.android.org.conscrypt.TrustManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerExtensions {
    private final TrustManagerImpl mDelegate;
    private final X509TrustManager mTrustManager;
    private final Method mCheckServerTrusted;
    private final Method mCheckServerTrustedOcspAndTlsData;
    private final Method mIsSameTrustConfiguration;

    public X509TrustManagerExtensions(X509TrustManager tm) throws IllegalArgumentException {
        if (tm instanceof TrustManagerImpl) {
            this.mDelegate = (TrustManagerImpl)tm;
            this.mTrustManager = null;
            this.mCheckServerTrusted = null;
            this.mCheckServerTrustedOcspAndTlsData = null;
            this.mIsSameTrustConfiguration = null;
            return;
        }
        this.mDelegate = null;
        this.mTrustManager = tm;
        try {
            this.mCheckServerTrusted = tm.getClass().getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Required method checkServerTrusted(X509Certificate[], String, String) missing");
        }
        Method checkServerTrustedOcspAndTlsData = null;
        try {
            checkServerTrustedOcspAndTlsData = tm.getClass().getMethod("checkServerTrusted", X509Certificate[].class, byte[].class, byte[].class, String.class, String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.mCheckServerTrustedOcspAndTlsData = checkServerTrustedOcspAndTlsData;
        Method isSameTrustConfiguration = null;
        try {
            isSameTrustConfiguration = tm.getClass().getMethod("isSameTrustConfiguration", String.class, String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.mIsSameTrustConfiguration = isSameTrustConfiguration;
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] chain, String authType, String host) throws CertificateException {
        if (this.mDelegate != null) {
            return this.mDelegate.checkServerTrusted(chain, authType, host);
        }
        try {
            return (List)this.mCheckServerTrusted.invoke((Object)this.mTrustManager, chain, authType, host);
        }
        catch (IllegalAccessException e) {
            throw new CertificateException("Failed to call checkServerTrusted", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new CertificateException("checkServerTrusted failed", e.getCause());
        }
    }

    @FlaggedApi(value="android.security.certificate_transparency_configuration")
    @NonNull
    public List<X509Certificate> checkServerTrusted(@SuppressLint(value={"ArrayReturn"}) @NonNull X509Certificate[] chain, @Nullable byte[] ocspData, @Nullable byte[] tlsSctData, @NonNull String authType, @NonNull String host) throws CertificateException {
        if (this.mDelegate != null) {
            if (Flags.certificateTransparencyCheckservertrustedApi()) {
                List result = this.mDelegate.checkServerTrusted(chain, ocspData, tlsSctData, authType, host);
                return result == null ? Collections.emptyList() : result;
            }
            throw new IllegalArgumentException("Required method checkServerTrusted(X509Certificate[], byte[], byte[], String, String) not available in TrustManagerImpl");
        }
        if (this.mCheckServerTrustedOcspAndTlsData == null) {
            throw new IllegalArgumentException("Required method checkServerTrusted(X509Certificate[], byte[], byte[], String, String) missing");
        }
        try {
            List result = (List)this.mCheckServerTrustedOcspAndTlsData.invoke((Object)this.mTrustManager, chain, ocspData, tlsSctData, authType, host);
            return result == null ? Collections.emptyList() : result;
        }
        catch (IllegalAccessException e) {
            throw new CertificateException("Failed to call checkServerTrusted", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new CertificateException("checkServerTrusted failed", e.getCause());
        }
    }

    public boolean isUserAddedCertificate(X509Certificate cert) {
        return UserCertificateSource.getInstance().findBySubjectAndPublicKey(cert) != null;
    }

    public boolean isSameTrustConfiguration(String hostname1, String hostname2) {
        if (this.mIsSameTrustConfiguration == null) {
            return true;
        }
        try {
            return (Boolean)this.mIsSameTrustConfiguration.invoke((Object)this.mTrustManager, hostname1, hostname2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to call isSameTrustConfiguration", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("isSameTrustConfiguration failed", e.getCause());
        }
    }
}

