/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.http.ConnectionMigrationOptions;
import android.net.http.CronetEngineWrapper;
import android.net.http.DnsOptions;
import android.net.http.HttpEngine;
import android.net.http.IHttpEngineBuilder;
import android.net.http.QuicOptions;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class CronetEngineBuilderWrapper
extends IHttpEngineBuilder {
    private final List<ExperimentalOptionsPatch> mExperimentalOptionsPatches = new ArrayList<ExperimentalOptionsPatch>();
    private JSONObject mParsedExperimentalOptions = new JSONObject();
    private final ExperimentalCronetEngine.Builder backend;

    public CronetEngineBuilderWrapper(ExperimentalCronetEngine.Builder backend) {
        this.backend = backend;
    }

    @Override
    public String getDefaultUserAgent() {
        return this.backend.getDefaultUserAgent();
    }

    @Override
    public IHttpEngineBuilder setUserAgent(String userAgent) {
        this.backend.setUserAgent(userAgent);
        return this;
    }

    @Override
    public IHttpEngineBuilder setStoragePath(String value) {
        this.backend.setStoragePath(value);
        return this;
    }

    @Override
    public IHttpEngineBuilder setEnableQuic(boolean value) {
        this.backend.enableQuic(value);
        return this;
    }

    @Override
    public IHttpEngineBuilder setEnableHttp2(boolean value) {
        this.backend.enableHttp2(value);
        return this;
    }

    @Override
    public IHttpEngineBuilder setEnableBrotli(boolean value) {
        this.backend.enableBrotli(value);
        return this;
    }

    @Override
    public IHttpEngineBuilder setEnableHttpCache(int cacheMode, long maxSize) {
        this.backend.enableHttpCache(cacheMode, maxSize);
        return this;
    }

    @Override
    public IHttpEngineBuilder addQuicHint(String host, int port, int alternatePort) {
        this.backend.addQuicHint(host, port, alternatePort);
        return this;
    }

    @Override
    public IHttpEngineBuilder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Instant expirationInstant) {
        this.backend.addPublicKeyPins(hostName, (Set)pinsSha256, includeSubdomains, Date.from(expirationInstant));
        return this;
    }

    @Override
    public IHttpEngineBuilder setEnablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
        this.backend.enablePublicKeyPinningBypassForLocalTrustAnchors(value);
        return this;
    }

    private static JSONObject createDefaultIfAbsent(JSONObject jsonObject, String key) {
        JSONObject object = jsonObject.optJSONObject(key);
        if (object == null) {
            object = new JSONObject();
            try {
                jsonObject.put(key, object);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed adding a default object for key [" + key + "]", e);
            }
        }
        return object;
    }

    @Override
    public IHttpEngineBuilder setQuicOptions(@NonNull QuicOptions options) {
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject quicOptions = CronetEngineBuilderWrapper.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (!options.getAllowedQuicHosts().isEmpty()) {
                quicOptions.put("host_whitelist", String.join((CharSequence)",", options.getAllowedQuicHosts()));
            }
            if (options.hasInMemoryServerConfigsCacheSize()) {
                quicOptions.put("max_server_configs_stored_in_properties", options.getInMemoryServerConfigsCacheSize());
            }
            if (options.getHandshakeUserAgent() != null) {
                quicOptions.put("user_agent_id", options.getHandshakeUserAgent());
            }
            if (options.getIdleConnectionTimeout() != null) {
                quicOptions.put("idle_connection_timeout_seconds", options.getIdleConnectionTimeout().toSeconds());
            }
        });
        return this;
    }

    @Override
    public IHttpEngineBuilder setDnsOptions(@NonNull DnsOptions options) {
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject asyncDnsOptions = CronetEngineBuilderWrapper.createDefaultIfAbsent(experimentalOptions, "AsyncDNS");
            if (options.getUseHttpStackDnsResolver() != 0) {
                asyncDnsOptions.put("enable", options.getUseHttpStackDnsResolver() == 1);
            }
            JSONObject staleDnsOptions = CronetEngineBuilderWrapper.createDefaultIfAbsent(experimentalOptions, "StaleDNS");
            if (options.getStaleDns() != 0) {
                staleDnsOptions.put("enable", options.getStaleDns() == 1);
            }
            if (options.getPersistHostCache() != 0) {
                staleDnsOptions.put("persist_to_disk", options.getPersistHostCache() == 1);
            }
            if (options.getPersistHostCachePeriod() != null) {
                staleDnsOptions.put("persist_delay_ms", options.getPersistHostCachePeriod().toMillis());
            }
            if (options.getStaleDnsOptions() != null) {
                DnsOptions.StaleDnsOptions staleDnsOptionsJava = options.getStaleDnsOptions();
                if (staleDnsOptionsJava.getAllowCrossNetworkUsage() != 0) {
                    staleDnsOptions.put("allow_other_network", staleDnsOptionsJava.getAllowCrossNetworkUsage() == 1);
                }
                if (staleDnsOptionsJava.getFreshLookupTimeout() != null) {
                    staleDnsOptions.put("delay_ms", staleDnsOptionsJava.getFreshLookupTimeout().toMillis());
                }
                if (staleDnsOptionsJava.getUseStaleOnNameNotResolved() != 0) {
                    staleDnsOptions.put("use_stale_on_name_not_resolved", staleDnsOptionsJava.getUseStaleOnNameNotResolved() == 1);
                }
                if (staleDnsOptionsJava.getMaxExpiredDelay() != null) {
                    staleDnsOptions.put("max_expired_time_ms", staleDnsOptionsJava.getMaxExpiredDelay().toMillis());
                }
            }
            JSONObject quicOptions = CronetEngineBuilderWrapper.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (options.getPreestablishConnectionsToStaleDnsResults() != 0) {
                quicOptions.put("race_stale_dns_on_connection", options.getPreestablishConnectionsToStaleDnsResults() == 1);
            }
        });
        return this;
    }

    @Override
    public IHttpEngineBuilder setConnectionMigrationOptions(@NonNull ConnectionMigrationOptions options) {
        this.mExperimentalOptionsPatches.add(experimentalOptions -> {
            JSONObject quicOptions = CronetEngineBuilderWrapper.createDefaultIfAbsent(experimentalOptions, "QUIC");
            if (options.getDefaultNetworkMigration() != 0) {
                quicOptions.put("migrate_sessions_on_network_change_v2", options.getDefaultNetworkMigration() == 1);
            }
            if (options.getPathDegradationMigration() != 0) {
                boolean pathDegradationValue = options.getPathDegradationMigration() == 1;
                boolean skipPortMigrationFlag = false;
                if (options.getAllowNonDefaultNetworkUsage() != 0) {
                    boolean nonDefaultNetworkValue;
                    boolean bl = nonDefaultNetworkValue = options.getAllowNonDefaultNetworkUsage() == 1;
                    if (!pathDegradationValue && nonDefaultNetworkValue) {
                        throw new IllegalArgumentException("Unable to turn on non-default network usage without path degradation migration!");
                    }
                    if (pathDegradationValue && nonDefaultNetworkValue) {
                        quicOptions.put("migrate_sessions_early_v2", true);
                        skipPortMigrationFlag = true;
                    } else {
                        quicOptions.put("migrate_sessions_early_v2", false);
                    }
                }
                if (!skipPortMigrationFlag) {
                    quicOptions.put("allow_port_migration", pathDegradationValue);
                }
            }
        });
        return this;
    }

    @Override
    public HttpEngine build() {
        for (ExperimentalOptionsPatch patch : this.mExperimentalOptionsPatches) {
            try {
                patch.applyTo(this.mParsedExperimentalOptions);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to apply JSON patch!", e);
            }
        }
        this.backend.setExperimentalOptions(((Object)this.mParsedExperimentalOptions).toString());
        return new CronetEngineWrapper(this.backend.build());
    }

    @FunctionalInterface
    private static interface ExperimentalOptionsPatch {
        public void applyTo(JSONObject var1) throws JSONException;
    }
}

