/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.urlconnection;

import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.UploadDataProvider;
import android.net.connectivity.org.chromium.net.UploadDataSink;
import android.net.connectivity.org.chromium.net.urlconnection.CronetHttpURLConnection;
import android.net.connectivity.org.chromium.net.urlconnection.CronetOutputStream;
import android.net.connectivity.org.chromium.net.urlconnection.MessageLoop;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.Objects;

class CronetFixedModeOutputStream
extends CronetOutputStream {
    @VisibleForTesting
    private static int sDefaultBufferLength = 16384;
    private final MessageLoop mMessageLoop;
    private final long mContentLength;
    private final ByteBuffer mBuffer;
    private final UploadDataProvider mUploadDataProvider = new UploadDataProviderImpl();
    private long mBytesWritten;

    CronetFixedModeOutputStream(CronetHttpURLConnection connection, long contentLength, MessageLoop messageLoop) {
        Objects.requireNonNull(connection);
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be larger than 0 for non-chunked upload.");
        }
        this.mContentLength = contentLength;
        int bufferSize = (int)Math.min(this.mContentLength, (long)sDefaultBufferLength);
        this.mBuffer = ByteBuffer.allocate(bufferSize);
        this.mMessageLoop = messageLoop;
        this.mBytesWritten = 0L;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.checkNotClosed();
        this.checkNotExceedContentLength(1);
        this.ensureBufferHasRemaining();
        this.mBuffer.put((byte)oneByte);
        ++this.mBytesWritten;
        this.uploadIfComplete();
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        int sent;
        this.checkNotClosed();
        if (buffer.length - offset < count || offset < 0 || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.checkNotExceedContentLength(count);
        for (int toSend = count; toSend > 0; toSend -= sent) {
            this.ensureBufferHasRemaining();
            sent = Math.min(toSend, this.mBuffer.remaining());
            this.mBuffer.put(buffer, offset + count - toSend, sent);
        }
        this.mBytesWritten += (long)count;
        this.uploadIfComplete();
    }

    private void ensureBufferHasRemaining() throws IOException {
        if (!this.mBuffer.hasRemaining()) {
            this.uploadBufferInternal();
        }
    }

    private void uploadIfComplete() throws IOException {
        if (this.mBytesWritten == this.mContentLength) {
            this.uploadBufferInternal();
        }
    }

    private void uploadBufferInternal() throws IOException {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetFixedModeOutputStream#uploadBufferInternal");){
            this.checkNotClosed();
            this.mBuffer.flip();
            this.mMessageLoop.loop();
            this.checkNoException();
        }
    }

    private void checkNotExceedContentLength(int numBytes) throws ProtocolException {
        if (this.mBytesWritten + (long)numBytes > this.mContentLength) {
            throw new ProtocolException("expected " + (this.mContentLength - this.mBytesWritten) + " bytes but received " + numBytes);
        }
    }

    @Override
    boolean connectRequested() throws IOException {
        return true;
    }

    @Override
    void checkReceivedEnoughContent() throws IOException {
        if (this.mBytesWritten < this.mContentLength) {
            throw new ProtocolException("Content received is less than Content-Length.");
        }
    }

    @Override
    UploadDataProvider getUploadDataProvider() {
        return this.mUploadDataProvider;
    }

    static void setDefaultBufferLengthForTesting(int length) {
        sDefaultBufferLength = length;
    }

    private class UploadDataProviderImpl
    extends UploadDataProvider {
        private UploadDataProviderImpl() {
        }

        @Override
        public long getLength() {
            return CronetFixedModeOutputStream.this.mContentLength;
        }

        @Override
        public void read(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetFixedModeOutputStream.UploadDataProviderImpl#read");){
                if (byteBuffer.remaining() >= CronetFixedModeOutputStream.this.mBuffer.remaining()) {
                    byteBuffer.put(CronetFixedModeOutputStream.this.mBuffer);
                    CronetFixedModeOutputStream.this.mBuffer.clear();
                    uploadDataSink.onReadSucceeded(false);
                    CronetFixedModeOutputStream.this.mMessageLoop.quit();
                } else {
                    int oldLimit = CronetFixedModeOutputStream.this.mBuffer.limit();
                    CronetFixedModeOutputStream.this.mBuffer.limit(CronetFixedModeOutputStream.this.mBuffer.position() + byteBuffer.remaining());
                    byteBuffer.put(CronetFixedModeOutputStream.this.mBuffer);
                    CronetFixedModeOutputStream.this.mBuffer.limit(oldLimit);
                    uploadDataSink.onReadSucceeded(false);
                }
            }
        }

        @Override
        public void rewind(UploadDataSink uploadDataSink) {
            uploadDataSink.onRewindError(new HttpRetryException("Cannot retry streamed Http body", -1));
        }
    }
}

