/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.telemetry;

import android.os.SystemClock;

public class RateLimiter {
    private static final long ONE_SECOND_MILLIS = 1000L;
    private final Object mLock = new Object();
    private final int mSamplesPerSeconds;
    private int mSamplesLoggedDuringSecond;
    private long mLastPermitMillis = Long.MIN_VALUE;

    public RateLimiter(int samplesPerSeconds) {
        if (samplesPerSeconds <= 0) {
            throw new IllegalArgumentException("Expect sample rate to be > 0 sample(s) per second");
        }
        this.mSamplesPerSeconds = samplesPerSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire() {
        Object object = this.mLock;
        synchronized (object) {
            long currentMillis = SystemClock.elapsedRealtime();
            if (this.mLastPermitMillis + 1000L <= currentMillis) {
                this.mSamplesLoggedDuringSecond = 1;
                this.mLastPermitMillis = currentMillis;
                return true;
            }
            if (this.mSamplesLoggedDuringSecond < this.mSamplesPerSeconds) {
                ++this.mSamplesLoggedDuringSecond;
                return true;
            }
            return false;
        }
    }
}

