/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CronetRequestCommon {
    private CronetRequestCommon() {
    }

    public static CronetLogger.CronetTrafficInfo.RequestTerminalState finishedReasonToCronetTrafficInfoRequestTerminalState(int finishedReason) {
        switch (finishedReason) {
            case 0: {
                return CronetLogger.CronetTrafficInfo.RequestTerminalState.SUCCEEDED;
            }
            case 1: {
                return CronetLogger.CronetTrafficInfo.RequestTerminalState.ERROR;
            }
            case 2: {
                return CronetLogger.CronetTrafficInfo.RequestTerminalState.CANCELLED;
            }
        }
        throw new IllegalArgumentException("Invalid finished reason while producing request terminal state: " + finishedReason);
    }

    public static long estimateHeadersSizeInBytes(Map<String, List<String>> headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if (entry.getValue() == null) continue;
            for (String content : entry.getValue()) {
                responseHeaderSizeInBytes += (long)content.length();
            }
        }
        return responseHeaderSizeInBytes;
    }

    public static long estimateHeadersSizeInBytes(Collection<Map.Entry<String, String>> headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry<String, String> entry : headers) {
            String value;
            String key = entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if ((value = entry.getValue()) == null) continue;
            responseHeaderSizeInBytes += (long)entry.getValue().length();
        }
        return responseHeaderSizeInBytes;
    }

    public static long estimateHeadersSizeInBytes(String[] headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (String entry : headers) {
            if (entry == null) continue;
            responseHeaderSizeInBytes += (long)entry.length();
        }
        return responseHeaderSizeInBytes;
    }
}

