/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.content.Context;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.ApiVersion;
import android.net.connectivity.org.chromium.net.BidirectionalStream;
import android.net.connectivity.org.chromium.net.ConnectionMigrationOptions;
import android.net.connectivity.org.chromium.net.CronetProvider;
import android.net.connectivity.org.chromium.net.DnsOptions;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.connectivity.org.chromium.net.ExperimentalOptionsTranslator;
import android.net.connectivity.org.chromium.net.ICronetEngineBuilder;
import android.net.connectivity.org.chromium.net.NetworkQualityRttListener;
import android.net.connectivity.org.chromium.net.NetworkQualityThroughputListener;
import android.net.connectivity.org.chromium.net.QuicOptions;
import android.net.connectivity.org.chromium.net.RequestFinishedInfo;
import android.net.connectivity.org.chromium.net.UrlRequest;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.impl.CronetLoggerFactory;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.json.JSONObject;

public abstract class CronetEngine {
    private static final String TAG = CronetEngine.class.getSimpleName();
    public static final int ACTIVE_REQUEST_COUNT_UNKNOWN = -1;
    public static final int CONNECTION_METRIC_UNKNOWN = -1;
    public static final int EFFECTIVE_CONNECTION_TYPE_UNKNOWN = 0;
    public static final int EFFECTIVE_CONNECTION_TYPE_OFFLINE = 1;
    public static final int EFFECTIVE_CONNECTION_TYPE_SLOW_2G = 2;
    public static final int EFFECTIVE_CONNECTION_TYPE_2G = 3;
    public static final int EFFECTIVE_CONNECTION_TYPE_3G = 4;
    public static final int EFFECTIVE_CONNECTION_TYPE_4G = 5;
    public static final long UNBIND_NETWORK_HANDLE = -1L;

    public abstract String getVersionString();

    public abstract void shutdown();

    public abstract void startNetLogToFile(String var1, boolean var2);

    public abstract void stopNetLog();

    public abstract byte[] getGlobalMetricsDeltas();

    public abstract URLConnection openConnection(URL var1) throws IOException;

    public abstract URLStreamHandlerFactory createURLStreamHandlerFactory();

    public abstract UrlRequest.Builder newUrlRequestBuilder(String var1, UrlRequest.Callback var2, Executor var3);

    public BidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getActiveRequestCount() {
        return -1;
    }

    public void addRequestFinishedListener(RequestFinishedInfo.Listener listener) {
    }

    public void removeRequestFinishedListener(RequestFinishedInfo.Listener listener) {
    }

    public int getHttpRttMs() {
        return -1;
    }

    public int getTransportRttMs() {
        return -1;
    }

    public int getDownstreamThroughputKbps() {
        return -1;
    }

    public void startNetLogToDisk(String dirPath, boolean logAll, int maxSize) {
    }

    public void bindToNetwork(long networkHandle) {
    }

    public int getEffectiveConnectionType() {
        return 0;
    }

    public void configureNetworkQualityEstimatorForTesting(boolean useLocalHostRequests, boolean useSmallerResponses, boolean disableOfflineCheck) {
    }

    public void addRttListener(NetworkQualityRttListener listener) {
    }

    public void removeRttListener(NetworkQualityRttListener listener) {
    }

    public void addThroughputListener(NetworkQualityThroughputListener listener) {
    }

    public void removeThroughputListener(NetworkQualityThroughputListener listener) {
    }

    public static class Builder {
        private static final String TAG = "CronetEngine.Builder";
        protected JSONObject mParsedExperimentalOptions;
        private final List<ExperimentalOptionsTranslator.JsonPatch> mExperimentalOptionsPatches = new ArrayList<ExperimentalOptionsTranslator.JsonPatch>();
        protected final ICronetEngineBuilder mBuilderDelegate;
        public static final int HTTP_CACHE_DISABLED = 0;
        public static final int HTTP_CACHE_IN_MEMORY = 1;
        public static final int HTTP_CACHE_DISK_NO_HTTP = 2;
        public static final int HTTP_CACHE_DISK = 3;

        public Builder(Context context) {
            this(Builder.createBuilderDelegate(context));
        }

        public Builder(ICronetEngineBuilder builderDelegate) {
            this.mBuilderDelegate = builderDelegate;
        }

        public String getDefaultUserAgent() {
            return this.mBuilderDelegate.getDefaultUserAgent();
        }

        public Builder setUserAgent(String userAgent) {
            this.mBuilderDelegate.setUserAgent(userAgent);
            return this;
        }

        public Builder setStoragePath(String value) {
            this.mBuilderDelegate.setStoragePath(value);
            return this;
        }

        public Builder setLibraryLoader(LibraryLoader loader) {
            this.mBuilderDelegate.setLibraryLoader(loader);
            return this;
        }

        public Builder enableQuic(boolean value) {
            this.mBuilderDelegate.enableQuic(value);
            return this;
        }

        public Builder enableHttp2(boolean value) {
            this.mBuilderDelegate.enableHttp2(value);
            return this;
        }

        @Deprecated
        public Builder enableSdch(boolean value) {
            return this;
        }

        public Builder enableBrotli(boolean value) {
            this.mBuilderDelegate.enableBrotli(value);
            return this;
        }

        public Builder enableHttpCache(int cacheMode, long maxSize) {
            this.mBuilderDelegate.enableHttpCache(cacheMode, maxSize);
            return this;
        }

        public Builder addQuicHint(String host, int port, int alternatePort) {
            this.mBuilderDelegate.addQuicHint(host, port, alternatePort);
            return this;
        }

        public Builder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
            this.mBuilderDelegate.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationDate);
            return this;
        }

        public Builder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
            this.mBuilderDelegate.enablePublicKeyPinningBypassForLocalTrustAnchors(value);
            return this;
        }

        public Builder setThreadPriority(int priority) {
            this.mBuilderDelegate.setThreadPriority(priority);
            return this;
        }

        public Builder enableNetworkQualityEstimator(boolean value) {
            this.mBuilderDelegate.enableNetworkQualityEstimator(value);
            return this;
        }

        @QuicOptions.Experimental
        public Builder setQuicOptions(QuicOptions quicOptions) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(3)) {
                this.mBuilderDelegate.setQuicOptions(quicOptions);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> ExperimentalOptionsTranslator.quicOptionsToJson(experimentalOptions, quicOptions));
            return this;
        }

        @QuicOptions.Experimental
        public Builder setQuicOptions(QuicOptions.Builder quicOptionsBuilder) {
            return this.setQuicOptions(quicOptionsBuilder.build());
        }

        @DnsOptions.Experimental
        public Builder setDnsOptions(DnsOptions dnsOptions) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(2)) {
                this.mBuilderDelegate.setDnsOptions(dnsOptions);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> ExperimentalOptionsTranslator.dnsOptionsToJson(experimentalOptions, dnsOptions));
            return this;
        }

        @DnsOptions.Experimental
        public Builder setDnsOptions(DnsOptions.Builder dnsOptions) {
            return this.setDnsOptions(dnsOptions.build());
        }

        @ConnectionMigrationOptions.Experimental
        public Builder setConnectionMigrationOptions(ConnectionMigrationOptions connectionMigrationOptions) {
            if (this.mBuilderDelegate.getSupportedConfigOptions().contains(1)) {
                this.mBuilderDelegate.setConnectionMigrationOptions(connectionMigrationOptions);
                return this;
            }
            this.mExperimentalOptionsPatches.add(experimentalOptions -> ExperimentalOptionsTranslator.connectionMigrationOptionsToJson(experimentalOptions, connectionMigrationOptions));
            return this;
        }

        @ConnectionMigrationOptions.Experimental
        public Builder setConnectionMigrationOptions(ConnectionMigrationOptions.Builder connectionMigrationOptionsBuilder) {
            return this.setConnectionMigrationOptions(connectionMigrationOptionsBuilder.build());
        }

        protected ExperimentalCronetEngine buildExperimental() {
            int implLevel = Builder.getImplApiLevel(this.mBuilderDelegate);
            if (implLevel != -1 && implLevel < this.getMaximumApiLevel()) {
                Log.w(TAG, "The implementation version is lower than the API version. Calls to methods added in API " + (implLevel + 1) + " and newer will likely have no effect.");
            }
            this.maybeSetExperimentalOptions();
            return this.mBuilderDelegate.build();
        }

        private void maybeSetExperimentalOptions() {
            JSONObject experimentalOptions = ExperimentalOptionsTranslator.applyJsonPatches(this.mParsedExperimentalOptions, this.mExperimentalOptionsPatches);
            if (experimentalOptions != null) {
                this.mBuilderDelegate.setExperimentalOptions(((Object)experimentalOptions).toString());
            }
        }

        public CronetEngine build() {
            return this.buildExperimental();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ICronetEngineBuilder createBuilderDelegate(Context context) {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetEngine#createBuilderDelegate");){
                ICronetEngineBuilder iCronetEngineBuilder;
                long startUptimeMillis = SystemClock.uptimeMillis();
                CronetProvider.ProviderInfo providerInfo = Builder.getEnabledCronetProviders(context, new ArrayList<CronetProvider.ProviderInfo>(CronetProvider.getAllProviderInfos(context))).get(0);
                CronetLogger logger = CronetLoggerFactory.createLogger(context, providerInfo.logSource);
                CronetLogger.CronetEngineBuilderInitializedInfo logInfo = new CronetLogger.CronetEngineBuilderInitializedInfo();
                try {
                    ICronetEngineBuilder builderDelegate;
                    String implCronetVersion;
                    logInfo.creationSuccessful = false;
                    logInfo.author = CronetLogger.CronetEngineBuilderInitializedInfo.Author.API;
                    logInfo.source = providerInfo.logSource;
                    logInfo.uid = Process.myUid();
                    logInfo.apiVersion = new CronetLogger.CronetVersion(ApiVersion.getCronetVersion());
                    if (Log.isLoggable(TAG, 3)) {
                        Log.d(TAG, String.format("Using '%s' provider for creating CronetEngine.Builder.", providerInfo.provider));
                    }
                    if ((implCronetVersion = Builder.getImplCronetVersion(builderDelegate = providerInfo.provider.createBuilder().mBuilderDelegate)) != null) {
                        logInfo.implVersion = new CronetLogger.CronetVersion(implCronetVersion);
                    }
                    logInfo.cronetInitializationRef = builderDelegate.getLogCronetInitializationRef();
                    logInfo.creationSuccessful = true;
                    iCronetEngineBuilder = builderDelegate;
                }
                catch (Throwable throwable) {
                    logInfo.engineBuilderCreatedLatencyMillis = (int)(SystemClock.uptimeMillis() - startUptimeMillis);
                    logger.logCronetEngineBuilderInitializedInfo(logInfo);
                    throw throwable;
                }
                logInfo.engineBuilderCreatedLatencyMillis = (int)(SystemClock.uptimeMillis() - startUptimeMillis);
                logger.logCronetEngineBuilderInitializedInfo(logInfo);
                return iCronetEngineBuilder;
            }
        }

        @VisibleForTesting
        static List<CronetProvider.ProviderInfo> getEnabledCronetProviders(Context context, List<CronetProvider.ProviderInfo> providers) {
            if (providers.isEmpty()) {
                throw new RuntimeException("Unable to find any Cronet provider. Have you included all necessary jars?");
            }
            Iterator<CronetProvider.ProviderInfo> i = providers.iterator();
            while (i.hasNext()) {
                CronetProvider.ProviderInfo providerInfo = i.next();
                if (providerInfo.provider.isEnabled()) continue;
                i.remove();
            }
            if (providers.isEmpty()) {
                throw new RuntimeException("All available Cronet providers are disabled. A provider should be enabled before it can be used.");
            }
            Collections.sort(providers, new Comparator<CronetProvider.ProviderInfo>(){

                @Override
                public int compare(CronetProvider.ProviderInfo p1, CronetProvider.ProviderInfo p2) {
                    if ("Fallback-Cronet-Provider".equals(p1.provider.getName())) {
                        return 1;
                    }
                    if ("Fallback-Cronet-Provider".equals(p2.provider.getName())) {
                        return -1;
                    }
                    return -Builder.compareVersions(p1.provider.getVersion(), p2.provider.getVersion());
                }
            });
            return providers;
        }

        @VisibleForTesting
        static int compareVersions(String s1, String s2) {
            if (s1 == null || s2 == null) {
                throw new IllegalArgumentException("The input values cannot be null");
            }
            String[] s1segments = s1.split("\\.");
            String[] s2segments = s2.split("\\.");
            for (int i = 0; i < s1segments.length && i < s2segments.length; ++i) {
                try {
                    int s1segment = Integer.parseInt(s1segments[i]);
                    int s2segment = Integer.parseInt(s2segments[i]);
                    if (s1segment == s2segment) continue;
                    return Integer.signum(s1segment - s2segment);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unable to convert version segments into integers: " + s1segments[i] + " & " + s2segments[i], e);
                }
            }
            return Integer.signum(s1segments.length - s2segments.length);
        }

        private int getMaximumApiLevel() {
            return ApiVersion.getMaximumAvailableApiLevel();
        }

        private static Method getImplVersionMethod(ICronetEngineBuilder builderDelegate, String method) {
            try {
                return builderDelegate.getClass().getClassLoader().loadClass("android.net.connectivity.org.chromium.net.impl.ImplVersion").getMethod(method, new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException exception) {
                return null;
            }
        }

        private static int getImplApiLevel(ICronetEngineBuilder builderDelegate) {
            try {
                Method method = Builder.getImplVersionMethod(builderDelegate, "getApiLevel");
                return method == null ? -1 : (Integer)method.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException exception) {
                throw new RuntimeException("Failed to retrieve Cronet impl API level", exception);
            }
        }

        private static String getImplCronetVersion(ICronetEngineBuilder builderDelegate) {
            try {
                Method method = Builder.getImplVersionMethod(builderDelegate, "getCronetVersion");
                return method == null ? null : (String)method.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException exception) {
                throw new RuntimeException("Failed to retrieve Cronet impl version", exception);
            }
        }

        public static abstract class LibraryLoader {
            public abstract void loadLibrary(String var1);
        }
    }
}

