/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresOptIn;

public class ConnectionMigrationOptions {
    @Nullable
    private final Boolean mEnableDefaultNetworkMigration;
    @Nullable
    private final Boolean mEnablePathDegradationMigration;
    @Nullable
    private final Boolean mAllowServerMigration;
    @Nullable
    private final Boolean mMigrateIdleConnections;
    @Nullable
    private final Long mIdleMigrationPeriodSeconds;
    @Nullable
    private final Boolean mRetryPreHandshakeErrorsOnAlternateNetwork;
    @Nullable
    private final Boolean mAllowNonDefaultNetworkUsage;
    @Nullable
    private final Long mMaxTimeOnNonDefaultNetworkSeconds;
    @Nullable
    private final Integer mMaxWriteErrorEagerMigrationsCount;
    @Nullable
    private final Integer mMaxPathDegradingEagerMigrationsCount;

    @Nullable
    public Boolean getEnableDefaultNetworkMigration() {
        return this.mEnableDefaultNetworkMigration;
    }

    @Nullable
    public Boolean getEnablePathDegradationMigration() {
        return this.mEnablePathDegradationMigration;
    }

    @Nullable
    public Boolean getAllowServerMigration() {
        return this.mAllowServerMigration;
    }

    @Nullable
    public Boolean getMigrateIdleConnections() {
        return this.mMigrateIdleConnections;
    }

    @Nullable
    public Long getIdleMigrationPeriodSeconds() {
        return this.mIdleMigrationPeriodSeconds;
    }

    @Nullable
    public Boolean getRetryPreHandshakeErrorsOnAlternateNetwork() {
        return this.mRetryPreHandshakeErrorsOnAlternateNetwork;
    }

    @Nullable
    public Boolean getAllowNonDefaultNetworkUsage() {
        return this.mAllowNonDefaultNetworkUsage;
    }

    @Nullable
    public Long getMaxTimeOnNonDefaultNetworkSeconds() {
        return this.mMaxTimeOnNonDefaultNetworkSeconds;
    }

    @Nullable
    public Integer getMaxWriteErrorEagerMigrationsCount() {
        return this.mMaxWriteErrorEagerMigrationsCount;
    }

    @Nullable
    public Integer getMaxPathDegradingEagerMigrationsCount() {
        return this.mMaxPathDegradingEagerMigrationsCount;
    }

    private ConnectionMigrationOptions(Builder builder) {
        this.mEnableDefaultNetworkMigration = builder.mEnableDefaultNetworkConnectionMigration;
        this.mEnablePathDegradationMigration = builder.mEnablePathDegradationMigration;
        this.mAllowServerMigration = builder.mAllowServerMigration;
        this.mMigrateIdleConnections = builder.mMigrateIdleConnections;
        this.mIdleMigrationPeriodSeconds = builder.mIdleConnectionMigrationPeriodSeconds;
        this.mRetryPreHandshakeErrorsOnAlternateNetwork = builder.mRetryPreHandshakeErrorsOnAlternateNetwork;
        this.mAllowNonDefaultNetworkUsage = builder.mAllowNonDefaultNetworkUsage;
        this.mMaxTimeOnNonDefaultNetworkSeconds = builder.mMaxTimeOnNonDefaultNetworkSeconds;
        this.mMaxWriteErrorEagerMigrationsCount = builder.mMaxWriteErrorEagerMigrationsCount;
        this.mMaxPathDegradingEagerMigrationsCount = builder.mMaxPathDegradingEagerMigrationsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Boolean mEnableDefaultNetworkConnectionMigration;
        @Nullable
        private Boolean mEnablePathDegradationMigration;
        @Nullable
        private Boolean mAllowServerMigration;
        @Nullable
        private Boolean mMigrateIdleConnections;
        @Nullable
        private Long mIdleConnectionMigrationPeriodSeconds;
        @Nullable
        private Boolean mRetryPreHandshakeErrorsOnAlternateNetwork;
        @Nullable
        private Boolean mAllowNonDefaultNetworkUsage;
        @Nullable
        private Long mMaxTimeOnNonDefaultNetworkSeconds;
        @Nullable
        private Integer mMaxWriteErrorEagerMigrationsCount;
        @Nullable
        private Integer mMaxPathDegradingEagerMigrationsCount;

        private Builder() {
        }

        public Builder enableDefaultNetworkMigration(boolean enableDefaultNetworkConnectionMigration) {
            this.mEnableDefaultNetworkConnectionMigration = enableDefaultNetworkConnectionMigration;
            return this;
        }

        public Builder enablePathDegradationMigration(boolean enable) {
            this.mEnablePathDegradationMigration = enable;
            return this;
        }

        @Experimental
        public Builder allowServerMigration(boolean allowServerMigration) {
            this.mAllowServerMigration = allowServerMigration;
            return this;
        }

        @Experimental
        public Builder migrateIdleConnections(boolean migrateIdleConnections) {
            this.mMigrateIdleConnections = migrateIdleConnections;
            return this;
        }

        @Experimental
        public Builder setIdleConnectionMigrationPeriodSeconds(long idleConnectionMigrationPeriodSeconds) {
            this.mIdleConnectionMigrationPeriodSeconds = idleConnectionMigrationPeriodSeconds;
            return this;
        }

        @Experimental
        public Builder allowNonDefaultNetworkUsage(boolean enable) {
            this.mAllowNonDefaultNetworkUsage = enable;
            return this;
        }

        @Experimental
        public Builder setMaxTimeOnNonDefaultNetworkSeconds(long maxTimeOnNonDefaultNetworkSeconds) {
            this.mMaxTimeOnNonDefaultNetworkSeconds = maxTimeOnNonDefaultNetworkSeconds;
            return this;
        }

        @Experimental
        public Builder setMaxWriteErrorNonDefaultNetworkMigrationsCount(int maxWriteErrorEagerMigrationsCount) {
            this.mMaxWriteErrorEagerMigrationsCount = maxWriteErrorEagerMigrationsCount;
            return this;
        }

        @Experimental
        public Builder setMaxPathDegradingNonDefaultNetworkMigrationsCount(int maxPathDegradingEagerMigrationsCount) {
            this.mMaxPathDegradingEagerMigrationsCount = maxPathDegradingEagerMigrationsCount;
            return this;
        }

        @Experimental
        public Builder retryPreHandshakeErrorsOnNonDefaultNetwork(boolean retryPreHandshakeErrorsOnAlternateNetwork) {
            this.mRetryPreHandshakeErrorsOnAlternateNetwork = retryPreHandshakeErrorsOnAlternateNetwork;
            return this;
        }

        public ConnectionMigrationOptions build() {
            return new ConnectionMigrationOptions(this);
        }
    }

    @RequiresOptIn
    public static @interface Experimental {
    }
}

