/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.task;

import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import android.net.connectivity.org.chromium.base.TraceEvent;
import android.net.connectivity.org.chromium.base.metrics.RecordHistogram;
import android.net.connectivity.org.chromium.base.task.BackgroundOnlyAsyncTask;
import android.net.connectivity.org.chromium.base.task.PostTask;
import android.net.connectivity.org.chromium.base.task.SerialExecutor;
import android.net.connectivity.org.chromium.base.task.TaskRunner;
import android.net.connectivity.org.chromium.build.annotations.DoNotInline;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.os.Binder;
import android.os.Process;
import com.android.layoutlib.androidx.annotation.MainThread;
import com.android.layoutlib.androidx.annotation.WorkerThread;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@NullMarked
public abstract class AsyncTask<Result> {
    private static final String TAG = "AsyncTask";
    private static final String GET_STATUS_UMA_HISTOGRAM = "Android.Jank.AsyncTaskGetOnUiThreadStatus";
    public static final Executor THREAD_POOL_EXECUTOR = r -> PostTask.postTask(1, r);
    public static final Executor SERIAL_EXECUTOR = new SerialExecutor();
    private static final StealRunnableHandler STEAL_RUNNABLE_HANDLER = new StealRunnableHandler();
    private final Callable<Result> mWorker;
    private final NamedFutureTask mFuture;
    private volatile int mStatus = 0;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();
    private int mIterationIdForTesting = PostTask.sTestIterationForTesting;

    public static void takeOverAndroidThreadPool() {
        ThreadPoolExecutor exec = (ThreadPoolExecutor)android.os.AsyncTask.THREAD_POOL_EXECUTOR;
        if (exec.isShutdown()) {
            assert (exec.getRejectedExecutionHandler() == STEAL_RUNNABLE_HANDLER);
            return;
        }
        exec.setRejectedExecutionHandler(STEAL_RUNNABLE_HANDLER);
        exec.shutdown();
    }

    public AsyncTask() {
        this.mWorker = () -> {
            this.mTaskInvoked.set(true);
            Result result = null;
            try {
                result = this.doInBackground();
                Binder.flushPendingCommands();
            }
            catch (Throwable tr) {
                this.mCancelled.set(true);
                throw tr;
            }
            finally {
                this.postResult(result);
            }
            return result;
        };
        this.mFuture = new NamedFutureTask(this.mWorker);
    }

    private void postResultIfNotInvoked(@Nullable Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private void postResult(@Nullable Result result) {
        if (this instanceof BackgroundOnlyAsyncTask) {
            this.mStatus = 2;
        } else if (this.mIterationIdForTesting == PostTask.sTestIterationForTesting) {
            ThreadUtils.postOnUiThread(() -> this.finish(result));
        }
    }

    public int getStatus() {
        return this.mStatus;
    }

    public int getUmaStatus() {
        if (this.mStatus == 1 && !this.mTaskInvoked.get()) {
            return 0;
        }
        return this.mStatus;
    }

    @WorkerThread
    protected abstract Result doInBackground();

    @MainThread
    protected void onPreExecute() {
    }

    @MainThread
    protected abstract void onPostExecute(Result var1);

    @MainThread
    protected void onCancelled(@Nullable Result result) {
        this.onCancelled();
    }

    @MainThread
    protected void onCancelled() {
    }

    public boolean isCancelled() {
        return this.mCancelled.get();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    @DoNotInline
    public Result get() throws InterruptedException, ExecutionException {
        Object r;
        int status = this.getUmaStatus();
        if (status != 2 && ThreadUtils.runningOnUiThread()) {
            RecordHistogram.recordEnumeratedHistogram(GET_STATUS_UMA_HISTOGRAM, status, 3);
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            String caller = "";
            if (stackTrace.length > 1) {
                caller = stackTrace[1].getClassName() + '.' + stackTrace[1].getMethodName() + '.';
            }
            try (TraceEvent e = TraceEvent.scoped(caller + "AsyncTask.get");){
                r = this.mFuture.get();
            }
        } else {
            r = this.mFuture.get();
        }
        return (Result)r;
    }

    @DoNotInline
    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object r;
        int status = this.getUmaStatus();
        if (status != 2 && ThreadUtils.runningOnUiThread()) {
            RecordHistogram.recordEnumeratedHistogram(GET_STATUS_UMA_HISTOGRAM, status, 3);
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            String caller = "";
            if (stackTrace.length > 1) {
                caller = stackTrace[1].getClassName() + '.' + stackTrace[1].getMethodName() + '.';
            }
            try (TraceEvent e = TraceEvent.scoped(caller + "AsyncTask.get");){
                r = this.mFuture.get(timeout, unit);
            }
        } else {
            r = this.mFuture.get(timeout, unit);
        }
        return (Result)r;
    }

    private void executionPreamble() {
        if (this.mStatus != 0) {
            switch (this.mStatus) {
                case 1: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case 2: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = 1;
        this.onPreExecute();
    }

    @MainThread
    public AsyncTask<Result> executeOnExecutor(Executor exec) {
        this.executionPreamble();
        exec.execute(this.mFuture);
        return this;
    }

    @MainThread
    public AsyncTask<Result> executeOnTaskRunner(TaskRunner taskRunner) {
        this.executionPreamble();
        taskRunner.execute(this.mFuture);
        return this;
    }

    @MainThread
    public AsyncTask<Result> executeWithTaskTraits(int taskTraits) {
        this.executionPreamble();
        PostTask.postTask(taskTraits, this.mFuture);
        return this;
    }

    private void finish(@Nullable Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = 2;
    }

    private static class StealRunnableHandler
    implements RejectedExecutionHandler {
        private StealRunnableHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            THREAD_POOL_EXECUTOR.execute(() -> {
                int priority = Process.getThreadPriority(Process.myTid());
                try {
                    r.run();
                }
                finally {
                    Process.setThreadPriority(Process.myTid(), priority);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int PENDING = 0;
        public static final int RUNNING = 1;
        public static final int FINISHED = 2;
        public static final int NUM_ENTRIES = 3;
    }

    class NamedFutureTask
    extends FutureTask<Result> {
        NamedFutureTask(Callable<Result> c) {
            super(c);
        }

        Class getBlamedClass() {
            return AsyncTask.this.getClass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (TraceEvent e = TraceEvent.scoped("AsyncTask.run: " + AsyncTask.this.mFuture.getBlamedClass().getName());){
                super.run();
            }
            finally {
                Thread.interrupted();
            }
        }

        @Override
        protected void done() {
            try {
                AsyncTask.this.postResultIfNotInvoked(this.get());
            }
            catch (InterruptedException e) {
                Log.w(AsyncTask.TAG, ((Object)e).toString());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
            }
            catch (CancellationException e) {
                AsyncTask.this.postResultIfNotInvoked(null);
            }
        }
    }
}

