/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.annotations.AlwaysInline;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import java.util.Locale;

@NullMarked
public class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;

    private Log() {
    }

    private static String formatLog(String messageTemplate, @Nullable Throwable tr, @Nullable Object @Nullable [] params) {
        if (params != null && (tr == null && params.length > 0 || params.length > 1)) {
            messageTemplate = String.format(Locale.US, messageTemplate, params);
        }
        return messageTemplate;
    }

    @AlwaysInline
    public static String normalizeTag(String tag) {
        return "cn_" + tag;
    }

    @AlwaysInline
    public static boolean isLoggable(String tag, int level) {
        return BuildConfig.ENABLE_DEBUG_LOGS || android.util.Log.isLoggable(tag, level);
    }

    public static void v(String tag, String messageTemplate, Object ... args) {
        if (!Log.isLoggable(tag, 2)) {
            return;
        }
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.v(tag, message, tr);
        } else {
            android.util.Log.v(tag, message);
        }
    }

    public static void d(String tag, String messageTemplate, Object ... args) {
        if (!Log.isLoggable(tag, 3)) {
            return;
        }
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.d(tag, message, tr);
        } else {
            android.util.Log.d(tag, message);
        }
    }

    public static void i(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.i(tag, message, tr);
        } else {
            android.util.Log.i(tag, message);
        }
    }

    @AlwaysInline
    public static void i(String tag, String message) {
        android.util.Log.i(Log.normalizeTag(tag), message);
    }

    @AlwaysInline
    public static void i(String tag, String message, Throwable t) {
        android.util.Log.i(Log.normalizeTag(tag), message, t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1), t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2), t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3), t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4), t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5), t);
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6));
    }

    @AlwaysInline
    public static void i(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.i(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6), t);
    }

    public static void w(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.w(tag, message, tr);
        } else {
            android.util.Log.w(tag, message);
        }
    }

    @AlwaysInline
    public static void w(String tag, String message) {
        android.util.Log.w(Log.normalizeTag(tag), message);
    }

    @AlwaysInline
    public static void w(String tag, String message, Throwable t) {
        android.util.Log.w(Log.normalizeTag(tag), message, t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1), t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2), t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3), t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4), t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5), t);
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6));
    }

    @AlwaysInline
    public static void w(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.w(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6), t);
    }

    public static void e(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.e(tag, message, tr);
        } else {
            android.util.Log.e(tag, message);
        }
    }

    @AlwaysInline
    public static void e(String tag, String message) {
        android.util.Log.e(Log.normalizeTag(tag), message);
    }

    @AlwaysInline
    public static void e(String tag, String message, Throwable t) {
        android.util.Log.e(Log.normalizeTag(tag), message, t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1), t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2), t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3), t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4), t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5), t);
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6));
    }

    @AlwaysInline
    public static void e(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.e(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6), t);
    }

    public static void wtf(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.wtf(tag, message, tr);
        } else {
            android.util.Log.wtf(tag, message);
        }
    }

    @AlwaysInline
    public static void wtf(String tag, String message) {
        android.util.Log.wtf(Log.normalizeTag(tag), message);
    }

    @AlwaysInline
    public static void wtf(String tag, String message, Throwable t) {
        android.util.Log.wtf(Log.normalizeTag(tag), message, t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1), t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2), t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3), t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4), t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5), t);
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6));
    }

    @AlwaysInline
    public static void wtf(String tag, String messageTemplate, @Nullable Object param1, @Nullable Object param2, @Nullable Object param3, @Nullable Object param4, @Nullable Object param5, @Nullable Object param6, Throwable t) {
        tag = Log.normalizeTag(tag);
        android.util.Log.wtf(tag, String.format(Locale.US, messageTemplate, param1, param2, param3, param4, param5, param6), t);
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString(tr);
    }

    private static @Nullable Throwable getThrowableToLog(@Nullable Object @Nullable [] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Object lastArg = args[args.length - 1];
        if (!(lastArg instanceof Throwable)) {
            return null;
        }
        return (Throwable)lastArg;
    }
}

