/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import java.util.Optional;

@FunctionalInterface
@NullMarked
public interface Callback<T> {
    public void onResult(T var1);

    default public Runnable bind(T result) {
        return () -> this.onResult(result);
    }

    public static <T> void runNullSafe(@Nullable Callback<T> callback, T object) {
        if (callback != null) {
            callback.onResult(object);
        }
    }

    public static abstract class Helper {
        @CalledByNative(value="Helper")
        static void onObjectResultFromNative(Callback callback, Object result) {
            callback.onResult(result);
        }

        @CalledByNative(value="Helper")
        static void onOptionalStringResultFromNative(Callback<Optional<String>> callback, boolean hasValue, String result) {
            callback.onResult(hasValue ? Optional.of(result) : Optional.empty());
        }

        @CalledByNative(value="Helper")
        static void onBooleanResultFromNative(Callback callback, boolean result) {
            callback.onResult(result);
        }

        @CalledByNative(value="Helper")
        static void onIntResultFromNative(Callback callback, int result) {
            callback.onResult(result);
        }

        @CalledByNative(value="Helper")
        static void onLongResultFromNative(Callback callback, long result) {
            callback.onResult(result);
        }

        @CalledByNative(value="Helper")
        static void onTimeResultFromNative(Callback callback, long result) {
            callback.onResult(result);
        }

        @CalledByNative(value="Helper")
        static void runRunnable(Runnable runnable) {
            runnable.run();
        }
    }
}

