/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.AndroidInfo;
import android.net.connectivity.org.chromium.base.ApkInfo;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.DeviceInfo;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.PackageUtils;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.NativeLibraries;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.NullUnmarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JniType;
import android.os.Process;
import android.os._Original_Build;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Deprecated
@NullMarked
public class BuildInfo {
    private static final String TAG = "BuildInfo";
    public final String hostPackageName;
    public final String hostPackageLabel;
    public final long hostVersionCode;
    public final String packageName;
    public final long versionCode = BuildConfig.VERSION_CODE;
    public final String versionName;
    public final String installerPackageName;
    public final String abiString;
    public final String androidBuildFingerprint;
    public final String resourcesVersion;
    public final boolean isTV;
    public final boolean isAutomotive;
    public final boolean isFoldable;
    public final boolean isDesktop;
    public final int vulkanDeqpLevel;
    @GuardedBy(value="mCertLock")
    private @Nullable String mHostSigningCertSha256;
    private final Object mCertLock = new Object();

    @CalledByNative
    private static @JniType(value="std::string") String lazyGetHostSigningCertSha256() {
        return BuildInfo.getInstance().getHostSigningCertSha256();
    }

    public static void setGmsVersionCodeForTest(@JniType(value="std::string") String gmsVersionCode) {
        DeviceInfo.setGmsVersionCodeForTest(gmsVersionCode);
    }

    public static long packageVersionCode(PackageInfo pi) {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return pi.getLongVersionCode();
        }
        return pi.versionCode;
    }

    public static String getArch() {
        boolean is64Bit = Process.is64Bit();
        if (NativeLibraries.sCpuFamily == 1) {
            return is64Bit ? "arm64" : "arm";
        }
        if (NativeLibraries.sCpuFamily == 3) {
            return is64Bit ? "x86_64" : "x86";
        }
        return "";
    }

    public static void setBrowserPackageInfo(PackageInfo packageInfo) {
        ApkInfo.setBrowserPackageInfo(packageInfo);
    }

    public ApplicationInfo getBrowserApplicationInfo() {
        return ApkInfo.getInstance().getBrowserApplicationInfo();
    }

    public static BuildInfo getInstance() {
        if (BuildConfig.IS_FOR_TEST) {
            return new BuildInfo();
        }
        return Holder.INSTANCE;
    }

    public String getGmsVersionCode() {
        return DeviceInfo.getGmsVersionCode();
    }

    private BuildInfo() {
        this.hostPackageName = ApkInfo.getHostPackageName();
        this.hostPackageLabel = ApkInfo.getHostPackageLabel();
        this.hostVersionCode = ApkInfo.getHostVersionCode();
        this.packageName = ApkInfo.getPackageName();
        this.versionName = ApkInfo.getPackageVersionName();
        this.installerPackageName = ApkInfo.getInstallerPackageName();
        this.abiString = AndroidInfo.getAndroidSupportedAbis();
        this.androidBuildFingerprint = AndroidInfo.getAndroidBuildFingerprint();
        this.resourcesVersion = ApkInfo.getResourcesVersion();
        this.isTV = DeviceInfo.isTV();
        this.isAutomotive = DeviceInfo.isAutomotive();
        this.isFoldable = DeviceInfo.isFoldable();
        this.isDesktop = DeviceInfo.isDesktop();
        this.vulkanDeqpLevel = DeviceInfo.getVulkanDeqpLevel();
    }

    public static boolean isDebugAndroid() {
        return AndroidInfo.isDebugAndroid();
    }

    public static boolean isDebugApp() {
        return ApkInfo.isDebugApp();
    }

    public static boolean isDebugAndroidOrApp() {
        return BuildInfo.isDebugAndroid() || BuildInfo.isDebugApp();
    }

    @Deprecated
    public static boolean targetsAtLeastT() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 33;
    }

    public static boolean targetsAtLeastU() {
        return ApkInfo.targetsAtLeastU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NullUnmarked
    public String getHostSigningCertSha256() {
        Object object = this.mCertLock;
        synchronized (object) {
            if (this.mHostSigningCertSha256 == null) {
                String certificate = "";
                PackageInfo pi = PackageUtils.getPackageInfo(ContextUtils.getApplicationContext().getPackageName(), this.getPackageInfoFlags());
                Signature[] signatures = this.getPackageSignatures(pi);
                if (signatures != null) {
                    try {
                        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                        byte[] digest = messageDigest.digest(signatures[signatures.length - 1].toByteArray());
                        certificate = PackageUtils.byteArrayToHexString(digest);
                    }
                    catch (NoSuchAlgorithmException e) {
                        Log.w(TAG, "Unable to hash host app signature", e);
                    }
                }
                this.mHostSigningCertSha256 = certificate;
            }
            return this.mHostSigningCertSha256;
        }
    }

    private int getPackageInfoFlags() {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return 0x8000000;
        }
        return 64;
    }

    private Signature @Nullable [] getPackageSignatures(PackageInfo pi) {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            if (pi.signingInfo == null) {
                return null;
            }
            return pi.signingInfo.getSigningCertificateHistory();
        }
        return pi.signatures;
    }

    private static class Holder {
        private static final BuildInfo INSTANCE = new BuildInfo();

        private Holder() {
        }
    }
}

