/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.InetAddresses;
import android.net.IpPrefix;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class NetworkStackConstants {
    public static final int ETHER_DST_ADDR_OFFSET = 0;
    public static final int ETHER_SRC_ADDR_OFFSET = 6;
    public static final int ETHER_ADDR_LEN = 6;
    public static final int ETHER_TYPE_OFFSET = 12;
    public static final int ETHER_TYPE_LENGTH = 2;
    public static final int ETHER_TYPE_ARP = 2054;
    public static final int ETHER_TYPE_IPV4 = 2048;
    public static final int ETHER_TYPE_IPV6 = 34525;
    public static final int ETHER_HEADER_LEN = 14;
    public static final int ETHER_MTU = 1500;
    public static final byte[] ETHER_BROADCAST = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final int ARP_PAYLOAD_LEN = 28;
    public static final int ARP_ETHER_IPV4_LEN = 42;
    public static final int ARP_REQUEST = 1;
    public static final int ARP_REPLY = 2;
    public static final int ARP_HWTYPE_RESERVED_LO = 0;
    public static final int ARP_HWTYPE_ETHER = 1;
    public static final int ARP_HWTYPE_RESERVED_HI = 65535;
    public static final int IPV4_CONFLICT_PROBE_NUM = 3;
    public static final int IPV4_CONFLICT_ANNOUNCE_NUM = 2;
    public static final int IPV4_ADDR_BITS = 32;
    public static final int IPV4_MIN_MTU = 68;
    public static final int IPV4_MAX_MTU = 65535;
    public static final int IPV4_HEADER_MIN_LEN = 20;
    public static final int IPV4_IHL_MASK = 15;
    public static final int IPV4_LENGTH_OFFSET = 2;
    public static final int IPV4_FLAGS_OFFSET = 6;
    public static final int IPV4_FRAGMENT_MASK = 8191;
    public static final int IPV4_PROTOCOL_OFFSET = 9;
    public static final int IPV4_CHECKSUM_OFFSET = 10;
    public static final int IPV4_SRC_ADDR_OFFSET = 12;
    public static final int IPV4_DST_ADDR_OFFSET = 16;
    public static final int IPV4_ADDR_LEN = 4;
    public static final int IPV4_FLAG_MF = 8192;
    public static final int IPV4_FLAG_DF = 16384;
    public static final int IPV4_PROTOCOL_IGMP = 2;
    public static final int IPV4_IGMP_MIN_SIZE = 8;
    public static final int IPV4_IGMP_GROUP_RECORD_SIZE = 8;
    public static final int IPV4_IGMP_TYPE_V1_REPORT = 18;
    public static final int IPV4_IGMP_TYPE_V2_JOIN_REPORT = 22;
    public static final int IPV4_IGMP_TYPE_V2_LEAVE_REPORT = 23;
    public static final int IPV4_IGMP_TYPE_V3_REPORT = 34;
    public static final int IPV4_OPTION_TYPE_ROUTER_ALERT = 148;
    public static final int IPV4_OPTION_LEN_ROUTER_ALERT = 4;
    public static final int IP_MTU = 14;
    public static final Inet4Address IPV4_ADDR_ALL = NetworkStackConstants.makeInet4Address((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    public static final Inet4Address IPV4_ADDR_ANY = NetworkStackConstants.makeInet4Address((byte)0, (byte)0, (byte)0, (byte)0);
    public static final Inet6Address IPV6_ADDR_ANY = NetworkStackConstants.makeInet6Address(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final Inet4Address IPV4_ADDR_ALL_HOST_MULTICAST = (Inet4Address)InetAddresses.parseNumericAddress("224.0.0.1");
    public static final IpPrefix CLAT_PREFIX = new IpPrefix("192.0.0.0/29");
    public static final int IPV6_ADDR_LEN = 16;
    public static final int IPV6_HEADER_LEN = 40;
    public static final int IPV6_LEN_OFFSET = 4;
    public static final int IPV6_PROTOCOL_OFFSET = 6;
    public static final int IPV6_SRC_ADDR_OFFSET = 8;
    public static final int IPV6_DST_ADDR_OFFSET = 24;
    public static final int IPV6_FRAGMENT_ID_OFFSET = 4;
    public static final int IPV6_MIN_MTU = 1280;
    public static final int IPV6_FRAGMENT_ID_LEN = 4;
    public static final int IPV6_FRAGMENT_HEADER_LEN = 8;
    public static final int RFC7421_PREFIX_LENGTH = 64;
    public static final int IPV6_MTU = 24;
    public static final Inet6Address IPV6_ADDR_ALL_NODES_MULTICAST = (Inet6Address)InetAddresses.parseNumericAddress("ff02::1");
    public static final Inet6Address IPV6_ADDR_ALL_ROUTERS_MULTICAST = (Inet6Address)InetAddresses.parseNumericAddress("ff02::2");
    public static final Inet6Address IPV6_ADDR_ALL_HOSTS_MULTICAST = (Inet6Address)InetAddresses.parseNumericAddress("ff02::3");
    public static final Inet6Address IPV6_ADDR_NODE_LOCAL_ALL_NODES_MULTICAST = (Inet6Address)InetAddresses.parseNumericAddress("ff01::1");
    public static final int IPPROTO_FRAGMENT = 44;
    public static final int ICMP_CHECKSUM_OFFSET = 2;
    public static final int ICMP_HEADER_LEN = 8;
    public static final int ICMPV6_HEADER_MIN_LEN = 4;
    public static final int ICMPV6_CHECKSUM_OFFSET = 2;
    public static final int ICMPV6_ECHO_REPLY_TYPE = 129;
    public static final int ICMPV6_ECHO_REQUEST_TYPE = 128;
    public static final int ICMPV6_ROUTER_SOLICITATION = 133;
    public static final int ICMPV6_ROUTER_ADVERTISEMENT = 134;
    public static final int ICMPV6_NEIGHBOR_SOLICITATION = 135;
    public static final int ICMPV6_NEIGHBOR_ADVERTISEMENT = 136;
    public static final int ICMPV6_ND_OPTION_MIN_LENGTH = 8;
    public static final int ICMPV6_ND_OPTION_LENGTH_SCALING_FACTOR = 8;
    public static final int ICMPV6_ND_OPTION_SLLA = 1;
    public static final int ICMPV6_ND_OPTION_TLLA = 2;
    public static final int ICMPV6_ND_OPTION_PIO = 3;
    public static final int ICMPV6_ND_OPTION_MTU = 5;
    public static final int ICMPV6_ND_OPTION_RIO = 24;
    public static final int ICMPV6_ND_OPTION_RDNSS = 25;
    public static final int ICMPV6_ND_OPTION_PREF64 = 38;
    public static final int ICMPV6_RS_HEADER_LEN = 8;
    public static final int ICMPV6_RA_HEADER_LEN = 16;
    public static final int ICMPV6_NS_HEADER_LEN = 24;
    public static final int ICMPV6_NA_HEADER_LEN = 24;
    public static final int ICMPV6_ND_OPTION_TLLA_LEN = 8;
    public static final int ICMPV6_ND_OPTION_SLLA_LEN = 8;
    public static final int NEIGHBOR_ADVERTISEMENT_FLAG_ROUTER = Integer.MIN_VALUE;
    public static final int NEIGHBOR_ADVERTISEMENT_FLAG_SOLICITED = 0x40000000;
    public static final int NEIGHBOR_ADVERTISEMENT_FLAG_OVERRIDE = 0x20000000;
    public static final byte ROUTER_ADVERTISEMENT_FLAG_MANAGED_ADDRESS = -128;
    public static final byte ROUTER_ADVERTISEMENT_FLAG_OTHER = 64;
    public static final byte PIO_FLAG_ON_LINK = -128;
    public static final byte PIO_FLAG_AUTONOMOUS = 64;
    public static final byte PIO_FLAG_DHCPV6_PD_PREFERRED = 16;
    public static final int TCP_HEADER_MIN_LEN = 20;
    public static final int TCP_CHECKSUM_OFFSET = 16;
    public static final byte TCPHDR_FIN = 1;
    public static final byte TCPHDR_SYN = 2;
    public static final byte TCPHDR_RST = 4;
    public static final byte TCPHDR_PSH = 8;
    public static final byte TCPHDR_ACK = 16;
    public static final byte TCPHDR_URG = 32;
    public static final int UDP_HEADER_LEN = 8;
    public static final int UDP_SRCPORT_OFFSET = 0;
    public static final int UDP_DSTPORT_OFFSET = 2;
    public static final int UDP_LENGTH_OFFSET = 4;
    public static final int UDP_CHECKSUM_OFFSET = 6;
    public static final int INFINITE_LEASE = -1;
    public static final int DHCP4_CLIENT_PORT = 68;
    public static final int DHCP_MAX_LENGTH = 1500;
    public static final int DHCP_MAX_OPTION_LEN = 255;
    public static final int DHCP6_CLIENT_PORT = 546;
    public static final int DHCP6_SERVER_PORT = 547;
    public static final Inet6Address ALL_DHCP_RELAY_AGENTS_AND_SERVERS = (Inet6Address)InetAddresses.parseNumericAddress("ff02::1:2");
    public static final int DHCP6_OPTION_IA_ADDR = 5;
    public static final int DHCP6_OPTION_IA_PD = 25;
    public static final int DHCP6_OPTION_IAPREFIX = 26;
    public static final short DNS_OVER_TLS_PORT = 853;
    public static final int TYPE_A = 1;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_SRV = 33;
    public static final int VENDOR_SPECIFIC_IE_ID = 221;
    public static final int TAG_SYSTEM_DHCP = -511;
    public static final int TAG_SYSTEM_NEIGHBOR = -510;
    public static final int TAG_SYSTEM_DHCP_SERVER = -509;
    public static final int TAG_SYSTEM_PROBE = -127;
    public static final int TAG_SYSTEM_DNS = -126;
    public static final String TEST_CAPTIVE_PORTAL_HTTPS_URL = "test_captive_portal_https_url";
    public static final String TEST_CAPTIVE_PORTAL_HTTP_URL = "test_captive_portal_http_url";
    public static final String TEST_URL_EXPIRATION_TIME = "test_url_expiration_time";
    public static final List<IpPrefix> IPV4_LOCAL_PREFIXES = List.of(new IpPrefix("169.254.0.0/16"), new IpPrefix("100.64.0.0/10"), new IpPrefix("10.0.0.0/8"), new IpPrefix("172.16.0.0/12"), new IpPrefix("192.168.0.0/16"));
    public static final List<IpPrefix> MULTICAST_AND_BROADCAST_PREFIXES = List.of(new IpPrefix("224.0.0.0/4"), new IpPrefix("ff00::/8"), new IpPrefix("255.255.255.255/32"));

    private static Inet4Address makeInet4Address(byte b1, byte b2, byte b3, byte b4) {
        try {
            return (Inet4Address)InetAddress.getByAddress(new byte[]{b1, b2, b3, b4});
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("addr must be 4 bytes: this should never happen");
        }
    }

    private static Inet6Address makeInet6Address(byte[] bytes) {
        try {
            return (Inet6Address)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("addr must be 16 bytes: this should never happen");
        }
    }

    private NetworkStackConstants() {
        throw new UnsupportedOperationException("This class is not to be instantiated");
    }
}

