/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.RouteInfo;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class NetUtils {
    public static boolean addressTypeMatches(@NonNull InetAddress left, @NonNull InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    @Nullable
    public static RouteInfo selectBestRoute(@Nullable Collection<RouteInfo> routes, @Nullable InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetUtils.addressTypeMatches(route.getDestination().getAddress(), dest) || bestRoute != null && bestRoute.getDestination().getPrefixLength() >= route.getDestination().getPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        if (bestRoute != null && bestRoute.getType() == 1) {
            return bestRoute;
        }
        return null;
    }

    public static InetAddress getNetworkPart(InetAddress address, int prefixLength) {
        byte[] array2 = address.getAddress();
        NetUtils.maskRawAddress(array2, prefixLength);
        InetAddress netPart = null;
        try {
            netPart = InetAddress.getByAddress(array2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getNetworkPart error - " + ((Object)e).toString());
        }
        return netPart;
    }

    public static void maskRawAddress(byte[] array2, int prefixLength) {
        if (prefixLength < 0 || prefixLength > array2.length * 8) {
            throw new RuntimeException("IP address with " + array2.length + " bytes has invalid prefix length " + prefixLength);
        }
        int offset = prefixLength / 8;
        int remainder = prefixLength % 8;
        byte mask = (byte)(255 << 8 - remainder);
        if (offset < array2.length) {
            array2[offset] = (byte)(array2[offset] & mask);
        }
        ++offset;
        while (offset < array2.length) {
            array2[offset] = 0;
            ++offset;
        }
    }
}

