/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.Nullable;
import java.net.Inet6Address;
import java.net.InetAddress;

public class ConnectivityUtils {
    private ConnectivityUtils() {
    }

    public static String addressAndPortToString(InetAddress address, int port) {
        return String.format(address instanceof Inet6Address ? "[%s]:%d" : "%s:%d", address.getHostAddress(), port);
    }

    public static boolean isIPv6ULA(@Nullable InetAddress addr) {
        return addr instanceof Inet6Address && (addr.getAddress()[0] & 0xFE) == 252;
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }
}

