/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.connectivity.com.android.net.module.util.IBpfMap;
import android.net.connectivity.com.android.net.module.util.JniUtil;
import android.net.connectivity.com.android.net.module.util.Struct;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Pair;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@RequiresApi(value=31)
public class BpfMap<K extends Struct, V extends Struct>
implements IBpfMap<K, V> {
    public static final int BPF_F_RDWR = 0;
    public static final int BPF_F_RDONLY = 8;
    public static final int BPF_F_WRONLY = 16;
    public static final int BPF_F_RDWR_EXCLUSIVE = 24;
    public static final int BPF_MAP_TYPE_HASH = 1;
    private static final int BPF_F_NO_PREALLOC = 1;
    private static final int BPF_ANY = 0;
    private static final int BPF_NOEXIST = 1;
    private static final int BPF_EXIST = 2;
    private final ParcelFileDescriptor mMapFd;
    private final Class<K> mKeyClass;
    private final Class<V> mValueClass;
    private final int mKeySize;
    private final int mValueSize;
    private static ConcurrentHashMap<Pair<String, Integer>, ParcelFileDescriptor> sFdCache;

    private static ParcelFileDescriptor checkModeExclusivity(ParcelFileDescriptor fd, int mode) throws ErrnoException {
        if (mode == 24) {
            throw new ErrnoException("cachedBpfFdGet", OsConstants.EBUSY);
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParcelFileDescriptor cachedBpfFdGet(String path, int mode, int keySize, int valueSize) throws ErrnoException, NullPointerException {
        Pair<String, Integer> key = Pair.create(path, mode << 26 ^ (keySize &= 0x3FF) << 16 ^ (valueSize &= 0xFFFF));
        ParcelFileDescriptor fd = sFdCache.get(key);
        if (fd != null) {
            return BpfMap.checkModeExclusivity(fd, mode);
        }
        Class<BpfMap> clazz = BpfMap.class;
        synchronized (BpfMap.class) {
            fd = sFdCache.get(key);
            if (fd != null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return BpfMap.checkModeExclusivity(fd, mode);
            }
            fd = ParcelFileDescriptor.adoptFd(BpfMap.nativeBpfFdGet(path, mode, keySize, valueSize));
            sFdCache.put(key, fd);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return fd;
        }
    }

    public BpfMap(@NonNull String path, int flag, Class<K> key, Class<V> value) throws ErrnoException, NullPointerException {
        this.mKeyClass = key;
        this.mValueClass = value;
        this.mKeySize = Struct.getSize(key);
        this.mValueSize = Struct.getSize(value);
        this.mMapFd = BpfMap.cachedBpfFdGet(path, flag, this.mKeySize, this.mValueSize);
    }

    public BpfMap(@NonNull String path, Class<K> key, Class<V> value) throws ErrnoException, NullPointerException {
        this(path, 0, key, value);
    }

    @Override
    public void updateEntry(K key, V value) throws ErrnoException {
        this.nativeWriteToMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), ((Struct)value).writeToBytes(), 0);
    }

    @Override
    public void insertEntry(K key, V value) throws ErrnoException, IllegalStateException {
        try {
            this.nativeWriteToMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), ((Struct)value).writeToBytes(), 1);
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.EEXIST) {
                throw new IllegalStateException(key + " already exists");
            }
            throw e;
        }
    }

    @Override
    public void replaceEntry(K key, V value) throws ErrnoException, NoSuchElementException {
        try {
            this.nativeWriteToMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), ((Struct)value).writeToBytes(), 2);
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.ENOENT) {
                throw new NoSuchElementException(key + " not found");
            }
            throw e;
        }
    }

    @Override
    public boolean insertOrReplaceEntry(K key, V value) throws ErrnoException {
        try {
            this.nativeWriteToMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), ((Struct)value).writeToBytes(), 1);
            return true;
        }
        catch (ErrnoException e) {
            if (e.errno != OsConstants.EEXIST) {
                throw e;
            }
            try {
                this.nativeWriteToMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), ((Struct)value).writeToBytes(), 2);
                return false;
            }
            catch (ErrnoException e2) {
                if (e2.errno != OsConstants.ENOENT) {
                    throw e2;
                }
                return false;
            }
        }
    }

    @Override
    public boolean deleteEntry(K key) throws ErrnoException {
        return this.nativeDeleteMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes());
    }

    private K getNextKeyInternal(@Nullable K key) throws ErrnoException {
        byte[] rawKey = new byte[this.mKeySize];
        if (!this.nativeGetNextMapKey(this.mMapFd.getFd(), key == null ? null : ((Struct)key).writeToBytes(), rawKey)) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(rawKey);
        buffer.order(ByteOrder.nativeOrder());
        return (K)((Struct)Struct.parse(this.mKeyClass, buffer));
    }

    @Override
    public K getNextKey(@NonNull K key) throws ErrnoException {
        Objects.requireNonNull(key);
        return this.getNextKeyInternal(key);
    }

    @Override
    public K getFirstKey() throws ErrnoException {
        return this.getNextKeyInternal(null);
    }

    @Override
    public boolean containsKey(@NonNull K key) throws ErrnoException {
        Objects.requireNonNull(key);
        byte[] rawValue = new byte[this.mValueSize];
        return this.nativeFindMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), rawValue);
    }

    @Override
    public V getValue(@NonNull K key) throws ErrnoException {
        Objects.requireNonNull(key);
        byte[] rawValue = new byte[this.mValueSize];
        if (!this.nativeFindMapEntry(this.mMapFd.getFd(), ((Struct)key).writeToBytes(), rawValue)) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(rawValue);
        buffer.order(ByteOrder.nativeOrder());
        return (V)((Struct)Struct.parse(this.mValueClass, buffer));
    }

    public static void synchronizeKernelRCU() throws ErrnoException {
        BpfMap.nativeSynchronizeKernelRCU();
    }

    private static int nativeBpfFdGet(String string2, int n, int n2, int n3) throws ErrnoException, NullPointerException {
        return OverrideMethod.invokeI("android.net.connectivity.com.android.net.module.util.BpfMap#nativeBpfFdGet(Ljava/lang/String;III)I", true, null);
    }

    private void nativeWriteToMapEntry(int n, byte[] byArray, byte[] byArray2, int n2) throws ErrnoException {
        OverrideMethod.invokeV("android.net.connectivity.com.android.net.module.util.BpfMap#nativeWriteToMapEntry(I[B[BI)V", true, this);
    }

    private boolean nativeDeleteMapEntry(int n, byte[] byArray) throws ErrnoException {
        return OverrideMethod.invokeI("android.net.connectivity.com.android.net.module.util.BpfMap#nativeDeleteMapEntry(I[B)Z", true, this) != 0;
    }

    private boolean nativeGetNextMapKey(int n, byte[] byArray, byte[] byArray2) throws ErrnoException {
        return OverrideMethod.invokeI("android.net.connectivity.com.android.net.module.util.BpfMap#nativeGetNextMapKey(I[B[B)Z", true, this) != 0;
    }

    private boolean nativeFindMapEntry(int n, byte[] byArray, byte[] byArray2) throws ErrnoException {
        return OverrideMethod.invokeI("android.net.connectivity.com.android.net.module.util.BpfMap#nativeFindMapEntry(I[B[B)Z", true, this) != 0;
    }

    private static void nativeSynchronizeKernelRCU() throws ErrnoException {
        OverrideMethod.invokeV("android.net.connectivity.com.android.net.module.util.BpfMap#nativeSynchronizeKernelRCU()V", true, null);
    }

    static {
        System_Delegate.loadLibrary(JniUtil.getJniLibraryName(BpfMap.class.getPackage()));
        sFdCache = new ConcurrentHashMap();
    }
}

