/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.thread;

import android.net.thread.ActiveOperationalDataset;
import android.net.thread.PendingOperationalDataset;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IOperationalDatasetCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.thread.IOperationalDatasetCallback";

    public void onActiveOperationalDatasetChanged(ActiveOperationalDataset var1) throws RemoteException;

    public void onPendingOperationalDatasetChanged(PendingOperationalDataset var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOperationalDatasetCallback {
        static final int TRANSACTION_onActiveOperationalDatasetChanged = 1;
        static final int TRANSACTION_onPendingOperationalDatasetChanged = 2;

        public Stub() {
            this.attachInterface(this, IOperationalDatasetCallback.DESCRIPTOR);
        }

        public static IOperationalDatasetCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOperationalDatasetCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOperationalDatasetCallback) {
                return (IOperationalDatasetCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onActiveOperationalDatasetChanged";
                }
                case 2: {
                    return "onPendingOperationalDatasetChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOperationalDatasetCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ActiveOperationalDataset _arg0 = data.readTypedObject(ActiveOperationalDataset.CREATOR);
                    data.enforceNoDataAvail();
                    this.onActiveOperationalDatasetChanged(_arg0);
                    break;
                }
                case 2: {
                    PendingOperationalDataset _arg0 = data.readTypedObject(PendingOperationalDataset.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPendingOperationalDatasetChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IOperationalDatasetCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOperationalDatasetCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActiveOperationalDatasetChanged(ActiveOperationalDataset activeOpDataset) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOperationalDatasetCallback.DESCRIPTOR);
                    _data.writeTypedObject(activeOpDataset, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPendingOperationalDatasetChanged(PendingOperationalDataset pendingOpDataset) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOperationalDatasetCallback.DESCRIPTOR);
                    _data.writeTypedObject(pendingOpDataset, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOperationalDatasetCallback {
        @Override
        public void onActiveOperationalDatasetChanged(ActiveOperationalDataset activeOpDataset) throws RemoteException {
        }

        @Override
        public void onPendingOperationalDatasetChanged(PendingOperationalDataset pendingOpDataset) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

