/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.mdns.aidl;

import android.net.connectivity.android.net.mdns.aidl.DiscoveryInfo;
import android.net.connectivity.android.net.mdns.aidl.GetAddressInfo;
import android.net.connectivity.android.net.mdns.aidl.RegistrationInfo;
import android.net.connectivity.android.net.mdns.aidl.ResolutionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMDnsEventListener
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "ae4cfe565d66acc7d816aabd0dfab991e64031ab";
    public static final String DESCRIPTOR = "android$net$mdns$aidl$IMDnsEventListener".replace('$', '.');
    public static final int SERVICE_DISCOVERY_FAILED = 602;
    public static final int SERVICE_FOUND = 603;
    public static final int SERVICE_LOST = 604;
    public static final int SERVICE_REGISTRATION_FAILED = 605;
    public static final int SERVICE_REGISTERED = 606;
    public static final int SERVICE_RESOLUTION_FAILED = 607;
    public static final int SERVICE_RESOLVED = 608;
    public static final int SERVICE_GET_ADDR_FAILED = 611;
    public static final int SERVICE_GET_ADDR_SUCCESS = 612;

    public void onServiceRegistrationStatus(RegistrationInfo var1) throws RemoteException;

    public void onServiceDiscoveryStatus(DiscoveryInfo var1) throws RemoteException;

    public void onServiceResolutionStatus(ResolutionInfo var1) throws RemoteException;

    public void onGettingServiceAddressStatus(GetAddressInfo var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMDnsEventListener {
        static final int TRANSACTION_onServiceRegistrationStatus = 1;
        static final int TRANSACTION_onServiceDiscoveryStatus = 2;
        static final int TRANSACTION_onServiceResolutionStatus = 3;
        static final int TRANSACTION_onGettingServiceAddressStatus = 4;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMDnsEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMDnsEventListener) {
                return (IMDnsEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    RegistrationInfo _arg0 = data.readTypedObject(RegistrationInfo.CREATOR);
                    this.onServiceRegistrationStatus(_arg0);
                    break;
                }
                case 2: {
                    DiscoveryInfo _arg0 = data.readTypedObject(DiscoveryInfo.CREATOR);
                    this.onServiceDiscoveryStatus(_arg0);
                    break;
                }
                case 3: {
                    ResolutionInfo _arg0 = data.readTypedObject(ResolutionInfo.CREATOR);
                    this.onServiceResolutionStatus(_arg0);
                    break;
                }
                case 4: {
                    GetAddressInfo _arg0 = data.readTypedObject(GetAddressInfo.CREATOR);
                    this.onGettingServiceAddressStatus(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMDnsEventListener {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceRegistrationStatus(RegistrationInfo status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status) {
                        throw new RemoteException("Method onServiceRegistrationStatus is unimplemented.");
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDiscoveryStatus(DiscoveryInfo status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status) {
                        throw new RemoteException("Method onServiceDiscoveryStatus is unimplemented.");
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceResolutionStatus(ResolutionInfo status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status) {
                        throw new RemoteException("Method onServiceResolutionStatus is unimplemented.");
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGettingServiceAddressStatus(GetAddressInfo status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status) {
                        throw new RemoteException("Method onGettingServiceAddressStatus is unimplemented.");
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IMDnsEventListener {
        @Override
        public void onServiceRegistrationStatus(RegistrationInfo status) throws RemoteException {
        }

        @Override
        public void onServiceDiscoveryStatus(DiscoveryInfo status) throws RemoteException {
        }

        @Override
        public void onServiceResolutionStatus(ResolutionInfo status) throws RemoteException {
        }

        @Override
        public void onGettingServiceAddressStatus(GetAddressInfo status) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

