/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SystemApi
public class WebAddress {
    @UnsupportedAppUsage
    private String mScheme;
    @UnsupportedAppUsage
    private String mHost;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mPort;
    @UnsupportedAppUsage
    private String mPath;
    private String mAuthInfo;
    static final int MATCH_GROUP_SCHEME = 1;
    static final int MATCH_GROUP_AUTHORITY = 2;
    static final int MATCH_GROUP_HOST = 3;
    static final int MATCH_GROUP_PORT = 4;
    static final int MATCH_GROUP_PATH = 5;
    static Pattern sAddressPattern = Pattern.compile("(?:(http|https|file)\\:\\/\\/)?(?:([-A-Za-z0-9$_.+!*'(),;?&=]+(?:\\:[-A-Za-z0-9$_.+!*'(),;?&=]+)?)@)?([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_-][a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_\\.-]*|\\[[0-9a-fA-F:\\.]+\\])?(?:\\:([0-9]*))?(\\/?[^#]*)?.*", 2);

    public WebAddress(String address) throws ParseException {
        if (address == null) {
            throw new NullPointerException();
        }
        this.mScheme = "";
        this.mHost = "";
        this.mPort = -1;
        this.mPath = "/";
        this.mAuthInfo = "";
        Matcher m = sAddressPattern.matcher(address);
        if (m.matches()) {
            String t = m.group(1);
            if (t != null) {
                this.mScheme = t.toLowerCase(Locale.ROOT);
            }
            if ((t = m.group(2)) != null) {
                this.mAuthInfo = t;
            }
            if ((t = m.group(3)) != null) {
                this.mHost = t;
            }
            if ((t = m.group(4)) != null && t.length() > 0) {
                try {
                    this.mPort = Integer.parseInt(t);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Bad port");
                }
            }
            if ((t = m.group(5)) != null && t.length() > 0) {
                this.mPath = t.charAt(0) == '/' ? t : "/" + t;
            }
        } else {
            throw new ParseException("Bad address");
        }
        if (this.mPort == 443 && this.mScheme.equals("")) {
            this.mScheme = "https";
        } else if (this.mPort == -1) {
            this.mPort = this.mScheme.equals("https") ? 443 : 80;
        }
        if (this.mScheme.equals("")) {
            this.mScheme = "http";
        }
    }

    @NonNull
    public String toString() {
        String port = "";
        if (this.mPort != 443 && this.mScheme.equals("https") || this.mPort != 80 && this.mScheme.equals("http")) {
            port = ":" + Integer.toString(this.mPort);
        }
        String authInfo = "";
        if (this.mAuthInfo.length() > 0) {
            authInfo = this.mAuthInfo + "@";
        }
        return this.mScheme + "://" + authInfo + this.mHost + port + this.mPath;
    }

    public void setScheme(String scheme) {
        this.mScheme = scheme;
    }

    @UnsupportedAppUsage
    public String getScheme() {
        return this.mScheme;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setHost(String host) {
        this.mHost = host;
    }

    @UnsupportedAppUsage
    public String getHost() {
        return this.mHost;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    @UnsupportedAppUsage
    public int getPort() {
        return this.mPort;
    }

    @UnsupportedAppUsage
    public void setPath(String path) {
        this.mPath = path;
    }

    @UnsupportedAppUsage
    public String getPath() {
        return this.mPath;
    }

    public void setAuthInfo(String authInfo) {
        this.mAuthInfo = authInfo;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getAuthInfo() {
        return this.mAuthInfo;
    }
}

